/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.forgerock.audit.batch.CommonAuditBatchConfiguration;
import org.forgerock.audit.handlers.jms.BatchPublisherConfiguration;
import org.forgerock.audit.handlers.jms.Publisher;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.util.Reject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BatchPublisher<T>
implements Publisher<T> {
    private static final Logger logger = LoggerFactory.getLogger(BatchPublisher.class);
    private final BlockingQueue<T> queue;
    private final ExecutorService executorService;
    private final long insertTimeoutSec;
    private final long shutdownTimeoutSec;
    private volatile boolean stopRequested;
    private final int maxBatchedEvents;

    public BatchPublisher(final String name, BatchPublisherConfiguration configuration) {
        Reject.ifNull((Object)configuration, (String)"Batch configuration can't be null.");
        Reject.ifFalse((configuration.getThreadCount() > 0 ? 1 : 0) != 0, (String)"ThreadCount must be greater than 0");
        Reject.ifFalse((configuration.getCapacity() > 0 ? 1 : 0) != 0, (String)"Capacity must be greater than 0");
        Reject.ifFalse((configuration.getMaxBatchedEvents() > 0 ? 1 : 0) != 0, (String)"MaxBatchedEvents must be greater than 0");
        this.queue = new LinkedBlockingQueue<T>(configuration.getCapacity());
        this.maxBatchedEvents = configuration.getMaxBatchedEvents();
        this.insertTimeoutSec = configuration.getInsertTimeoutSec();
        this.shutdownTimeoutSec = configuration.getShutdownTimeoutSec();
        this.stopRequested = false;
        this.executorService = Executors.newFixedThreadPool(configuration.getThreadCount(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, name);
            }
        });
    }

    protected abstract void startupPublisher() throws ResourceException;

    protected abstract void shutdownPublisher() throws ResourceException;

    protected abstract void publishMessages(List<T> var1);

    @Override
    public final void startup() throws ResourceException {
        this.stopRequested = false;
        this.executorService.execute(new PublishTask());
        this.startupPublisher();
    }

    @Override
    public final void shutdown() throws ResourceException {
        this.stopRequested = true;
        this.executorService.shutdown();
        boolean interrupted = false;
        while (!this.executorService.isTerminated()) {
            try {
                this.executorService.awaitTermination(this.shutdownTimeoutSec, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        this.shutdownPublisher();
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public final void publish(T message) {
        boolean interrupted = false;
        while (!this.stopRequested) {
            try {
                if (this.queue.offer(message, this.insertTimeoutSec, TimeUnit.SECONDS)) break;
                logger.info(this.getClass() + " was blocked from queueing. Perhaps more worker threads are needed.");
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private class PublishTask
    implements Runnable {
        private PublishTask() {
        }

        @Override
        public void run() {
            ArrayList drainList = new ArrayList(BatchPublisher.this.maxBatchedEvents);
            boolean interrupted = false;
            while (!BatchPublisher.this.stopRequested || !BatchPublisher.this.queue.isEmpty()) {
                try {
                    BatchPublisher.this.queue.drainTo(drainList, BatchPublisher.this.maxBatchedEvents);
                    if (drainList.isEmpty()) {
                        Object message = BatchPublisher.this.queue.poll(100L, CommonAuditBatchConfiguration.POLLING_TIMEOUT_UNIT);
                        if (message == null) continue;
                        BatchPublisher.this.publishMessages(Collections.singletonList(message));
                        continue;
                    }
                    BatchPublisher.this.publishMessages(drainList);
                    drainList.clear();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

