/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jdbc;

import java.util.LinkedList;
import java.util.List;
import org.forgerock.audit.handlers.jdbc.AbstractSqlQueryFilterVisitor;
import org.forgerock.audit.handlers.jdbc.StringSqlRenderer;
import org.forgerock.audit.handlers.jdbc.TableMappingParametersPair;
import org.forgerock.json.JsonPointer;
import org.forgerock.util.Utils;
import org.forgerock.util.query.QueryFilter;
import org.forgerock.util.query.QueryFilterVisitor;

class StringSqlQueryFilterVisitor
extends AbstractSqlQueryFilterVisitor<StringSqlRenderer, TableMappingParametersPair> {
    int objectNumber = 0;

    StringSqlQueryFilterVisitor() {
    }

    private StringSqlRenderer visitCompositeFilter(TableMappingParametersPair parameters, List<QueryFilter<JsonPointer>> subFilters, String operand) {
        String operandDelimiter = " " + operand + " ";
        LinkedList<String> subFilterValues = new LinkedList<String>();
        for (QueryFilter<JsonPointer> subFilter : subFilters) {
            subFilterValues.add(((StringSqlRenderer)subFilter.accept((QueryFilterVisitor)this, (Object)parameters)).toSql());
        }
        return new StringSqlRenderer("(").append(Utils.joinAsString((String)operandDelimiter, subFilterValues)).append(")");
    }

    @Override
    public StringSqlRenderer visitAndFilter(TableMappingParametersPair parameters, List<QueryFilter<JsonPointer>> subFilters) {
        return this.visitCompositeFilter(parameters, subFilters, "AND");
    }

    @Override
    public StringSqlRenderer visitOrFilter(TableMappingParametersPair parameters, List<QueryFilter<JsonPointer>> subFilters) {
        return this.visitCompositeFilter(parameters, subFilters, "OR");
    }

    @Override
    public StringSqlRenderer visitBooleanLiteralFilter(TableMappingParametersPair parameters, boolean value) {
        return new StringSqlRenderer(value ? "1 = 1" : "1 <> 1");
    }

    @Override
    public StringSqlRenderer visitNotFilter(TableMappingParametersPair parameters, QueryFilter<JsonPointer> subFilter) {
        return new StringSqlRenderer("NOT ").append(((StringSqlRenderer)subFilter.accept((QueryFilterVisitor)this, (Object)parameters)).toSql());
    }

    @Override
    public StringSqlRenderer visitValueAssertion(TableMappingParametersPair parameters, String operand, JsonPointer field, Object valueAssertion) {
        String value = "${" + field.toString() + "}";
        parameters.getParameters().put(field.toString(), valueAssertion);
        return new StringSqlRenderer(parameters.getColumnName(field) + " " + operand + " " + value);
    }

    @Override
    public StringSqlRenderer visitPresentFilter(TableMappingParametersPair parameters, JsonPointer field) {
        return new StringSqlRenderer(parameters.getColumnName(field) + " IS NOT NULL");
    }
}

