/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jdbc;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.audit.events.handlers.EventHandlerConfiguration;
import org.forgerock.audit.handlers.jdbc.TableMapping;
import org.forgerock.util.Reject;

public class JdbcAuditEventHandlerConfiguration
extends EventHandlerConfiguration {
    @JsonPropertyDescription(value="audit.handlers.jdbc.connectionPool")
    private ConnectionPool connectionPool = new ConnectionPool();
    @JsonProperty(required=true)
    @JsonPropertyDescription(value="audit.handlers.jdbc.tableMappings")
    private List<TableMapping> tableMappings = new LinkedList<TableMapping>();
    @JsonProperty(required=true)
    @JsonPropertyDescription(value="audit.handlers.jdbc.databaseType")
    private String databaseType;
    @JsonPropertyDescription(value="audit.handlers.jdbc.buffering")
    private EventBufferingConfiguration buffering = new EventBufferingConfiguration();

    public List<TableMapping> getTableMappings() {
        if (this.tableMappings == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.tableMappings);
    }

    public void setTableMappings(List<TableMapping> tableMappings) {
        this.tableMappings = tableMappings;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public void setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public boolean isUsableForQueries() {
        return true;
    }

    public EventBufferingConfiguration getBuffering() {
        return this.buffering;
    }

    public void setBufferingConfiguration(EventBufferingConfiguration bufferingConfiguration) {
        this.buffering = bufferingConfiguration;
    }

    public static class EventBufferingConfiguration {
        @JsonPropertyDescription(value="audit.handlers.jdbc.buffering.enabled")
        private boolean enabled = false;
        @JsonPropertyDescription(value="audit.handlers.jdbc.buffering.autoFlush")
        private boolean autoFlush = true;
        @JsonPropertyDescription(value="audit.handlers.jdbc.buffering.maxSize")
        private int maxSize = 5000;
        @JsonPropertyDescription(value="audit.handlers.jdbc.buffering.interval")
        private String writeInterval = "disabled";
        @JsonPropertyDescription(value="audit.handlers.jdbc.buffering.writerThreads")
        private int writerThreads = 1;
        @JsonPropertyDescription(value="audit.handlers.jdbc.buffering.maxBatchedEvents")
        private int maxBatchedEvents = 100;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isAutoFlush() {
            return this.autoFlush;
        }

        public void setAutoFlush(boolean auto) {
            this.autoFlush = auto;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(int maxSize) {
            Reject.ifFalse((maxSize >= 1 ? 1 : 0) != 0);
            this.maxSize = maxSize;
        }

        public String getWriteInterval() {
            return this.writeInterval;
        }

        public void setWriteInterval(String writeInterval) {
            this.writeInterval = writeInterval;
        }

        public int getWriterThreads() {
            return this.writerThreads;
        }

        public void setWriterThreads(int writerThreads) {
            Reject.ifFalse((writerThreads >= 1 ? 1 : 0) != 0);
            this.writerThreads = writerThreads;
        }

        public int getMaxBatchedEvents() {
            return this.maxBatchedEvents;
        }

        public void setMaxBatchedEvents(int maxBatchedEvents) {
            this.maxBatchedEvents = maxBatchedEvents;
        }
    }

    public static class ConnectionPool {
        @JsonPropertyDescription(value="audit.handlers.jdbc.connectionPool.dataSourceClassName")
        private String dataSourceClassName;
        @JsonPropertyDescription(value="audit.handlers.jdbc.connectionPool.jdbcUrl")
        private String jdbcUrl;
        @JsonProperty(required=true)
        @JsonPropertyDescription(value="audit.handlers.jdbc.connectionPool.username")
        private String username;
        @JsonProperty(required=true)
        @JsonPropertyDescription(value="audit.handlers.jdbc.connectionPool.password")
        private String password;
        @JsonPropertyDescription(value="audit.handlers.jdbc.connectionPool.autoCommit")
        private boolean autoCommit = true;
        @JsonPropertyDescription(value="audit.handlers.jdbc.connectionPool.connectionTimeout")
        private int connectionTimeout = 30000;
        @JsonPropertyDescription(value="audit.handlers.jdbc.connectionPool.idleTimeout")
        private int idleTimeout = 600000;
        @JsonPropertyDescription(value="audit.handlers.jdbc.connectionPool.maxLifetime")
        private int maxLifetime = 1800000;
        @JsonPropertyDescription(value="audit.handlers.jdbc.connectionPool.minIdle")
        private int minIdle = 10;
        @JsonPropertyDescription(value="audit.handlers.jdbc.connectionPool.maxPoolSize")
        private int maxPoolSize = 10;
        @JsonPropertyDescription(value="audit.handlers.jdbc.connectionPool.poolName")
        private String poolName;
        @JsonPropertyDescription(value="audit.handlers.jdbc.connectionPool.driverClassName")
        private String driverClassName;

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public void setDriverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
        }

        public String getDataSourceClassName() {
            return this.dataSourceClassName;
        }

        public void setDataSourceClassName(String driverClass) {
            this.dataSourceClassName = driverClass;
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }

        public void setJdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public int getMinIdle() {
            return this.minIdle;
        }

        public void setMinIdle(int minIdle) {
            this.minIdle = minIdle;
        }

        public int getMaxLifetime() {
            return this.maxLifetime;
        }

        public void setMaxLifetime(int maxLifetime) {
            this.maxLifetime = maxLifetime;
        }

        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        public void setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
        }

        public int getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public void setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public boolean getAutoCommit() {
            return this.autoCommit;
        }

        public void setAutoCommit(boolean autoCommit) {
            this.autoCommit = autoCommit;
        }
    }
}

