/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.forgerock.audit.AuditException;
import org.forgerock.audit.handlers.jdbc.CleanupHelper;
import org.forgerock.audit.handlers.jdbc.JdbcAuditEvent;
import org.forgerock.audit.handlers.jdbc.JdbcAuditEventExecutor;
import org.forgerock.audit.handlers.jdbc.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JdbcAuditEventExecutorImpl
implements JdbcAuditEventExecutor {
    private static final Logger logger = LoggerFactory.getLogger(JdbcAuditEventExecutorImpl.class);
    private final DataSource dataSource;

    public JdbcAuditEventExecutorImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private List<Map<String, Object>> execute(JdbcAuditEvent event) throws AuditException {
        logger.debug("Publishing event");
        Connection connection = null;
        try {
            List<Map<String, Object>> results;
            connection = this.dataSource.getConnection();
            if (connection == null) {
                logger.error("Unable to get a datasource connection");
                throw new AuditException("Unable to get a datasource connection");
            }
            connection.setAutoCommit(false);
            try (Object preparedStatement = connection.prepareStatement(event.getSql());){
                JdbcUtils.initializePreparedStatement((PreparedStatement)preparedStatement, event.getParams());
                logger.debug("Executing prepared statement");
                preparedStatement.execute();
                results = this.convertResultSetToList(preparedStatement.getResultSet());
                CleanupHelper.commit(connection);
            }
            preparedStatement = results;
            return preparedStatement;
        }
        catch (JsonProcessingException | SQLException | AuditException e) {
            logger.error("Unable to publish audit event", e);
            if (connection != null) {
                CleanupHelper.rollback(connection);
            }
            throw new AuditException("Unable to publish audit event", e);
        }
        finally {
            CleanupHelper.close(connection);
        }
    }

    private List<Map<String, Object>> convertResultSetToList(ResultSet resultSet) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (resultSet == null) {
            return list;
        }
        ResultSetMetaData md = resultSet.getMetaData();
        int columns = md.getColumnCount();
        while (resultSet.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>(columns);
            for (int i = 1; i <= columns; ++i) {
                row.put(md.getColumnName(i).toLowerCase(), this.getResultSetObject(resultSet, md.getColumnType(i), i));
            }
            list.add(row);
        }
        return list;
    }

    private Object getResultSetObject(ResultSet resultSet, int type, int column) throws SQLException {
        switch (type) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return resultSet.getInt(column);
            }
            case 6: {
                return Float.valueOf(resultSet.getFloat(column));
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 12: 
            case 2005: 
            case 2011: {
                return resultSet.getString(column);
            }
            case 16: {
                return resultSet.getBoolean(column);
            }
        }
        return resultSet.getString(column);
    }

    @Override
    public void createAuditEvent(JdbcAuditEvent event) throws AuditException {
        this.execute(event);
    }

    @Override
    public List<Map<String, Object>> readAuditEvent(JdbcAuditEvent event) throws AuditException {
        return this.execute(event);
    }

    @Override
    public List<Map<String, Object>> queryAuditEvent(JdbcAuditEvent event) throws AuditException {
        return this.execute(event);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

