/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.splunk;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import org.forgerock.audit.events.handlers.EventHandlerConfiguration;

public final class SplunkAuditEventHandlerConfiguration
extends EventHandlerConfiguration {
    @JsonPropertyDescription(value="audit.handlers.splunk.connection")
    private ConnectionConfiguration connection = new ConnectionConfiguration();
    @JsonPropertyDescription(value="audit.handlers.splunk.buffering")
    private BufferingConfiguration buffering = new BufferingConfiguration();
    @JsonPropertyDescription(value="audit.handlers.splunk.authzToken")
    private String authzToken;

    public BufferingConfiguration getBuffering() {
        return this.buffering;
    }

    public void setBuffering(BufferingConfiguration buffering) {
        this.buffering = buffering;
    }

    public ConnectionConfiguration getConnection() {
        return this.connection;
    }

    public void setConnection(ConnectionConfiguration connection) {
        this.connection = connection;
    }

    public String getAuthzToken() {
        return this.authzToken;
    }

    public void setAuthzToken(String authzToken) {
        this.authzToken = authzToken;
    }

    public boolean isUsableForQueries() {
        return false;
    }

    public static final class BufferingConfiguration {
        @JsonPropertyDescription(value="audit.handlers.splunk.buffering.maxSize")
        private int maxSize;
        @JsonPropertyDescription(value="audit.handlers.splunk.buffering.writeInterval")
        private String writeInterval;
        @JsonPropertyDescription(value="audit.handlers.splunk.buffering.maxBatchedEvents")
        private int maxBatchedEvents;

        public int getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }

        public String getWriteInterval() {
            return this.writeInterval;
        }

        public void setWriteInterval(String writeInterval) {
            this.writeInterval = writeInterval;
        }

        public int getMaxBatchedEvents() {
            return this.maxBatchedEvents;
        }

        public void setMaxBatchedEvents(int maxBatchedEvents) {
            this.maxBatchedEvents = maxBatchedEvents;
        }
    }

    public static final class ConnectionConfiguration {
        private static final String DEFAULT_HOST = "localhost";
        private static final int DEFAULT_PORT = 8088;
        @JsonPropertyDescription(value="audit.handlers.splunk.connection.useSSL")
        private boolean useSSL;
        @JsonPropertyDescription(value="audit.handlers.splunk.connection.host")
        private String host;
        @JsonPropertyDescription(value="audit.handlers.splunk.connection.port")
        private int port;

        public boolean isUseSSL() {
            return this.useSSL;
        }

        public void setUseSSL(boolean useSSL) {
            this.useSSL = useSSL;
        }

        public String getHost() {
            return this.host != null && !this.host.isEmpty() ? this.host : DEFAULT_HOST;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port > 0 ? this.port : 8088;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }
}

