/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import java.util.Map;
import org.forgerock.json.JsonValue;
import org.forgerock.util.Function;
import org.forgerock.util.i18n.LocalizableString;
import org.forgerock.util.promise.NeverThrowsException;

public class TranslateJsonSchema
implements Function<JsonValue, JsonValue, NeverThrowsException> {
    private final ClassLoader loader;

    public TranslateJsonSchema(ClassLoader loader) {
        this.loader = loader;
    }

    public JsonValue apply(JsonValue value) {
        JsonValue returnValue = value;
        if (value.isCollection()) {
            JsonValue transformedValue = JsonValue.json((Object)JsonValue.array((Object[])new Object[0]));
            for (JsonValue item : value) {
                transformedValue.add(((JsonValue)item.as((Function)this)).getObject());
            }
            returnValue = transformedValue;
        } else if (value.isMap()) {
            JsonValue transformedValue = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[0]));
            for (String key : value.keys()) {
                transformedValue.put(key, ((JsonValue)value.get(key).as((Function)this)).getObject());
            }
            returnValue = transformedValue;
        } else if (value.isString() && value.asString().startsWith("i18n:")) {
            returnValue = JsonValue.json((Object)new LocalizableString(value.asString(), this.loader));
        }
        return returnValue;
    }
}

