/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.forgerock.api.ApiValidationException;
import org.forgerock.api.annotations.Actions;
import org.forgerock.api.annotations.CollectionProvider;
import org.forgerock.api.annotations.Handler;
import org.forgerock.api.annotations.Queries;
import org.forgerock.api.annotations.RequestHandler;
import org.forgerock.api.annotations.SingletonProvider;
import org.forgerock.api.models.Action;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.Create;
import org.forgerock.api.models.Delete;
import org.forgerock.api.models.Items;
import org.forgerock.api.models.Operation;
import org.forgerock.api.models.Parameter;
import org.forgerock.api.models.Patch;
import org.forgerock.api.models.Query;
import org.forgerock.api.models.Read;
import org.forgerock.api.models.Reference;
import org.forgerock.api.models.Schema;
import org.forgerock.api.models.SubResources;
import org.forgerock.api.models.Update;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.util.Reject;
import org.forgerock.util.i18n.LocalizableString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Resource {
    private static final Logger LOGGER = LoggerFactory.getLogger(Resource.class);
    private static final String SERVICES_REFERENCE = "#/services/%s";
    @JsonProperty(value="$ref")
    private final Reference reference;
    private final Schema resourceSchema;
    private final LocalizableString title;
    private final LocalizableString description;
    private final Create create;
    private final Read read;
    private final Update update;
    private final Delete delete;
    private final Patch patch;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Action[] actions;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Query[] queries;
    private final SubResources subresources;
    private final Items items;
    private final Boolean mvccSupported;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Parameter[] parameters;

    private Resource(Builder builder) {
        this.reference = builder.reference;
        this.resourceSchema = builder.resourceSchema;
        this.title = builder.title;
        this.description = builder.description;
        this.create = builder.create;
        this.read = builder.read;
        this.update = builder.update;
        this.delete = builder.delete;
        this.patch = builder.patch;
        this.subresources = builder.subresources;
        this.actions = builder.actions.toArray(new Action[builder.actions.size()]);
        this.queries = builder.queries.toArray(new Query[builder.queries.size()]);
        this.items = builder.items;
        this.mvccSupported = builder.mvccSupported;
        this.parameters = builder.parameters.toArray(new Parameter[builder.parameters.size()]);
        if (!(this.create == null && this.read == null && this.update == null && this.delete == null && this.patch == null && ValidationUtil.isEmpty(this.actions) && ValidationUtil.isEmpty(this.queries) || this.reference == null)) {
            throw new ApiValidationException("Cannot have a reference as well as operations");
        }
        if (this.mvccSupported == null && this.reference == null) {
            throw new ApiValidationException("mvccSupported required for non-reference Resources");
        }
    }

    public Schema getResourceSchema() {
        return this.resourceSchema;
    }

    public LocalizableString getTitle() {
        return this.title;
    }

    public LocalizableString getDescription() {
        return this.description;
    }

    public Create getCreate() {
        return this.create;
    }

    public Read getRead() {
        return this.read;
    }

    public Update getUpdate() {
        return this.update;
    }

    public Delete getDelete() {
        return this.delete;
    }

    public Patch getPatch() {
        return this.patch;
    }

    public Action[] getActions() {
        return this.actions;
    }

    public Query[] getQueries() {
        return this.queries;
    }

    public SubResources getSubresources() {
        return this.subresources;
    }

    public Reference getReference() {
        return this.reference;
    }

    public Items getItems() {
        return this.items;
    }

    public Boolean isMvccSupported() {
        return this.mvccSupported;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return Objects.equals(this.reference, resource.reference) && Objects.equals(this.resourceSchema, resource.resourceSchema) && Objects.equals(this.title, resource.title) && Objects.equals(this.description, resource.description) && Objects.equals(this.create, resource.create) && Objects.equals(this.read, resource.read) && Objects.equals(this.update, resource.update) && Objects.equals(this.delete, resource.delete) && Objects.equals(this.patch, resource.patch) && Arrays.equals(this.actions, resource.actions) && Arrays.equals(this.queries, resource.queries) && Objects.equals(this.subresources, resource.subresources) && Objects.equals(this.items, resource.items) && Objects.equals(this.mvccSupported, resource.mvccSupported) && Arrays.equals(this.parameters, resource.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.reference, this.resourceSchema, this.title, this.description, this.create, this.read, this.update, this.delete, this.patch, this.actions, this.queries, this.subresources, this.items, this.mvccSupported, this.parameters);
    }

    public static Builder resource() {
        return new Builder();
    }

    public static Resource fromAnnotatedType(Class<?> type, AnnotatedTypeVariant variant, ApiDescription descriptor) {
        return Resource.fromAnnotatedType(type, variant, null, null, descriptor, new Parameter[0]);
    }

    public static Resource fromAnnotatedType(Class<?> type, AnnotatedTypeVariant variant, SubResources subResources, ApiDescription descriptor, Parameter ... extraParameters) {
        return Resource.fromAnnotatedType(type, variant, subResources, null, descriptor, extraParameters);
    }

    public static Resource fromAnnotatedType(Class<?> type, AnnotatedTypeVariant variant, Items items, ApiDescription descriptor, Parameter ... extraParameters) {
        return Resource.fromAnnotatedType(type, variant, null, items, descriptor, extraParameters);
    }

    private static Resource fromAnnotatedType(Class<?> type, AnnotatedTypeVariant variant, SubResources subResources, Items items, ApiDescription descriptor, Parameter ... extraParameters) {
        Builder builder = Resource.resource();
        Handler handler = Resource.findHandlerAnnotation(variant, type);
        if (handler == null) {
            return null;
        }
        boolean foundCrudpq = false;
        for (Method m : type.getMethods()) {
            Queries queries;
            org.forgerock.api.annotations.Create create;
            Actions actions;
            boolean instanceMethod = Arrays.asList(m.getParameterTypes()).indexOf(String.class) > -1;
            org.forgerock.api.annotations.Action action = m.getAnnotation(org.forgerock.api.annotations.Action.class);
            if (action != null && instanceMethod == variant.actionRequiresId) {
                builder.actions.add(Action.fromAnnotation(action, m, descriptor, type));
            }
            if ((actions = m.getAnnotation(Actions.class)) != null && instanceMethod == variant.actionRequiresId) {
                for (org.forgerock.api.annotations.Action a : actions.value()) {
                    builder.actions.add(Action.fromAnnotation(a, null, descriptor, type));
                }
            }
            if ((create = m.getAnnotation(org.forgerock.api.annotations.Create.class)) != null) {
                builder.create = Create.fromAnnotation(create, variant.instanceCreate, descriptor, type);
                foundCrudpq = true;
            }
            if (variant.rudpOperations) {
                org.forgerock.api.annotations.Patch patch;
                org.forgerock.api.annotations.Delete delete;
                org.forgerock.api.annotations.Update update;
                org.forgerock.api.annotations.Read read = m.getAnnotation(org.forgerock.api.annotations.Read.class);
                if (read != null) {
                    builder.read = Read.fromAnnotation(read, descriptor, type);
                    foundCrudpq = true;
                }
                if ((update = m.getAnnotation(org.forgerock.api.annotations.Update.class)) != null) {
                    builder.update = Update.fromAnnotation(update, descriptor, type);
                    foundCrudpq = true;
                }
                if ((delete = m.getAnnotation(org.forgerock.api.annotations.Delete.class)) != null) {
                    builder.delete = Delete.fromAnnotation(delete, descriptor, type);
                    foundCrudpq = true;
                }
                if ((patch = m.getAnnotation(org.forgerock.api.annotations.Patch.class)) != null) {
                    builder.patch = Patch.fromAnnotation(patch, descriptor, type);
                    foundCrudpq = true;
                }
            }
            if (!variant.queryOperations) continue;
            org.forgerock.api.annotations.Query query = m.getAnnotation(org.forgerock.api.annotations.Query.class);
            if (query != null) {
                builder.queries.add(Query.fromAnnotation(query, m, descriptor, type));
                foundCrudpq = true;
            }
            if ((queries = m.getAnnotation(Queries.class)) == null) continue;
            for (org.forgerock.api.annotations.Query q : queries.value()) {
                builder.queries.add(Query.fromAnnotation(q, null, descriptor, type));
                foundCrudpq = true;
            }
        }
        Schema resourceSchema = Schema.fromAnnotation(handler.resourceSchema(), descriptor, type);
        if (foundCrudpq && resourceSchema == null) {
            throw new IllegalArgumentException("CRUDPQ operation(s) defined, but no resource schema declared");
        }
        for (org.forgerock.api.annotations.Parameter parameter : handler.parameters()) {
            builder.parameter(Parameter.fromAnnotation(type, parameter));
        }
        for (Parameter param : extraParameters) {
            builder.parameter(param);
        }
        Resource resource = builder.resourceSchema(resourceSchema).mvccSupported(handler.mvccSupported()).title(new LocalizableString(handler.title(), type)).description(new LocalizableString(handler.description(), type)).subresources(subResources).items(items).build();
        if (!handler.id().isEmpty()) {
            descriptor.addService(handler.id(), resource);
            Reference reference = Reference.reference().value(String.format(SERVICES_REFERENCE, handler.id())).build();
            resource = Resource.resource().reference(reference).build();
        }
        return resource;
    }

    private static Handler findHandlerAnnotation(AnnotatedTypeVariant variant, Class<?> type) {
        switch (variant) {
            case SINGLETON_RESOURCE: {
                if (type.getAnnotation(SingletonProvider.class) == null) break;
                return type.getAnnotation(SingletonProvider.class).value();
            }
            case REQUEST_HANDLER: {
                if (type.getAnnotation(RequestHandler.class) == null) break;
                return type.getAnnotation(RequestHandler.class).value();
            }
            default: {
                if (type.getAnnotation(CollectionProvider.class) == null) break;
                return type.getAnnotation(CollectionProvider.class).details();
            }
        }
        LOGGER.info("Asked for Resource for annotated type, but type does not have required RequestHandler annotation. No api descriptor will be available for " + type);
        return null;
    }

    public static final class Builder {
        private Schema resourceSchema;
        private LocalizableString title;
        private LocalizableString description;
        private Create create;
        private Read read;
        private Update update;
        private Delete delete;
        private Patch patch;
        private SubResources subresources;
        private final Set<Action> actions = new TreeSet<Action>();
        private final Set<Query> queries = new TreeSet<Query>();
        private Items items;
        private Boolean mvccSupported;
        private Reference reference;
        private final List<Parameter> parameters = new ArrayList<Parameter>();
        private boolean built = false;

        protected Builder() {
        }

        @JsonProperty(value="$ref")
        public Builder reference(Reference reference) {
            this.checkState();
            this.reference = reference;
            return this;
        }

        @JsonProperty(value="resourceSchema")
        public Builder resourceSchema(Schema resourceSchema) {
            this.checkState();
            this.resourceSchema = resourceSchema;
            return this;
        }

        public Builder title(LocalizableString title) {
            this.title = title;
            return this;
        }

        @JsonProperty(value="title")
        public Builder title(String title) {
            return this.title(new LocalizableString(title));
        }

        public Builder description(LocalizableString description) {
            this.checkState();
            this.description = description;
            return this;
        }

        @JsonProperty(value="description")
        public Builder description(String description) {
            this.checkState();
            return this.description(new LocalizableString(description));
        }

        @JsonProperty(value="create")
        public Builder create(Create create) {
            this.checkState();
            this.create = create;
            return this;
        }

        @JsonProperty(value="read")
        public Builder read(Read read) {
            this.checkState();
            this.read = read;
            return this;
        }

        @JsonProperty(value="update")
        public Builder update(Update update) {
            this.checkState();
            this.update = update;
            return this;
        }

        @JsonProperty(value="delete")
        public Builder delete(Delete delete) {
            this.checkState();
            this.delete = delete;
            return this;
        }

        @JsonProperty(value="patch")
        public Builder patch(Patch patch) {
            this.checkState();
            this.patch = patch;
            return this;
        }

        @JsonProperty(value="actions")
        public Builder actions(List<Action> actions) {
            this.checkState();
            this.actions.addAll(actions);
            return this;
        }

        public Builder action(Action action) {
            this.checkState();
            this.actions.add(action);
            return this;
        }

        @JsonProperty(value="queries")
        public Builder queries(List<Query> queries) {
            this.checkState();
            this.queries.addAll(queries);
            return this;
        }

        public Builder query(Query query) {
            this.checkState();
            this.queries.add(query);
            return this;
        }

        @JsonProperty(value="subresources")
        public Builder subresources(SubResources subresources) {
            this.checkState();
            this.subresources = subresources;
            return this;
        }

        @JsonProperty(value="operations")
        public Builder operations(Operation ... operations) {
            this.checkState();
            Reject.ifNull((Object[])operations);
            for (Operation operation : operations) {
                operation.allocateToResource(this);
            }
            return this;
        }

        @JsonProperty(value="mvccSupported")
        public Builder mvccSupported(Boolean mvccSupported) {
            this.checkState();
            this.mvccSupported = mvccSupported;
            return this;
        }

        @JsonProperty(value="items")
        public Builder items(Items items) {
            this.checkState();
            this.items = items;
            return this;
        }

        @JsonProperty(value="parameters")
        public Builder parameters(List<Parameter> parameters) {
            this.checkState();
            this.parameters.addAll(parameters);
            return this;
        }

        public Builder parameter(Parameter parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public Resource build() {
            this.checkState();
            this.built = true;
            if (this.create == null && this.read == null && this.update == null && this.delete == null && this.patch == null && this.actions.isEmpty() && this.queries.isEmpty() && this.reference == null && this.items == null && this.subresources == null) {
                return null;
            }
            return new Resource(this);
        }

        private void checkState() {
            Reject.rejectStateIfTrue((boolean)this.built, (String)"Already built Resource");
        }
    }

    public static enum AnnotatedTypeVariant {
        SINGLETON_RESOURCE(true, true, false, false),
        COLLECTION_RESOURCE_COLLECTION(false, false, false, true),
        COLLECTION_RESOURCE_INSTANCE(true, true, true, false),
        REQUEST_HANDLER(false, true, false, true);

        private final boolean instanceCreate;
        private final boolean rudpOperations;
        private final boolean actionRequiresId;
        private final boolean queryOperations;

        private AnnotatedTypeVariant(boolean instanceCreate, boolean rudpOperations, boolean actionRequiresId, boolean queryOperations) {
            this.instanceCreate = instanceCreate;
            this.rudpOperations = rudpOperations;
            this.actionRequiresId = actionRequiresId;
            this.queryOperations = queryOperations;
        }
    }
}

