/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.splunk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.UUID;
import org.forgerock.audit.Audit;
import org.forgerock.audit.events.EventTopicsMetaData;
import org.forgerock.audit.events.handlers.AuditEventHandlerBase;
import org.forgerock.audit.events.handlers.buffering.BatchConsumer;
import org.forgerock.audit.events.handlers.buffering.BatchException;
import org.forgerock.audit.events.handlers.buffering.BatchPublisher;
import org.forgerock.audit.events.handlers.buffering.BatchPublisherFactory;
import org.forgerock.audit.events.handlers.buffering.BatchPublisherFactoryImpl;
import org.forgerock.audit.handlers.splunk.SplunkAuditEventHandlerConfiguration;
import org.forgerock.guava.common.base.Strings;
import org.forgerock.http.Client;
import org.forgerock.http.Handler;
import org.forgerock.http.HttpApplicationException;
import org.forgerock.http.apache.async.AsyncHttpClientProvider;
import org.forgerock.http.handler.HttpClientHandler;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Responses;
import org.forgerock.http.spi.Loader;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.ServiceUnavailableException;
import org.forgerock.services.context.Context;
import org.forgerock.util.CloseSilentlyFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Options;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.time.Duration;

public final class SplunkAuditEventHandler
extends AuditEventHandlerBase
implements BatchConsumer {
    private static final int BATCH_INDEX_AVERAGE_PER_EVENT_PAYLOAD_SIZE = 1280;
    private static final boolean ALWAYS_FLUSH_BATCH_QUEUE = true;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final SplunkAuditEventHandlerConfiguration configuration;
    private final Client client;
    private final HttpClientHandler defaultHttpClientHandler;
    private final String channelId;
    private final BatchPublisher batchPublisher;
    private final String serviceUrl;

    public SplunkAuditEventHandler(SplunkAuditEventHandlerConfiguration configuration, EventTopicsMetaData eventTopicsMetaData, @Audit BatchPublisherFactory publisherFactory, @Audit Client client) {
        super(configuration.getName(), eventTopicsMetaData, configuration.getTopics(), configuration.isEnabled());
        Duration writeInterval;
        this.configuration = configuration;
        if (client == null) {
            this.defaultHttpClientHandler = this.defaultHttpClientHandler();
            this.client = new Client((Handler)this.defaultHttpClientHandler);
        } else {
            this.defaultHttpClientHandler = null;
            this.client = client;
        }
        this.channelId = UUID.randomUUID().toString();
        SplunkAuditEventHandlerConfiguration.ConnectionConfiguration connection = configuration.getConnection();
        this.serviceUrl = connection.isUseSSL() ? "https://" : "http://" + configuration.getConnection().getHost() + ':' + configuration.getConnection().getPort() + "/services/collector/raw";
        SplunkAuditEventHandlerConfiguration.BufferingConfiguration bufferingConfiguration = configuration.getBuffering();
        Duration duration = writeInterval = Strings.isNullOrEmpty((String)bufferingConfiguration.getWriteInterval()) ? null : Duration.duration((String)bufferingConfiguration.getWriteInterval());
        if (publisherFactory == null) {
            publisherFactory = new BatchPublisherFactoryImpl();
        }
        this.batchPublisher = publisherFactory.newBufferedPublisher((BatchConsumer)this).capacity(bufferingConfiguration.getMaxSize()).writeInterval(writeInterval).maxBatchEvents(bufferingConfiguration.getMaxBatchedEvents()).averagePerEventPayloadSize(1280).autoFlush(true).build();
    }

    public void startup() throws ResourceException {
        this.batchPublisher.startup();
    }

    public void shutdown() throws ResourceException {
        this.batchPublisher.shutdown();
        if (this.defaultHttpClientHandler != null) {
            try {
                this.defaultHttpClientHandler.close();
            }
            catch (IOException e) {
                throw ResourceException.newResourceException((int)500, (String)"An error occurred while closing the default HTTP client handler", (Throwable)e);
            }
        }
    }

    public Promise<ResourceResponse, ResourceException> publishEvent(Context context, String topic, JsonValue event) {
        String resourceId = event.get("_id").asString();
        if (!this.batchPublisher.offer(topic, event)) {
            return new ServiceUnavailableException("Splunk batch buffer full, dropping audit event " + topic + "/" + resourceId).asPromise();
        }
        return org.forgerock.json.resource.Responses.newResourceResponse((String)resourceId, null, (JsonValue)event).asPromise();
    }

    public Promise<ResourceResponse, ResourceException> readEvent(Context context, String topic, String resourceId) {
        return new NotSupportedException("Read operations are currently not supported by the Splunk handler").asPromise();
    }

    public Promise<QueryResponse, ResourceException> queryEvents(Context context, String topic, QueryRequest query, QueryResourceHandler handler) {
        return new NotSupportedException("Query operations are currently not supported by the Splunk handler").asPromise();
    }

    public void addToBatch(String topic, JsonValue event, StringBuilder payload) throws BatchException {
        event.put("_topic", (Object)topic);
        try {
            String eventJsonString = OBJECT_MAPPER.writeValueAsString(event.getObject());
            payload.append(eventJsonString).append('\n');
        }
        catch (JsonProcessingException e) {
            throw new BatchException("Unable to parse event object to JSON", (Throwable)e);
        }
        finally {
            event.remove("_topic");
        }
    }

    public Promise<Void, BatchException> publishBatch(String payload) {
        Request request = new Request();
        request.setMethod("POST");
        try {
            request.setUri(this.serviceUrl);
        }
        catch (URISyntaxException e) {
            return Promises.newExceptionPromise((Exception)new BatchException("Incorrect URI " + this.serviceUrl, (Throwable)e));
        }
        request.getHeaders().put("Content-Type", (Object)"application/json; charset=UTF-8");
        request.getHeaders().put("Authorization", (Object)("Splunk " + this.configuration.getAuthzToken()));
        request.getHeaders().put("X-Splunk-Request-Channel", (Object)this.channelId);
        request.setEntity((Object)payload);
        return this.client.send(request).then(CloseSilentlyFunction.closeSilently((Function)new Function<Response, Void, BatchException>(){

            public Void apply(Response response) throws BatchException {
                if (!response.getStatus().isSuccessful()) {
                    throw new BatchException("Publishing to Splunk failed: " + response.getEntity());
                }
                return null;
            }
        }), Responses.noopExceptionFunction());
    }

    private HttpClientHandler defaultHttpClientHandler() {
        try {
            return new HttpClientHandler(Options.defaultOptions().set(HttpClientHandler.OPTION_LOADER, (Object)new Loader(){

                public <S> S load(Class<S> service, Options options) {
                    return service.cast(new AsyncHttpClientProvider());
                }
            }));
        }
        catch (HttpApplicationException e) {
            throw new RuntimeException("Error while building default HTTP Client", e);
        }
    }
}

