/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.ldap.tools.LDAPToolException;
import com.forgerock.opendj.ldap.tools.ToolConsoleApplication;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageDescriptor;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.AssertionRequestControl;
import org.forgerock.opendj.ldap.controls.AuthorizationIdentityResponseControl;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.controls.PasswordExpiredResponseControl;
import org.forgerock.opendj.ldap.controls.PasswordExpiringResponseControl;
import org.forgerock.opendj.ldap.controls.PasswordPolicyErrorType;
import org.forgerock.opendj.ldap.controls.PasswordPolicyResponseControl;
import org.forgerock.opendj.ldap.controls.PasswordPolicyWarningType;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.util.annotations.VisibleForTesting;

final class Utils {
    static int printErrorMessage(ConsoleApplication app, LdapException ldapException) {
        return Utils.printErrorMessage(app, ldapException, null);
    }

    static int printErrorMessage(ConsoleApplication app, LdapException ldapException, LocalizableMessageDescriptor.Arg2<Number, Object> errorMsg) {
        return Utils.printErrorMessage(app, ldapException.getResult(), errorMsg);
    }

    static int printErrorMessage(ConsoleApplication app, Result result, LocalizableMessageDescriptor.Arg2<Number, Object> errorMsg) {
        ResultCode resultCode = result.getResultCode();
        int rc = resultCode.intValue();
        if (rc != ResultCode.UNDEFINED.intValue() && errorMsg != null) {
            app.errPrintln(errorMsg.get((Object)rc, (Object)resultCode.toString()));
        }
        Utils.printlnTextMsg(app, ToolsMessages.ERR_TOOL_ERROR_MESSAGE, result.getDiagnosticMessage());
        Utils.printlnTextMsg(app, ToolsMessages.ERR_TOOL_MATCHED_DN, result.getMatchedDN());
        Throwable cause = result.getCause();
        if (app.isVerbose() && cause != null) {
            cause.printStackTrace(app.getErrorStream());
        }
        return rc;
    }

    static void printSuccessMessage(ConsoleApplication app, Result r, String operationType, String dn) {
        app.println(ToolsMessages.INFO_OPERATION_SUCCESSFUL.get((Object)operationType, (Object)dn));
        Utils.printlnTextMsg(app, r.getDiagnosticMessage());
        for (String uri : r.getReferralURIs()) {
            app.println(LocalizableMessage.raw((CharSequence)uri, (Object[])new Object[0]));
        }
    }

    static void printPasswordPolicyResults(ConsoleApplication app, BindResult result) {
        AuthorizationIdentityResponseControl control;
        try {
            control = (AuthorizationIdentityResponseControl)result.getControl(AuthorizationIdentityResponseControl.DECODER, new DecodeOptions());
            if (control != null) {
                app.println(ToolsMessages.INFO_BIND_AUTHZID_RETURNED.get((Object)control.getAuthorizationID()));
            }
        }
        catch (DecodeException e) {
            app.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
        }
        try {
            control = (PasswordExpiredResponseControl)result.getControl(PasswordExpiredResponseControl.DECODER, new DecodeOptions());
            if (control != null) {
                app.println(ToolsMessages.INFO_BIND_PASSWORD_EXPIRED.get());
            }
        }
        catch (DecodeException e) {
            app.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
        }
        try {
            control = (PasswordExpiringResponseControl)result.getControl(PasswordExpiringResponseControl.DECODER, new DecodeOptions());
            if (control != null) {
                app.println(ToolsMessages.INFO_BIND_PASSWORD_EXPIRING.get((Object)com.forgerock.opendj.cli.Utils.secondsToTimeString((int)control.getSecondsUntilExpiration())));
            }
        }
        catch (DecodeException e) {
            app.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
        }
        try {
            control = (PasswordPolicyResponseControl)result.getControl(PasswordPolicyResponseControl.DECODER, new DecodeOptions());
            if (control != null) {
                Utils.printPasswordPolicyError(control.getErrorType(), app);
                Utils.printPasswordPolicyWarning(control.getWarningType(), control.getWarningValue(), app);
            }
        }
        catch (DecodeException e) {
            app.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
        }
    }

    private static void printPasswordPolicyError(PasswordPolicyErrorType errorType, ConsoleApplication app) {
        if (errorType == null) {
            return;
        }
        switch (errorType) {
            case PASSWORD_EXPIRED: {
                app.println(ToolsMessages.INFO_BIND_PASSWORD_EXPIRED.get());
                break;
            }
            case ACCOUNT_LOCKED: {
                app.println(ToolsMessages.INFO_BIND_ACCOUNT_LOCKED.get());
                break;
            }
            case CHANGE_AFTER_RESET: {
                app.println(ToolsMessages.INFO_BIND_MUST_CHANGE_PASSWORD.get());
            }
        }
    }

    private static void printPasswordPolicyWarning(PasswordPolicyWarningType warningType, int warningValue, ConsoleApplication app) {
        if (warningType == null) {
            return;
        }
        switch (warningType) {
            case TIME_BEFORE_EXPIRATION: {
                app.println(ToolsMessages.INFO_BIND_PASSWORD_EXPIRING.get((Object)com.forgerock.opendj.cli.Utils.secondsToTimeString((int)warningValue)));
                break;
            }
            case GRACE_LOGINS_REMAINING: {
                app.println(ToolsMessages.INFO_BIND_GRACE_LOGINS_REMAINING.get((Object)warningValue));
            }
        }
    }

    static void setDefaultPerfToolProperties() {
        if (System.getProperty("org.forgerock.opendj.transport.linger") == null) {
            System.setProperty("org.forgerock.opendj.transport.linger", "0");
        }
    }

    static Filter readFilterFromString(String filterStr) throws LDAPToolException {
        try {
            return Filter.valueOf((String)filterStr);
        }
        catch (LocalizedIllegalArgumentException e) {
            throw LDAPToolException.newToolException((Exception)((Object)e), ResultCode.CLIENT_SIDE_FILTER_ERROR, e.getMessageObject());
        }
    }

    static void parseArguments(ArgumentParser argParser, PrintStream stream, String[] args) throws LDAPToolException {
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException e) {
            argParser.displayMessageAndUsageReference(stream, ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)e.getMessage()));
            throw LDAPToolException.newToolExceptionAlreadyPrinted((Exception)((Object)e), ResultCode.CLIENT_SIDE_PARAM_ERROR);
        }
    }

    static InputStream getLDIFToolInputStream(ConsoleApplication app, String filePath) throws LDAPToolException {
        if (!"-".equals(filePath)) {
            try {
                return new FileInputStream(filePath);
            }
            catch (FileNotFoundException e) {
                throw LDAPToolException.newToolParamException(e, ToolsMessages.ERR_LDIF_FILE_CANNOT_OPEN_FOR_READ.get((Object)filePath, (Object)e.getLocalizedMessage()));
            }
        }
        return app.getInputStream();
    }

    static OutputStream getLDIFToolOutputStream(ConsoleApplication app, StringArgument outputFileArg) throws LDAPToolException {
        String filePath = outputFileArg.getValue();
        if (outputFileArg.isPresent() && !"-".equals(filePath)) {
            try {
                return new FileOutputStream(filePath);
            }
            catch (FileNotFoundException e) {
                throw LDAPToolException.newToolParamException(e, ToolsMessages.ERR_LDIF_FILE_CANNOT_OPEN_FOR_WRITE.get((Object)filePath, (Object)e.getLocalizedMessage()));
            }
        }
        return app.getOutputStream();
    }

    static List<String> getLinesFromFiles(List<String> filePaths) throws LDAPToolException {
        ArrayList<String> filesLines = new ArrayList<String>();
        for (String filePath : filePaths) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(filePath));
                Throwable throwable = null;
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        filesLines.add(line);
                    }
                    filesLines.add("");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException e) {
                throw LDAPToolException.newToolParamException(e, ToolsMessages.ERR_LDIF_FILE_CANNOT_OPEN_FOR_READ.get((Object)filePath, (Object)e.getLocalizedMessage()));
            }
        }
        return filesLines;
    }

    static void addControlsToRequest(Request request, List<Control> controls) throws LDAPToolException {
        for (Control control : controls) {
            request.addControl(control);
        }
    }

    static List<Control> readControls(StringArgument controlArg) throws LDAPToolException {
        LinkedList<Control> controls = new LinkedList<Control>();
        if (controlArg.isPresent()) {
            for (String ctrlString : controlArg.getValues()) {
                try {
                    controls.add((Control)Utils.getControl(ctrlString));
                }
                catch (DecodeException e) {
                    throw LDAPToolException.newToolParamException((Exception)((Object)e), ToolsMessages.ERR_TOOL_INVALID_CONTROL_STRING.get((Object)ctrlString));
                }
            }
        }
        return controls;
    }

    private static GenericControl getControl(String argString) throws DecodeException {
        ByteString controlValue;
        String[] control = argString.split(":");
        int nbControlElements = control.length;
        String controlOID = Utils.readControlID(control[0]);
        if (nbControlElements == 1) {
            return GenericControl.newControl((String)controlOID);
        }
        boolean critic = Utils.readControlCriticality(control[1], argString);
        if (nbControlElements == 2) {
            return GenericControl.newControl((String)controlOID, (boolean)critic);
        }
        if (control[2].isEmpty()) {
            controlValue = ByteString.valueOfBase64((String)control[3]);
        } else if (control[2].startsWith("<")) {
            try {
                controlValue = ByteString.wrap((byte[])com.forgerock.opendj.cli.Utils.readBytesFromFile((String)control[2].substring(1)));
            }
            catch (Exception e) {
                return null;
            }
        } else {
            controlValue = ByteString.valueOfUtf8((CharSequence)control[2]);
        }
        return GenericControl.newControl((String)controlOID, (boolean)critic, (Object)controlValue);
    }

    private static String readControlID(String controlOidStr) {
        switch (controlOidStr.toLowerCase()) {
            case "accountusable": 
            case "accountusability": {
                return "1.3.6.1.4.1.42.2.27.9.5.8";
            }
            case "authzid": 
            case "authorizationidentity": {
                return "2.16.840.1.113730.3.4.16";
            }
            case "pwpolicy": 
            case "passwordpolicy": {
                return "1.3.6.1.4.1.42.2.27.8.5.1";
            }
            case "treedelete": 
            case "subtreedelete": {
                return "1.2.840.113556.1.4.805";
            }
            case "effectiverights": 
            case "geteffectiverights": {
                return "1.3.6.1.4.1.42.2.27.9.5.2";
            }
        }
        return controlOidStr;
    }

    private static boolean readControlCriticality(String criticalityStr, String controlStr) throws DecodeException {
        if ("true".equalsIgnoreCase(criticalityStr)) {
            return true;
        }
        if ("false".equalsIgnoreCase(criticalityStr)) {
            return false;
        }
        throw DecodeException.error((LocalizableMessage)ToolsMessages.ERR_DECODE_CONTROL_CRITICALITY.get((Object)criticalityStr, (Object)controlStr));
    }

    static Control readAssertionControl(String assertionFilter) throws LDAPToolException {
        try {
            return AssertionRequestControl.newControl((boolean)true, (Filter)Filter.valueOf((String)assertionFilter));
        }
        catch (LocalizedIllegalArgumentException e) {
            throw LDAPToolException.newToolParamException((Exception)((Object)e), ToolsMessages.ERR_LDAP_ASSERTION_INVALID_FILTER.get((Object)e.getMessage()));
        }
    }

    static Connection getConnection(ConnectionFactory connectionFactory, BindRequest bindRequest, BooleanArgument dryRunArg, ConsoleApplication app) throws LDAPToolException {
        if (!dryRunArg.isPresent()) {
            try {
                Connection connection = connectionFactory.getConnection();
                if (bindRequest != null) {
                    Utils.printPasswordPolicyResults(app, connection.bind(bindRequest));
                }
                return connection;
            }
            catch (LdapException e) {
                Utils.printErrorMessage(app, e, ToolsMessages.ERR_LDAPP_BIND_FAILED);
                throw LDAPToolException.newToolExceptionAlreadyPrinted((Exception)((Object)e), e.getResult().getResultCode());
            }
        }
        return null;
    }

    static void printlnTextMsg(ConsoleApplication app, String msg) {
        Utils.printlnTextMsg(app, null, msg);
    }

    static void printlnTextMsg(ConsoleApplication app, LocalizableMessageDescriptor.Arg1<Object> localizableMsg, String msg) {
        if (msg != null && !msg.isEmpty()) {
            app.errPrintln(localizableMsg == null ? LocalizableMessage.raw((CharSequence)msg, (Object[])new Object[0]) : localizableMsg.get((Object)msg));
        }
    }

    static int computeWrapColumn(IntegerArgument wrapColumn) throws ArgumentException {
        if (wrapColumn.isPresent()) {
            return wrapColumn.getIntValue();
        }
        return 0;
    }

    static void runToolAndExit(ToolConsoleApplication tool, String[] args) {
        System.exit(com.forgerock.opendj.cli.Utils.filterExitCode((int)Utils.runTool(tool, args)));
    }

    @VisibleForTesting
    static int runTool(ToolConsoleApplication tool, String ... args) {
        try {
            return tool.run(args);
        }
        catch (LDAPToolException e) {
            e.printErrorMessage(tool);
            return e.getResultCode();
        }
    }

    private Utils() {
    }
}

