/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.ConsoleApplication;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ResultCode;

final class LDAPToolException
extends Exception {
    private final ResultCode resultCode;
    private final LocalizableMessage errorMsg;

    static LDAPToolException newToolExceptionAlreadyPrinted(Exception rootException, ResultCode rc) {
        return new LDAPToolException(rootException, rc);
    }

    static LDAPToolException newToolParamException(Exception rootException, LocalizableMessage message) {
        return new LDAPToolException(rootException, ResultCode.CLIENT_SIDE_PARAM_ERROR, message);
    }

    static LDAPToolException newToolParamException(LocalizableMessage message) {
        return new LDAPToolException(null, ResultCode.CLIENT_SIDE_PARAM_ERROR, message);
    }

    static LDAPToolException newToolException(Exception rootException, ResultCode rc, LocalizableMessage message) {
        return new LDAPToolException(rootException, rc, message);
    }

    private LDAPToolException(Exception rootException, ResultCode rc) {
        super(rootException);
        this.resultCode = rc;
        this.errorMsg = null;
    }

    private LDAPToolException(Exception rootException, ResultCode rc, LocalizableMessage errorMsg) {
        super(errorMsg.toString(), rootException);
        this.resultCode = rc;
        this.errorMsg = errorMsg;
    }

    int getResultCode() {
        return this.resultCode.intValue();
    }

    void printErrorMessage(ConsoleApplication console) {
        if (this.errorMsg != null) {
            console.errPrintln(this.errorMsg);
        }
    }
}

