/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.ToolVersionHandler;
import com.forgerock.opendj.ldap.tools.LDAPToolArgumentParser;
import com.forgerock.opendj.ldap.tools.LDAPToolException;
import com.forgerock.opendj.ldap.tools.ToolConsoleApplication;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import java.io.PrintStream;
import java.util.ArrayList;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ProxiedAuthV2RequestControl;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.util.annotations.VisibleForTesting;

public final class LDAPCompare
extends ToolConsoleApplication {
    private BooleanArgument verbose;

    public static void main(String[] args) {
        Utils.runToolAndExit(new LDAPCompare(System.out, System.err), args);
    }

    public static int run(PrintStream out, PrintStream err, String ... args) {
        return Utils.runTool(new LDAPCompare(out, err), args);
    }

    @VisibleForTesting
    LDAPCompare(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    @Override
    int run(String ... args) throws LDAPToolException {
        ByteString attributeVal;
        BooleanArgument scriptFriendly;
        BooleanArgument dryRun;
        StringArgument controlStr;
        BooleanArgument useCompareResultCode;
        StringArgument assertionFilter;
        StringArgument proxyAuthzID;
        ConnectionFactoryProvider connectionFactoryProvider;
        LocalizableMessage toolDescription = ToolsMessages.INFO_LDAPCOMPARE_TOOL_DESCRIPTION.get();
        LDAPToolArgumentParser argParser = LDAPToolArgumentParser.builder(LDAPCompare.class.getName()).toolDescription(toolDescription).trailingArguments(2, 2, "attribute:value DN").build();
        argParser.setVersionHandler(ToolVersionHandler.newSdkVersionHandler());
        argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_LDAPCOMPARE.get());
        try {
            connectionFactoryProvider = new ConnectionFactoryProvider((ArgumentParser)argParser, (ConsoleApplication)this);
            StringArgument propertiesFileArgument = CommonArguments.propertiesFileArgument();
            argParser.addArgument((Argument)propertiesFileArgument);
            argParser.setFilePropertiesArgument(propertiesFileArgument);
            BooleanArgument noPropertiesFileArgument = CommonArguments.noPropertiesFileArgument();
            argParser.addArgument((Argument)noPropertiesFileArgument);
            argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
            proxyAuthzID = CommonArguments.proxyAuthIdArgument();
            argParser.addArgument((Argument)proxyAuthzID);
            assertionFilter = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"assertionFilter").description(ToolsMessages.INFO_DESCRIPTION_ASSERTION_FILTER.get())).valuePlaceholder(ToolsMessages.INFO_ASSERTION_FILTER_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
            useCompareResultCode = (BooleanArgument)((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)"useCompareResultCode").shortIdentifier(Character.valueOf('m'))).description(ToolsMessages.INFO_LDAPCOMPARE_DESCRIPTION_USE_COMPARE_RESULT.get())).buildAndAddToParser((ArgumentParser)argParser);
            controlStr = CommonArguments.controlArgument();
            argParser.addArgument((Argument)controlStr);
            dryRun = CommonArguments.noOpArgument();
            argParser.addArgument((Argument)dryRun);
            this.verbose = CommonArguments.verboseArgument();
            argParser.addArgument((Argument)this.verbose);
            scriptFriendly = CommonArguments.scriptFriendlySdkArgument();
            argParser.addArgument((Argument)scriptFriendly);
            BooleanArgument showUsage = CommonArguments.showUsageArgument();
            argParser.addArgument((Argument)showUsage);
            argParser.setUsageArgument((Argument)showUsage, this.getOutputStream());
        }
        catch (ArgumentException ae) {
            throw LDAPToolException.newToolParamException((Exception)((Object)ae), ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage()));
        }
        argParser.parseArguments(args, this.getErrStream(), connectionFactoryProvider);
        if (argParser.usageOrVersionDisplayed()) {
            return ResultCode.SUCCESS.intValue();
        }
        ArrayList trailingArguments = argParser.getTrailingArguments();
        String attribute = (String)trailingArguments.get(0);
        String dn = (String)trailingArguments.get(1);
        int idx = attribute.indexOf(":");
        if (idx == -1) {
            argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_LDAPCOMPARE_INVALID_ATTR_STRING.get((Object)attribute));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        String attributeType = attribute.substring(0, idx);
        String remainder = attribute.substring(idx + 1, attribute.length());
        if (remainder.length() > 0) {
            char nextChar = remainder.charAt(0);
            if (nextChar == ':') {
                String base64 = remainder.substring(1, remainder.length());
                try {
                    attributeVal = ByteString.valueOfBase64((String)base64);
                }
                catch (LocalizedIllegalArgumentException e) {
                    throw LDAPToolException.newToolParamException((Exception)((Object)e), ToolsMessages.INFO_COMPARE_CANNOT_BASE64_DECODE_ASSERTION_VALUE.get());
                }
            } else if (nextChar == '<') {
                try {
                    String filePath = remainder.substring(1, remainder.length());
                    attributeVal = ByteString.wrap((byte[])com.forgerock.opendj.cli.Utils.readBytesFromFile((String)filePath));
                }
                catch (Exception e) {
                    throw LDAPToolException.newToolParamException(e, ToolsMessages.INFO_COMPARE_CANNOT_READ_ASSERTION_VALUE_FROM_FILE.get((Object)String.valueOf(e)));
                }
            } else {
                attributeVal = ByteString.valueOfUtf8((CharSequence)remainder);
            }
        } else {
            attributeVal = ByteString.valueOfUtf8((CharSequence)remainder);
        }
        CompareRequest compare = Requests.newCompareRequest((String)"", (String)attributeType, (Object)attributeVal);
        Utils.addControlsToRequest((Request)compare, Utils.readControls(controlStr));
        if (proxyAuthzID.isPresent()) {
            compare.addControl((Control)ProxiedAuthV2RequestControl.newControl((String)proxyAuthzID.getValue()));
        }
        if (assertionFilter.isPresent()) {
            compare.addControl(Utils.readAssertionControl(assertionFilter.getValue()));
        }
        try (Connection connection = Utils.getConnection(argParser.getConnectionFactory(), argParser.getBindRequest(), dryRun, this);){
            compare.setName(dn);
            int compareResultCode = this.executeCompare(compare, connection, scriptFriendly.isPresent());
            boolean compareTrue = compareResultCode == ResultCode.COMPARE_TRUE.intValue();
            int n = !useCompareResultCode.isPresent() && compareTrue ? ResultCode.SUCCESS.intValue() : compareResultCode;
            return n;
        }
    }

    private int executeCompare(CompareRequest request, Connection connection, boolean isScriptFriendly) {
        String dnStr = request.getName().toString();
        if (!isScriptFriendly) {
            this.println(ToolsMessages.INFO_PROCESSING_COMPARE_OPERATION.get((Object)request.getAttributeDescription().toString(), (Object)request.getAssertionValueAsString(), (Object)dnStr));
        }
        if (connection == null) {
            return ResultCode.COMPARE_TRUE.intValue();
        }
        try {
            ResultCode resultCode = connection.compare(request).getResultCode();
            if (!isScriptFriendly) {
                this.println(ResultCode.COMPARE_FALSE == resultCode ? ToolsMessages.INFO_COMPARE_OPERATION_RESULT_FALSE.get((Object)dnStr) : ToolsMessages.INFO_COMPARE_OPERATION_RESULT_TRUE.get((Object)dnStr));
            }
            return resultCode.intValue();
        }
        catch (LdapException e) {
            return Utils.printErrorMessage((ConsoleApplication)this, e, ToolsMessages.ERR_LDAP_COMPARE_FAILED);
        }
    }
}

