/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.SubCommand;
import com.forgerock.opendj.cli.SubCommandArgumentParser;
import com.forgerock.opendj.cli.ToolVersionHandler;
import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.ldap.tools.LDAPToolException;
import com.forgerock.opendj.ldap.tools.ToolConsoleApplication;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import com.forgerock.opendj.util.StaticUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.util.annotations.VisibleForTesting;

public final class Base64
extends ToolConsoleApplication {
    public static void main(String[] args) {
        Utils.runToolAndExit(new Base64(System.out, System.err), args);
    }

    @VisibleForTesting
    Base64(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public boolean isInteractive() {
        return false;
    }

    @Override
    int run(String ... args) throws LDAPToolException {
        StringArgument toEncodedFile;
        StringArgument rawFile;
        StringArgument rawData;
        StringArgument toRawFile;
        StringArgument encodedFile;
        StringArgument encodedData;
        SubCommand encodeSubCommand;
        SubCommand decodeSubCommand;
        SubCommandArgumentParser argParser = new SubCommandArgumentParser(Base64.class.getName(), ToolsMessages.INFO_BASE64_TOOL_DESCRIPTION.get(), false);
        argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_BASE64.get());
        argParser.setVersionHandler(ToolVersionHandler.newSdkVersionHandler());
        try {
            decodeSubCommand = new SubCommand(argParser, "decode", ToolsMessages.INFO_BASE64_DECODE_DESCRIPTION.get());
            encodeSubCommand = new SubCommand(argParser, "encode", ToolsMessages.INFO_BASE64_ENCODE_DESCRIPTION.get());
            encodedData = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"encodedData").shortIdentifier(Character.valueOf('d'))).description(ToolsMessages.INFO_BASE64_ENCODED_DATA_DESCRIPTION.get())).valuePlaceholder(ToolsMessages.INFO_DATA_PLACEHOLDER.get())).buildAndAddToSubCommand(decodeSubCommand);
            encodedFile = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"encodedDataFile").shortIdentifier(Character.valueOf('f'))).description(ToolsMessages.INFO_BASE64_ENCODED_FILE_DESCRIPTION.get())).valuePlaceholder(ToolsMessages.INFO_PATH_PLACEHOLDER.get())).buildAndAddToSubCommand(decodeSubCommand);
            toRawFile = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"toRawFile").shortIdentifier(Character.valueOf('o'))).description(ToolsMessages.INFO_BASE64_TO_RAW_FILE_DESCRIPTION.get())).valuePlaceholder(ToolsMessages.INFO_PATH_PLACEHOLDER.get())).buildAndAddToSubCommand(decodeSubCommand);
            rawData = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"rawData").shortIdentifier(Character.valueOf('d'))).description(ToolsMessages.INFO_BASE64_RAW_DATA_DESCRIPTION.get())).valuePlaceholder(ToolsMessages.INFO_DATA_PLACEHOLDER.get())).buildAndAddToSubCommand(encodeSubCommand);
            rawFile = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"rawDataFile").shortIdentifier(Character.valueOf('f'))).description(ToolsMessages.INFO_BASE64_RAW_FILE_DESCRIPTION.get())).valuePlaceholder(ToolsMessages.INFO_PATH_PLACEHOLDER.get())).buildAndAddToSubCommand(encodeSubCommand);
            toEncodedFile = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"toEncodedFile").shortIdentifier(Character.valueOf('o'))).description(ToolsMessages.INFO_BASE64_TO_ENCODED_FILE_DESCRIPTION.get())).valuePlaceholder(ToolsMessages.INFO_PATH_PLACEHOLDER.get())).buildAndAddToSubCommand(encodeSubCommand);
            ArrayList<SubCommand> subCommandList = new ArrayList<SubCommand>(2);
            subCommandList.add(decodeSubCommand);
            subCommandList.add(encodeSubCommand);
            BooleanArgument showUsage = CommonArguments.showUsageArgument();
            argParser.addGlobalArgument((Argument)showUsage);
            argParser.setUsageGroupArgument((Argument)showUsage, subCommandList);
            argParser.setUsageArgument((Argument)showUsage, (OutputStream)this.getOutputStream());
        }
        catch (ArgumentException ae) {
            throw LDAPToolException.newToolParamException((Exception)((Object)ae), ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage()));
        }
        Utils.parseArguments((ArgumentParser)argParser, this.getErrStream(), args);
        if (argParser.usageOrVersionDisplayed()) {
            return ResultCode.SUCCESS.intValue();
        }
        try {
            com.forgerock.opendj.cli.Utils.throwIfArgumentsConflict((Argument)encodedData, (Argument)encodedFile);
            com.forgerock.opendj.cli.Utils.throwIfArgumentsConflict((Argument)rawData, (Argument)rawFile);
        }
        catch (ArgumentException e) {
            argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)e.getMessage()));
            throw LDAPToolException.newToolParamException((Exception)((Object)e), e.getMessageObject());
        }
        SubCommand subCommand = argParser.getSubCommand();
        if (subCommand == null) {
            argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_BASE64_NO_SUBCOMMAND_SPECIFIED.get());
            throw LDAPToolException.newToolExceptionAlreadyPrinted(null, ResultCode.CLIENT_SIDE_PARAM_ERROR);
        }
        if (subCommand.getName().equals(encodeSubCommand.getName())) {
            return this.encode(rawData, rawFile, toEncodedFile);
        }
        if (subCommand.getName().equals(decodeSubCommand.getName())) {
            return this.decode(encodedData, encodedFile, toRawFile);
        }
        argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_BASE64_UNKNOWN_SUBCOMMAND.get((Object)subCommand.getName()));
        throw LDAPToolException.newToolExceptionAlreadyPrinted(null, ResultCode.CLIENT_SIDE_PARAM_ERROR);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int encode(StringArgument rawDataArg, StringArgument rawDataFilePathArg, StringArgument toEncodeFilePathArg) throws LDAPToolException {
        byte[] dataToEncode;
        block24: {
            if (rawDataArg.isPresent()) {
                try {
                    dataToEncode = rawDataArg.getValue().getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw LDAPToolException.newToolException(e, ResultCode.OPERATIONS_ERROR, ToolsMessages.ERR_BASE64_ERROR_DECODING_RAW_DATA.get((Object)e.getMessage()));
                }
            }
            boolean readFromFile = rawDataFilePathArg.isPresent();
            InputStream inputStream = null;
            String rawDataFilePath = rawDataFilePathArg.getValue();
            try {
                int bytesRead;
                inputStream = readFromFile ? new FileInputStream(rawDataFilePath) : this.getInputStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                while ((bytesRead = inputStream.read(buffer)) >= 0) {
                    baos.write(buffer, 0, bytesRead);
                }
                dataToEncode = baos.toByteArray();
                if (!readFromFile) break block24;
            }
            catch (FileNotFoundException e) {
                try {
                    throw LDAPToolException.newToolParamException(e, CliMessages.ERR_FILEARG_NO_SUCH_FILE.get((Object)rawDataFilePath, (Object)rawDataFilePathArg.getLongIdentifier()));
                    catch (Exception e2) {
                        throw LDAPToolException.newToolException(e2, ResultCode.OPERATIONS_ERROR, ToolsMessages.ERR_BASE64_CANNOT_READ_RAW_DATA.get((Object)StaticUtils.getExceptionMessage((Throwable)e2)));
                    }
                }
                catch (Throwable throwable) {
                    if (!readFromFile) throw throwable;
                    org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
            }
            org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{inputStream});
        }
        String base64Data = org.forgerock.util.encode.Base64.encode((byte[])dataToEncode);
        if (!toEncodeFilePathArg.isPresent()) {
            this.getOutputStream().println(base64Data);
            return ResultCode.SUCCESS.intValue();
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(toEncodeFilePathArg.getValue()));){
            writer.write(base64Data);
            writer.newLine();
            return ResultCode.SUCCESS.intValue();
        }
        catch (Exception e) {
            throw LDAPToolException.newToolException(e, ResultCode.OPERATIONS_ERROR, ToolsMessages.ERR_BASE64_CANNOT_WRITE_ENCODED_DATA.get((Object)StaticUtils.getExceptionMessage((Throwable)e)));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int decode(StringArgument encodedDataArg, StringArgument encodedDataFilePathArg, StringArgument toRawFilePathArg) throws LDAPToolException {
        String dataToDecode;
        block38: {
            dataToDecode = null;
            if (encodedDataArg.isPresent()) {
                dataToDecode = encodedDataArg.getValue();
            } else {
                boolean readFromFile = encodedDataFilePathArg.isPresent();
                BufferedReader reader = null;
                String encodedDataFilePath = encodedDataFilePathArg.getValue();
                try {
                    String line;
                    reader = new BufferedReader(readFromFile ? new FileReader(encodedDataFilePath) : new InputStreamReader(System.in));
                    StringBuilder buffer = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        StringTokenizer tokenizer = new StringTokenizer(line);
                        while (tokenizer.hasMoreTokens()) {
                            buffer.append(tokenizer.nextToken());
                        }
                    }
                    dataToDecode = buffer.toString();
                    if (!readFromFile) break block38;
                }
                catch (FileNotFoundException e) {
                    try {
                        throw LDAPToolException.newToolParamException(e, CliMessages.ERR_FILEARG_NO_SUCH_FILE.get((Object)encodedDataFilePath, (Object)encodedDataFilePathArg.getLongIdentifier()));
                        catch (Exception e2) {
                            throw LDAPToolException.newToolException(e2, ResultCode.OPERATIONS_ERROR, ToolsMessages.ERR_BASE64_CANNOT_READ_ENCODED_DATA.get((Object)StaticUtils.getExceptionMessage((Throwable)e2)));
                        }
                    }
                    catch (Throwable throwable) {
                        if (!readFromFile) throw throwable;
                        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{reader});
                        throw throwable;
                    }
                }
                org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{reader});
            }
        }
        if (dataToDecode.length() % 4 != 0) {
            throw LDAPToolException.newToolParamException(CoreMessages.ERR_BASE64_DECODE_INVALID_LENGTH.get((Object)dataToDecode));
        }
        byte[] decodedData = org.forgerock.util.encode.Base64.decode((String)dataToDecode);
        if (decodedData == null) {
            throw LDAPToolException.newToolParamException(ToolsMessages.ERR_BASE64_ERROR_DECODING_RAW_DATA.get((Object)dataToDecode));
        }
        try {
            Throwable throwable;
            if (toRawFilePathArg.isPresent()) {
                throwable = null;
                try (FileOutputStream outputStream = new FileOutputStream(toRawFilePathArg.getValue());){
                    outputStream.write(decodedData);
                    return ResultCode.SUCCESS.intValue();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            throwable = null;
            try (PrintStream outputPrintStream = this.getOutputStream();){
                outputPrintStream.write(decodedData);
                return ResultCode.SUCCESS.intValue();
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Exception e) {
            throw LDAPToolException.newToolException(e, ResultCode.OPERATIONS_ERROR, ToolsMessages.ERR_BASE64_CANNOT_WRITE_RAW_DATA.get((Object)StaticUtils.getExceptionMessage((Throwable)e)));
        }
    }
}

