/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.utils;

import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.forgerock.util.Reject;

public final class DerUtils {
    public static final byte INTEGER_TAG = 2;
    public static final byte SEQUENCE_TAG = 48;

    private DerUtils() {
    }

    public static void readUnsignedInteger(ByteBuffer input, byte[] output, int offset, int length) {
        Reject.ifFalse((input.get() == 2 ? 1 : 0) != 0, (String)"Not an integer");
        int len = DerUtils.readLength(input);
        if (len > length && (--len > length || input.get() != 0)) {
            throw new BufferOverflowException();
        }
        input.get(output, offset + (length - len), len);
    }

    public static void writeInteger(ByteBuffer buffer, byte[] data) {
        buffer.put((byte)2);
        DerUtils.writeLength(buffer, data.length);
        buffer.put(data);
    }

    public static int readLength(ByteBuffer buffer) {
        byte b = buffer.get();
        if ((b & 0x80) == 0) {
            return b & 0xFF;
        }
        int numBytes = b & 0x7F;
        Reject.ifFalse((numBytes > 0 && numBytes < 4 ? 1 : 0) != 0, (String)"Unsupported DER length field");
        int len = 0;
        for (int i = 0; i < numBytes; ++i) {
            len = (len << 8) + (buffer.get() & 0xFF);
        }
        return len;
    }

    public static void writeLength(ByteBuffer output, int length) {
        if (length < 128) {
            output.put((byte)(length & 0x7F));
        } else {
            byte[] bytes = BigInteger.valueOf(length).toByteArray();
            output.put((byte)(bytes.length | 0x80));
            output.put(bytes);
        }
    }
}

