/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwt;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum JwtHeaderKey {
    TYP,
    ALG,
    CUSTOM;

    private static final Map<String, JwtHeaderKey> NAME_MAP;
    private final String lowerCaseName = this.name().toLowerCase(Locale.ROOT);

    public String value() {
        return this.toString();
    }

    public static JwtHeaderKey getHeaderKey(String headerKey) {
        JwtHeaderKey value;
        if (headerKey != null && !headerKey.isEmpty() && (value = NAME_MAP.get(headerKey.toLowerCase(Locale.ROOT))) != null) {
            return value;
        }
        return CUSTOM;
    }

    public String toString() {
        return this.lowerCaseName;
    }

    static {
        HashMap<String, JwtHeaderKey> temp = new HashMap<String, JwtHeaderKey>();
        for (JwtHeaderKey key : JwtHeaderKey.values()) {
            temp.put(key.lowerCaseName, key);
        }
        NAME_MAP = Collections.unmodifiableMap(temp);
    }
}

