/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwt;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.forgerock.json.JsonValue;
import org.forgerock.json.jose.jwt.JWObject;
import org.forgerock.json.jose.jwt.JwtClaimsSetKey;
import org.forgerock.json.jose.jwt.Payload;
import org.forgerock.json.jose.utils.IntDate;
import org.forgerock.json.jose.utils.StringOrURI;

public class JwtClaimsSet
extends JWObject
implements Payload {
    public JwtClaimsSet() {
    }

    public JwtClaimsSet(Map<String, Object> claims) {
        this.setClaims(claims);
    }

    public void setType(String type) {
        this.put(JwtClaimsSetKey.TYP.value(), type);
    }

    public String getType() {
        return this.get(JwtClaimsSetKey.TYP.value()).asString();
    }

    public void setJwtId(String jwtId) {
        this.put(JwtClaimsSetKey.JTI.value(), jwtId);
    }

    public String getJwtId() {
        return this.get(JwtClaimsSetKey.JTI.value()).asString();
    }

    public void setIssuer(String issuer) {
        StringOrURI.validateStringOrURI(issuer);
        this.put(JwtClaimsSetKey.ISS.value(), issuer);
    }

    public void setIssuer(URI issuer) {
        this.put(JwtClaimsSetKey.ISS.value(), issuer.toString());
    }

    public String getIssuer() {
        return this.get(JwtClaimsSetKey.ISS.value()).asString();
    }

    public void setSubject(String subject) {
        StringOrURI.validateStringOrURI(subject);
        this.put(JwtClaimsSetKey.SUB.value(), subject);
    }

    public void setSubject(URI subject) {
        this.put(JwtClaimsSetKey.SUB.value(), subject.toString());
    }

    public String getSubject() {
        return this.get(JwtClaimsSetKey.SUB.value()).asString();
    }

    public void addAudience(String audience) {
        StringOrURI.validateStringOrURI(audience);
        this.addAudienceWithTypeCheck(audience);
    }

    public void addAudience(URI audience) {
        this.addAudienceWithTypeCheck(audience.toString());
    }

    private void addAudienceWithTypeCheck(String audience) {
        JsonValue audienceClaim = this.get(JwtClaimsSetKey.AUD.value());
        if (audienceClaim.isNull()) {
            this.put(JwtClaimsSetKey.AUD.value(), audience);
        } else if (audienceClaim.isList()) {
            audienceClaim.asList().add(audience);
        } else {
            ArrayList<String> audienceList = new ArrayList<String>();
            audienceList.add(audienceClaim.asString());
            audienceList.add(audience);
            this.put(JwtClaimsSetKey.AUD.value(), audienceList);
        }
    }

    public List<String> getAudience() {
        JsonValue audience = this.get(JwtClaimsSetKey.AUD.value());
        if (audience.isNull()) {
            return null;
        }
        if (audience.isList()) {
            return audience.asList(String.class);
        }
        return Collections.singletonList(audience.asString());
    }

    public void setIssuedAtTime(Date issuedAtTime) {
        this.put(JwtClaimsSetKey.IAT.value(), IntDate.toIntDate(issuedAtTime));
    }

    private void setIssuedAtTime(long issuedAtTime) {
        this.put(JwtClaimsSetKey.IAT.value(), issuedAtTime);
    }

    public Date getIssuedAtTime() {
        return this.getDate(JwtClaimsSetKey.IAT.value());
    }

    public void setNotBeforeTime(Date notBeforeTime) {
        this.put(JwtClaimsSetKey.NBF.value(), IntDate.toIntDate(notBeforeTime));
    }

    private void setNotBeforeTime(long notBeforeTime) {
        this.put(JwtClaimsSetKey.NBF.value(), notBeforeTime);
    }

    public Date getNotBeforeTime() {
        return this.getDate(JwtClaimsSetKey.NBF.value());
    }

    public void setExpirationTime(Date expirationTime) {
        this.put(JwtClaimsSetKey.EXP.value(), IntDate.toIntDate(expirationTime));
    }

    private void setExpirationTime(long expirationTime) {
        this.put(JwtClaimsSetKey.EXP.value(), expirationTime);
    }

    public Date getExpirationTime() {
        return this.getDate(JwtClaimsSetKey.EXP.value());
    }

    public void setClaim(String key, Object value) {
        JwtClaimsSetKey claimsSetKey = JwtClaimsSetKey.getClaimSetKey(key.toUpperCase());
        switch (claimsSetKey) {
            case TYP: {
                this.checkValueIsOfType(value, String.class);
                this.setType((String)value);
                break;
            }
            case JTI: {
                this.checkValueIsOfType(value, String.class);
                this.setJwtId((String)value);
                break;
            }
            case ISS: {
                if (this.isValueOfType(value, URI.class)) {
                    this.setIssuer((URI)value);
                    break;
                }
                this.checkValueIsOfType(value, String.class);
                this.setIssuer((String)value);
                break;
            }
            case SUB: {
                if (this.isValueOfType(value, URI.class)) {
                    this.setSubject((URI)value);
                    break;
                }
                this.checkValueIsOfType(value, String.class);
                this.setSubject((String)value);
                break;
            }
            case AUD: {
                if (this.isValueOfType(value, List.class)) {
                    List audienceList = (List)value;
                    for (Object audience : audienceList) {
                        if (this.isValueOfType(audience, URI.class)) {
                            this.addAudience((URI)audience);
                            continue;
                        }
                        this.checkValueIsOfType(audience, String.class);
                        this.addAudience((String)audience);
                    }
                    break;
                }
                if (this.isValueOfType(value, URI.class)) {
                    this.addAudience((URI)value);
                    break;
                }
                this.checkValueIsOfType(value, String.class);
                this.addAudience((String)value);
                break;
            }
            case IAT: {
                if (this.isValueOfType(value, Number.class)) {
                    this.setIssuedAtTime(((Number)value).longValue());
                    break;
                }
                this.checkValueIsOfType(value, Date.class);
                this.setIssuedAtTime((Date)value);
                break;
            }
            case NBF: {
                if (this.isValueOfType(value, Number.class)) {
                    this.setNotBeforeTime(((Number)value).longValue());
                    break;
                }
                this.checkValueIsOfType(value, Date.class);
                this.setNotBeforeTime((Date)value);
                break;
            }
            case EXP: {
                if (this.isValueOfType(value, Number.class)) {
                    this.setExpirationTime(((Number)value).longValue());
                    break;
                }
                this.checkValueIsOfType(value, Date.class);
                this.setExpirationTime((Date)value);
                break;
            }
            default: {
                this.put(key, value);
            }
        }
    }

    public void setClaims(Map<String, Object> claims) {
        for (String key : claims.keySet()) {
            this.setClaim(key, claims.get(key));
        }
    }

    public Object getClaim(String key) {
        Object value;
        JwtClaimsSetKey claimsSetKey = JwtClaimsSetKey.getClaimSetKey(key.toUpperCase());
        switch (claimsSetKey) {
            case TYP: {
                value = this.getType();
                break;
            }
            case JTI: {
                value = this.getJwtId();
                break;
            }
            case ISS: {
                value = this.getIssuer();
                break;
            }
            case SUB: {
                value = this.getSubject();
                break;
            }
            case AUD: {
                value = this.getAudience();
                break;
            }
            case IAT: {
                value = this.getIssuedAtTime();
                break;
            }
            case NBF: {
                value = this.getNotBeforeTime();
                break;
            }
            case EXP: {
                value = this.getExpirationTime();
                break;
            }
            default: {
                value = this.get(key).getObject();
            }
        }
        return value;
    }

    public <T> T getClaim(String key, Class<T> clazz) {
        return clazz.cast(this.getClaim(key));
    }

    @Override
    public String build() {
        return this.toString();
    }

    private Date getDate(String key) {
        JsonValue value = this.get(key);
        return value.isNull() ? null : IntDate.fromIntDate(value.asLong());
    }
}

