/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jws;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.forgerock.json.jose.exceptions.JwtRuntimeException;
import org.forgerock.json.jose.jwe.CompressionAlgorithm;
import org.forgerock.json.jose.jwk.JWK;
import org.forgerock.json.jose.jws.JwsHeaderKey;
import org.forgerock.json.jose.jwt.JwtHeader;
import org.forgerock.json.jose.utils.Utils;
import org.forgerock.util.encode.Base64;

public abstract class JwtSecureHeader
extends JwtHeader {
    private static final String COMPRESSION_ALGORITHM_HEADER_KEY = "zip";

    public JwtSecureHeader() {
    }

    public JwtSecureHeader(Map<String, Object> headers) {
        this.setParameters(headers);
    }

    public void setJwkSetUrl(URL jwkSetUrl) {
        this.put(JwsHeaderKey.JKU.value(), new String(jwkSetUrl.toString()));
    }

    public URL getJwkSetUrl() {
        try {
            String url = this.get(JwsHeaderKey.JKU.value()).asString();
            return url != null ? new URL(url) : null;
        }
        catch (MalformedURLException e) {
            throw new JwtRuntimeException(e);
        }
    }

    public void setJsonWebKey(JWK jsonWebKey) {
        this.put(JwsHeaderKey.JWK.value(), jsonWebKey);
    }

    public JWK getJsonWebKey() {
        return (JWK)this.get(JwsHeaderKey.JWK.value()).getObject();
    }

    public void setX509Url(URL x509Url) {
        this.put(JwsHeaderKey.X5U.value(), new String(x509Url.toString()));
    }

    public URL getX509Url() {
        try {
            String url = this.get(JwsHeaderKey.X5U.value()).asString();
            return url != null ? new URL(url) : null;
        }
        catch (MalformedURLException e) {
            throw new JwtRuntimeException(e);
        }
    }

    public void setX509CertificateThumbprint(String x509CertificateThumbprint) {
        this.put(JwsHeaderKey.X5T.value(), Utils.base64urlEncode(x509CertificateThumbprint));
    }

    public String getX509CertificateThumbprint() {
        return this.get(JwsHeaderKey.X5T.value()).asString();
    }

    public void setX509CertificateChain(List<String> x509CertificateChain) {
        ArrayList<String> encodedCertChain = new ArrayList<String>();
        for (String x509Cert : x509CertificateChain) {
            encodedCertChain.add(Base64.encode((byte[])x509Cert.getBytes(Utils.CHARSET)));
        }
        this.put(JwsHeaderKey.X5C.value(), encodedCertChain);
    }

    public List<String> getX509CertificateChain() {
        return this.get(JwsHeaderKey.X5C.value()).asList(String.class);
    }

    public void setKeyId(String keyId) {
        this.put(JwsHeaderKey.KID.value(), keyId);
    }

    public String getKeyId() {
        return this.get(JwsHeaderKey.KID.value()).asString();
    }

    public void setContentType(String contentType) {
        this.put(JwsHeaderKey.CTY.value(), contentType);
    }

    public String getContentType() {
        return this.get(JwsHeaderKey.CTY.value()).asString();
    }

    public void setCriticalHeaders(List<String> criticalHeaders) {
        if (criticalHeaders != null && criticalHeaders.isEmpty()) {
            throw new JwtRuntimeException("Critical Headers parameter cannot be an empty list");
        }
        this.put(JwsHeaderKey.CRIT.value(), criticalHeaders);
    }

    public List<String> getCriticalHeaders() {
        return this.get(JwsHeaderKey.CRIT.value()).asList(String.class);
    }

    @Override
    public void setParameter(String key, Object value) {
        JwsHeaderKey headerKey = JwsHeaderKey.getHeaderKey(key.toUpperCase());
        switch (headerKey) {
            case JKU: {
                this.checkValueIsOfType(value, URL.class);
                this.setJwkSetUrl((URL)value);
                break;
            }
            case JWK: {
                this.checkValueIsOfType(value, JWK.class);
                this.setJsonWebKey((JWK)value);
                break;
            }
            case X5U: {
                this.checkValueIsOfType(value, URL.class);
                this.setX509Url((URL)value);
                break;
            }
            case X5T: {
                this.checkValueIsOfType(value, String.class);
                this.setX509CertificateThumbprint((String)value);
                break;
            }
            case X5C: {
                this.checkValueIsOfType(value, List.class);
                this.checkListValuesAreOfType((List)value, String.class);
                this.setX509CertificateChain((List)value);
                break;
            }
            case KID: {
                this.checkValueIsOfType(value, String.class);
                this.setKeyId((String)value);
                break;
            }
            case CTY: {
                this.checkValueIsOfType(value, String.class);
                this.setContentType((String)value);
                break;
            }
            case CRIT: {
                this.checkValueIsOfType(value, List.class);
                this.checkListValuesAreOfType((List)value, String.class);
                this.setCriticalHeaders((List)value);
                break;
            }
            default: {
                super.setParameter(key, value);
            }
        }
    }

    @Override
    public Object getParameter(String key) {
        Object value;
        JwsHeaderKey headerKey = JwsHeaderKey.getHeaderKey(key.toUpperCase());
        switch (headerKey) {
            case JKU: {
                value = this.getJwkSetUrl();
                break;
            }
            case JWK: {
                value = this.getJsonWebKey();
                break;
            }
            case X5U: {
                value = this.getX509Url();
                break;
            }
            case X5T: {
                value = this.getX509CertificateThumbprint();
                break;
            }
            case X5C: {
                value = this.getX509CertificateChain();
                break;
            }
            case KID: {
                value = this.getKeyId();
                break;
            }
            case CTY: {
                value = this.getContentType();
                break;
            }
            case CRIT: {
                value = this.getCriticalHeaders();
                break;
            }
            default: {
                value = super.getParameter(key);
            }
        }
        return value;
    }

    public void setCompressionAlgorithm(CompressionAlgorithm compressionAlgorithm) {
        this.put(COMPRESSION_ALGORITHM_HEADER_KEY, compressionAlgorithm.toString());
    }

    public CompressionAlgorithm getCompressionAlgorithm() {
        String compressionAlgorithm = this.get(COMPRESSION_ALGORITHM_HEADER_KEY).asString();
        if (compressionAlgorithm == null) {
            return CompressionAlgorithm.NONE;
        }
        return CompressionAlgorithm.valueOf(compressionAlgorithm);
    }
}

