/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe;

import java.security.Key;
import org.forgerock.json.jose.common.JwtReconstruction;
import org.forgerock.json.jose.exceptions.JwsVerifyingException;
import org.forgerock.json.jose.jwe.EncryptedJwt;
import org.forgerock.json.jose.jwe.JweHeader;
import org.forgerock.json.jose.jws.SignedJwt;
import org.forgerock.json.jose.jws.handlers.SigningHandler;
import org.forgerock.json.jose.jwt.JwtClaimsSet;
import org.forgerock.json.jose.jwt.Payload;

public class SignedThenEncryptedJwt
extends EncryptedJwt {
    private static final JwtReconstruction JWT_RECONSTRUCTION = new JwtReconstruction();

    public SignedThenEncryptedJwt(JweHeader header, SignedJwt payload, Key publicKey) {
        super(header, payload, publicKey);
    }

    public SignedThenEncryptedJwt(JweHeader header, String encodedHeader, byte[] encryptedContentEncryptionKey, byte[] initialisationVector, byte[] ciphertext, byte[] authenticationTag) {
        super(header, encodedHeader, encryptedContentEncryptionKey, initialisationVector, ciphertext, authenticationTag);
    }

    public boolean verify(SigningHandler signingHandler) {
        if (this.getPayload() == null) {
            throw new JwsVerifyingException("JWT must be decrypted before the nested signature can be verified");
        }
        return ((SignedJwt)this.getPayload()).verify(signingHandler);
    }

    public boolean decryptAndVerify(Key decryptionKey, SigningHandler signingHandler) {
        this.decrypt(decryptionKey);
        return this.verify(signingHandler);
    }

    @Override
    public JwtClaimsSet getClaimsSet() {
        return ((SignedJwt)this.getPayload()).getClaimsSet();
    }

    @Override
    Payload decodePayload(String decryptedPayload) {
        return JWT_RECONSTRUCTION.reconstructJwt(decryptedPayload, SignedJwt.class);
    }
}

