/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe;

import org.forgerock.json.jose.exceptions.JweException;
import org.forgerock.json.jose.jwe.JweAlgorithmType;
import org.forgerock.json.jose.jwt.Algorithm;

public enum JweAlgorithm implements Algorithm
{
    RSAES_PKCS1_V1_5("RSA1_5", "RSA/ECB/PKCS1Padding", JweAlgorithmType.RSA),
    RSA_OAEP("RSA-OAEP", "RSA/ECB/OAEPWithSHA-1AndMGF1Padding", JweAlgorithmType.RSA),
    RSA_OAEP_256("RSA-OAEP-256", "RSA/ECB/OAEPWithSHA-256AndMGF1Padding", JweAlgorithmType.RSA),
    DIRECT("dir", null, JweAlgorithmType.DIRECT),
    A128KW("A128KW", "AESWrap", JweAlgorithmType.AES_KEYWRAP),
    A192KW("A192KW", "AESWrap", JweAlgorithmType.AES_KEYWRAP),
    A256KW("A256KW", "AESWrap", JweAlgorithmType.AES_KEYWRAP);

    private final String name;
    private final String transformation;
    private final JweAlgorithmType algorithmType;

    private JweAlgorithm(String name, String transformation, JweAlgorithmType algorithmType) {
        this.name = name;
        this.transformation = transformation;
        this.algorithmType = algorithmType;
    }

    @Override
    public String getAlgorithm() {
        return this.transformation;
    }

    public JweAlgorithmType getAlgorithmType() {
        return this.algorithmType;
    }

    public static JweAlgorithm parseAlgorithm(String algorithm) {
        for (JweAlgorithm alg : JweAlgorithm.values()) {
            if (!alg.name.equals(algorithm)) continue;
            return alg;
        }
        if (RSAES_PKCS1_V1_5.name().equals(algorithm)) {
            return RSAES_PKCS1_V1_5;
        }
        throw new JweException("Unknown Encryption Algorithm, " + algorithm);
    }

    public String toString() {
        return this.name;
    }
}

