/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.builders;

import java.security.Key;
import org.forgerock.json.jose.builders.EncryptedJwtBuilder;
import org.forgerock.json.jose.builders.JwtClaimsSetBuilder;
import org.forgerock.json.jose.builders.SignedJwtBuilderImpl;
import org.forgerock.json.jose.common.JwtReconstruction;
import org.forgerock.json.jose.jws.handlers.NOPSigningHandler;
import org.forgerock.json.jose.jws.handlers.SigningHandler;
import org.forgerock.json.jose.jwt.Jwt;

public class JwtBuilderFactory {
    public SignedJwtBuilderImpl jwt() {
        return new SignedJwtBuilderImpl(new NOPSigningHandler());
    }

    public SignedJwtBuilderImpl jws(SigningHandler signingHandler) {
        return new SignedJwtBuilderImpl(signingHandler);
    }

    public EncryptedJwtBuilder jwe(Key publicKey) {
        return new EncryptedJwtBuilder(publicKey);
    }

    public JwtClaimsSetBuilder claims() {
        return new JwtClaimsSetBuilder();
    }

    public <T extends Jwt> T reconstruct(String jwtString, Class<T> jwtClass) {
        return new JwtReconstruction().reconstructJwt(jwtString, jwtClass);
    }
}

