/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.forgerock.http.Handler;
import org.forgerock.http.oauth2.AccessTokenException;
import org.forgerock.http.oauth2.AccessTokenInfo;
import org.forgerock.http.oauth2.AccessTokenResolver;
import org.forgerock.http.protocol.Entity;
import org.forgerock.http.protocol.Form;
import org.forgerock.http.protocol.Headers;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Responses;
import org.forgerock.http.protocol.Status;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.authz.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.encode.Base64;
import org.forgerock.util.promise.Promise;

final class Rfc7662AccessTokenResolver
implements AccessTokenResolver {
    private static final String RFC_7662_FORM_TOKEN_FIELD = "token";
    private static final String RFC_7662_FORM_TOKEN_TYPE_HINT_FIELD = "token_type_hint";
    private static final String RFC_7662_FORM_TOKEN_TYPE_HINT_ACCESS_TOKEN = "access_token";
    private static final String RFC_7662_RESPONSE_SCOPE_FIELD = "scope";
    private static final String RFC_7662_RESPONSE_EXPIRE_TIME_FIELD = "exp";
    private static final String RFC_7662_RESPONSE_ACTIVE_FIELD = "active";
    private final Handler httpClient;
    private final URI introspectionEndPointURI;
    private final String clientAppId;
    private final String clientAppSecret;

    Rfc7662AccessTokenResolver(Handler httpClient, URI introspectionEndPointURI, String clientAppId, String clientAppSecret) {
        this.httpClient = (Handler)Reject.checkNotNull((Object)httpClient);
        this.introspectionEndPointURI = (URI)Reject.checkNotNull((Object)introspectionEndPointURI);
        this.clientAppId = (String)Reject.checkNotNull((Object)clientAppId);
        this.clientAppSecret = (String)Reject.checkNotNull((Object)clientAppSecret);
    }

    public Promise<AccessTokenInfo, AccessTokenException> resolve(Context context, String token) {
        Request request = new Request().setUri(this.introspectionEndPointURI);
        Headers headers = request.getHeaders();
        headers.put("Accept", (Object)"application/json");
        headers.put("Authorization", (Object)("Basic " + Base64.encode((byte[])(this.clientAppId + ":" + this.clientAppSecret).getBytes())));
        Form form = new Form();
        form.add((Object)RFC_7662_FORM_TOKEN_FIELD, (Object)token);
        form.add((Object)RFC_7662_FORM_TOKEN_TYPE_HINT_FIELD, (Object)RFC_7662_FORM_TOKEN_TYPE_HINT_ACCESS_TOKEN);
        form.toRequestEntity(request);
        return this.httpClient.handle(context, request).then(this.buildAccessToken(token), Responses.noopExceptionFunction());
    }

    private Function<Response, AccessTokenInfo, AccessTokenException> buildAccessToken(final String tokenSent) {
        return new Function<Response, AccessTokenInfo, AccessTokenException>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public AccessTokenInfo apply(Response response) throws AccessTokenException {
                Status status = response.getStatus();
                if (!Status.OK.equals(status)) {
                    throw Utils.newAccessTokenException(Rest2ldapMessages.ERR_OAUTH2_RFC7662_RETURNED_ERROR.get((Object)status), response.getCause());
                }
                try (Entity entity = response.getEntity();){
                    JsonValue jsonResponse = Rfc7662AccessTokenResolver.this.asJson(entity);
                    if (!jsonResponse.get(Rfc7662AccessTokenResolver.RFC_7662_RESPONSE_ACTIVE_FIELD).defaultTo((Object)Boolean.FALSE).asBoolean().booleanValue()) {
                        throw Utils.newAccessTokenException(Rest2ldapMessages.ERR_OAUTH2_RFC7662_TOKEN_NOT_ACTIVE.get());
                    }
                    AccessTokenInfo accessTokenInfo = Rfc7662AccessTokenResolver.this.buildAccessTokenFromJson(jsonResponse, tokenSent);
                    return accessTokenInfo;
                }
                catch (JsonValueException e) {
                    throw Utils.newAccessTokenException(Rest2ldapMessages.ERR_OAUTH2_RFC7662_INVALID_JSON_TOKEN.get((Object)e.getMessage()), (Exception)((Object)e));
                }
            }
        };
    }

    private AccessTokenInfo buildAccessTokenFromJson(JsonValue jsonToken, String token) {
        HashSet<String> tokenScopes = new HashSet<String>(Arrays.asList(jsonToken.get(RFC_7662_RESPONSE_SCOPE_FIELD).required().asString().trim().split(" +")));
        Long expiresAt = jsonToken.get(RFC_7662_RESPONSE_EXPIRE_TIME_FIELD).required().asLong();
        return new AccessTokenInfo(jsonToken, token, tokenScopes, TimeUnit.SECONDS.toMillis(expiresAt));
    }

    private JsonValue asJson(Entity entity) throws AccessTokenException {
        try {
            return new JsonValue(entity.getJson());
        }
        catch (IOException e) {
            throw Utils.newAccessTokenException(Rest2ldapMessages.ERR_OAUTH2_RFC7662_CANNOT_READ_RESPONSE.get(), e);
        }
    }
}

