/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.protocol.Headers;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.rest2ldap.authz.AuthenticationStrategy;
import org.forgerock.opendj.rest2ldap.authz.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.SecurityContext;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Pair;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;

final class HttpBasicAuthenticationFilter
implements Filter {
    private final AuthenticationStrategy authenticationStrategy;
    private final Function<Headers, Pair<String, String>, NeverThrowsException> credentialsExtractor;

    public HttpBasicAuthenticationFilter(AuthenticationStrategy authenticationStrategy, Function<Headers, Pair<String, String>, NeverThrowsException> credentialsExtractor) {
        this.authenticationStrategy = (AuthenticationStrategy)Reject.checkNotNull((Object)authenticationStrategy, (String)"authenticationStrategy cannot be null");
        this.credentialsExtractor = (Function)Reject.checkNotNull(credentialsExtractor, (String)"credentialsExtractor cannot be null");
    }

    public Promise<Response, NeverThrowsException> filter(Context context, final Request request, final Handler next) {
        Pair credentials = (Pair)this.credentialsExtractor.apply((Object)request.getHeaders());
        if (credentials == null) {
            return Utils.asErrorResponse(LdapException.newLdapException((ResultCode)ResultCode.INVALID_CREDENTIALS));
        }
        return this.authenticationStrategy.authenticate((String)credentials.getFirst(), (String)credentials.getSecond(), context).thenAsync((AsyncFunction)new AsyncFunction<SecurityContext, Response, NeverThrowsException>(){

            public Promise<Response, NeverThrowsException> apply(SecurityContext securityContext) {
                return next.handle((Context)securityContext, request);
            }
        }, (AsyncFunction)new AsyncFunction<LdapException, Response, NeverThrowsException>(){

            public Promise<? extends Response, ? extends NeverThrowsException> apply(LdapException exception) {
                return Utils.asErrorResponse(exception instanceof EntryNotFoundException ? LdapException.newLdapException((ResultCode)ResultCode.INVALID_CREDENTIALS) : exception);
            }
        });
    }
}

