/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.forgerock.http.oauth2.AccessTokenException;
import org.forgerock.http.oauth2.AccessTokenInfo;
import org.forgerock.http.oauth2.AccessTokenResolver;
import org.forgerock.http.util.Json;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.json.JsonValueFunctions;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.authz.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

final class FileAccessTokenResolver
implements AccessTokenResolver {
    private final String folderPath;

    FileAccessTokenResolver(String folderPath) {
        this.folderPath = (String)Reject.checkNotNull((Object)folderPath);
    }

    public Promise<AccessTokenInfo, AccessTokenException> resolve(Context context, String token) {
        JsonValue accessToken;
        try (FileInputStream stream = new FileInputStream(new File(this.folderPath, token));){
            accessToken = new JsonValue(Json.readJsonLenient((InputStream)stream));
        }
        catch (IOException e) {
            return Promises.newExceptionPromise((Exception)Utils.newAccessTokenException(Rest2ldapMessages.ERR_OAUTH2_FILE_NO_TOKEN.get((Object)token), e));
        }
        try {
            AccessTokenInfo result = new AccessTokenInfo(accessToken, token, (Set)accessToken.get("scope").required().as(JsonValueFunctions.setOf(String.class)), accessToken.get("expireTime").required().asLong().longValue());
            return Promises.newResultPromise((Object)result);
        }
        catch (JsonValueException e) {
            return Promises.newExceptionPromise((Exception)Utils.newAccessTokenException(Rest2ldapMessages.ERR_OAUTH2_FILE_INVALID_JSON_TOKEN.get((Object)token, (Object)e.getMessage()), (Exception)((Object)e)));
        }
    }
}

