/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.rest2ldap.AbstractLdapPropertyMapper;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.Resource;
import org.forgerock.opendj.rest2ldap.Rest2Ldap;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.opendj.rest2ldap.schema.JsonSchema;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.query.QueryFilter;

public final class JsonPropertyMapper
extends AbstractLdapPropertyMapper<JsonPropertyMapper> {
    private static final JsonValue ANY_SCHEMA = new JsonValue((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"type", (Object)"object")}));
    private JsonValue jsonSchema = ANY_SCHEMA;

    JsonPropertyMapper(AttributeDescription ldapAttributeName) {
        super(ldapAttributeName);
    }

    public JsonPropertyMapper defaultJsonValue(Object defaultValue) {
        this.defaultJsonValues = defaultValue != null ? Collections.singletonList(defaultValue) : Collections.emptyList();
        return this;
    }

    public JsonPropertyMapper defaultJsonValues(Collection<?> defaultValues) {
        this.defaultJsonValues = defaultValues != null ? new ArrayList(defaultValues) : Collections.emptyList();
        return this;
    }

    public JsonPropertyMapper jsonSchema(JsonValue jsonSchema) {
        this.jsonSchema = jsonSchema != null ? jsonSchema : ANY_SCHEMA;
        return this;
    }

    public String toString() {
        return "json(" + this.ldapAttributeName + ")";
    }

    @Override
    Promise<Filter, ResourceException> getLdapFilter(Context context, Resource resource, JsonPointer path, JsonPointer subPath, FilterType type, String operator, Object valueAssertion) {
        QueryFilter<JsonPointer> queryFilter = this.toQueryFilter(type, subPath, operator, valueAssertion);
        return Promises.newResultPromise((Object)Filter.equality((String)this.ldapAttributeName.toString(), queryFilter));
    }

    private QueryFilter<JsonPointer> toQueryFilter(FilterType type, JsonPointer subPath, String operator, Object valueAssertion) {
        switch (type) {
            case CONTAINS: {
                return QueryFilter.contains((Object)subPath, (Object)valueAssertion);
            }
            case STARTS_WITH: {
                return QueryFilter.startsWith((Object)subPath, (Object)valueAssertion);
            }
            case EQUAL_TO: {
                return QueryFilter.equalTo((Object)subPath, (Object)valueAssertion);
            }
            case GREATER_THAN: {
                return QueryFilter.greaterThan((Object)subPath, (Object)valueAssertion);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return QueryFilter.greaterThanOrEqualTo((Object)subPath, (Object)valueAssertion);
            }
            case LESS_THAN: {
                return QueryFilter.lessThan((Object)subPath, (Object)valueAssertion);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return QueryFilter.lessThanOrEqualTo((Object)subPath, (Object)valueAssertion);
            }
            case PRESENT: {
                return QueryFilter.present((Object)subPath);
            }
            case EXTENDED: {
                return QueryFilter.extendedMatch((Object)subPath, (String)operator, (Object)valueAssertion);
            }
        }
        return QueryFilter.alwaysFalse();
    }

    @Override
    Promise<Attribute, ResourceException> getNewLdapAttributes(Context context, Resource resource, JsonPointer path, List<Object> newValues) {
        try {
            return Promises.newResultPromise((Object)Utils.jsonToAttribute(newValues, this.ldapAttributeName, JsonSchema.jsonToByteString()));
        }
        catch (Exception e) {
            return Utils.newBadRequestException(Rest2ldapMessages.ERR_ENCODING_VALUES_FOR_FIELD.get((Object)path, (Object)e.getMessage())).asPromise();
        }
    }

    @Override
    JsonPropertyMapper getThis() {
        return this;
    }

    @Override
    Promise<List<Modification>, ResourceException> patch(Context context, Resource resource, JsonPointer path, PatchOperation operation) {
        JsonPointer field = operation.getField();
        if (field.isEmpty() || field.size() == 1 && field.get(0).equals("-")) {
            return super.patch(context, resource, path, operation);
        }
        return Utils.newNotSupportedException(Rest2ldapMessages.ERR_PATCH_JSON_INTERNAL_PROPERTY.get((Object)field, (Object)path, (Object)path)).asPromise();
    }

    @Override
    Promise<JsonValue, ResourceException> read(Context context, Resource resource, JsonPointer path, Entry e) {
        try {
            Set s = e.parseAttribute(this.ldapAttributeName).asSetOf(JsonSchema.byteStringToJson(), (Collection)this.defaultJsonValues);
            switch (s.size()) {
                case 0: {
                    return Promises.newResultPromise(null);
                }
                case 1: {
                    if (!this.attributeIsSingleValued()) break;
                    return Promises.newResultPromise((Object)new JsonValue(s.iterator().next()));
                }
            }
            return Promises.newResultPromise((Object)new JsonValue(new ArrayList(s)));
        }
        catch (Exception ex) {
            return Rest2Ldap.asResourceException(ex).asPromise();
        }
    }

    @Override
    JsonValue toJsonSchema() {
        return this.jsonSchema;
    }
}

