/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.CleanerLogSummary;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.FilesToMigrate;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilizationCalculator {
    private static final boolean DEBUG = false;
    private final int configRecentLNSizes;
    private final int configMinUncountedLNs;
    private final int configInitialAdjustments;
    private final int configMinProbeSkipFiles;
    private final int configMaxProbeSkipFiles;
    private final boolean configAdjustUtilization;
    private static final float MIN_CORRECTION_FACTOR = 0.01f;
    private static final float MAX_CORRECTION_FACTOR = 100.0f;
    private final EnvironmentImpl env;
    private final Cleaner cleaner;
    private final Logger logger;
    private final FilesToMigrate filesToMigrate;
    private float lnSizeCorrectionFactor;
    private final LinkedList<AverageSize> recentAvgLNSizes;
    private long endFileNumAtLastAdjustment;
    private int initialAdjustments;
    private TestHook<TestAdjustment> adjustmentHook;
    private volatile int lastKnownUtilization = -1;

    UtilizationCalculator(EnvironmentImpl env, Cleaner cleaner) {
        this.env = env;
        this.cleaner = cleaner;
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.lnSizeCorrectionFactor = Float.NaN;
        this.recentAvgLNSizes = new LinkedList();
        this.endFileNumAtLastAdjustment = -1L;
        this.filesToMigrate = new FilesToMigrate(env);
        DbConfigManager configManager = env.getConfigManager();
        this.configAdjustUtilization = configManager.getBoolean(EnvironmentParams.CLEANER_ADJUST_UTILIZATION);
        this.configRecentLNSizes = configManager.getInt(EnvironmentParams.CLEANER_CALC_RECENT_LN_SIZES);
        this.configMinUncountedLNs = configManager.getInt(EnvironmentParams.CLEANER_CALC_MIN_UNCOUNTED_LNS);
        this.configInitialAdjustments = configManager.getInt(EnvironmentParams.CLEANER_CALC_INITIAL_ADJUSTMENTS);
        this.configMinProbeSkipFiles = configManager.getInt(EnvironmentParams.CLEANER_CALC_MIN_PROBE_SKIP_FILES);
        this.configMaxProbeSkipFiles = configManager.getInt(EnvironmentParams.CLEANER_CALC_MAX_PROBE_SKIP_FILES);
    }

    public synchronized CleanerLogSummary getLogSummary() {
        return new CleanerLogSummary(new ArrayList<AverageSize>(this.recentAvgLNSizes), this.endFileNumAtLastAdjustment, this.initialAdjustments);
    }

    public synchronized void setLogSummary(CleanerLogSummary logSummary) {
        this.endFileNumAtLastAdjustment = logSummary.getEndFileNumAtLastAdjustment();
        this.initialAdjustments = logSummary.getInitialAdjustments();
        this.recentAvgLNSizes.clear();
        this.recentAvgLNSizes.addAll(logSummary.getRecentAvgLNSizes());
        this.updateObsoleteLNSizeCorrectionFactor();
    }

    synchronized void setAdjustmentHook(TestHook<TestAdjustment> hook) {
        this.adjustmentHook = hook;
    }

    public float getLNSizeCorrectionFactor() {
        return this.lnSizeCorrectionFactor;
    }

    int getLastKnownUtilization() {
        return this.lastKnownUtilization;
    }

    public boolean isAdjustUtilizationEnabled() {
        return this.configAdjustUtilization;
    }

    public int getObsoleteSize(FileSummary summary) {
        if (this.configAdjustUtilization) {
            return summary.getObsoleteSize(this.lnSizeCorrectionFactor);
        }
        return summary.getObsoleteSize();
    }

    synchronized Long getBestFile(SortedMap<Long, FileSummary> fileSummaryMap, boolean forceCleaning, Set<Long> lowUtilizationFiles, boolean isBacklog, boolean isProbe, Set<Long> excludeFiles) {
        Level logLevel;
        String loggingMsg;
        Long fileChosen;
        long firstActiveTxnFile;
        if (lowUtilizationFiles != null) {
            lowUtilizationFiles.clear();
        }
        if (fileSummaryMap.size() == 0) {
            LoggerUtils.logMsg(this.logger, this.env, Level.SEVERE, "Can't clean, map is empty.");
            return null;
        }
        boolean isLoggingLevelFine = this.logger.isLoggable(Level.FINE);
        int useMinUtilization = this.cleaner.minUtilization;
        int useMinFileUtilization = this.cleaner.minFileUtilization;
        int useMinAge = this.cleaner.minAge;
        long firstActiveFile = fileSummaryMap.lastKey();
        long firstActiveTxnLsn = this.env.getTxnManager().getFirstActiveLsn();
        if (firstActiveTxnLsn != -1L && firstActiveFile > (firstActiveTxnFile = DbLsn.getFileNumber(firstActiveTxnLsn))) {
            firstActiveFile = firstActiveTxnFile;
        }
        long lastFileToClean = firstActiveFile - (long)useMinAge;
        Long bestFile = null;
        int bestUtilization = 101;
        long totalSize = 0L;
        long totalObsoleteSize = 0L;
        long lastKnownSize = 0L;
        long lastKnownObsoleteSize = 0L;
        for (Map.Entry<Long, FileSummary> entry : fileSummaryMap.entrySet()) {
            Long file = entry.getKey();
            long fileNum = file;
            FileSummary summary = entry.getValue();
            int obsoleteSize = isProbe ? summary.getMaxObsoleteSize() : this.getObsoleteSize(summary);
            lastKnownSize += (long)summary.totalSize;
            lastKnownObsoleteSize += (long)obsoleteSize;
            if (this.cleaner.getFileSelector().isFileCleaningInProgress(file)) {
                int utilizedSize = summary.totalSize - obsoleteSize;
                totalSize += (long)utilizedSize;
                if (!isLoggingLevelFine) continue;
                LoggerUtils.logMsg(this.logger, this.env, Level.FINE, "Skip file previously selected for cleaning: 0x" + Long.toHexString(fileNum) + " utilizedSize: " + utilizedSize + " " + summary);
                continue;
            }
            totalSize += (long)summary.totalSize;
            totalObsoleteSize += (long)obsoleteSize;
            if (excludeFiles.contains(file) || fileNum > lastFileToClean) continue;
            int thisUtilization = FileSummary.utilization(obsoleteSize, summary.totalSize);
            if (bestFile == null || thisUtilization < bestUtilization) {
                bestFile = file;
                bestUtilization = thisUtilization;
            }
            if (lowUtilizationFiles == null || thisUtilization >= useMinUtilization) continue;
            lowUtilizationFiles.add(file);
        }
        int totalUtilization = FileSummary.utilization(totalObsoleteSize, totalSize);
        this.lastKnownUtilization = FileSummary.utilization(lastKnownObsoleteSize, lastKnownSize);
        if (totalUtilization < useMinUtilization || bestUtilization < useMinFileUtilization) {
            fileChosen = bestFile;
            loggingMsg = "Chose lowest utilized file for cleaning.";
        } else if (!isBacklog && this.filesToMigrate.hasNext(fileSummaryMap)) {
            fileChosen = this.filesToMigrate.next(fileSummaryMap);
            loggingMsg = "Chose file from files-to-migrate for cleaning.";
        } else if (forceCleaning) {
            fileChosen = bestFile;
            loggingMsg = "Chose file for forced cleaning (during testing).";
        } else {
            fileChosen = null;
            loggingMsg = "No file selected for cleaning.";
        }
        Level level = logLevel = fileChosen != null ? Level.INFO : Level.FINE;
        if (this.logger.isLoggable(logLevel)) {
            String fileChosenString = fileChosen != null ? " fileChosen: 0x" + Long.toHexString(fileChosen) : "";
            String correctionString = this.configAdjustUtilization ? " lnSizeCorrectionFactor: " + this.lnSizeCorrectionFactor : " (adjustment disabled)";
            LoggerUtils.logMsg(this.logger, this.env, logLevel, loggingMsg + fileChosenString + correctionString + " totalUtilization: " + totalUtilization + " bestFileUtilization: " + bestUtilization + " isProbe: " + isProbe);
        }
        return fileChosen;
    }

    synchronized Long getCheapestFileToClean(SortedMap<Long, FileSummary> fileSummaryMap, SortedSet<Long> candidateFiles) {
        if (candidateFiles.size() == 0) {
            return null;
        }
        if (candidateFiles.size() == 1) {
            return candidateFiles.first();
        }
        Long bestFile = null;
        int bestCost = Integer.MAX_VALUE;
        for (Long file : candidateFiles) {
            FileSummary summary = (FileSummary)fileSummaryMap.get(file);
            if (summary == null) {
                return file;
            }
            int thisCost = summary.getNonObsoleteCount();
            if (bestFile != null && thisCost >= bestCost) continue;
            bestFile = file;
            bestCost = thisCost;
        }
        return bestFile;
    }

    synchronized boolean adjustUtilization(long fileNum, long endFileNum, FileSummary estimatedFileSummary, FileSummary trueFileSummary) {
        float correctionFactor;
        float trueAvgSize;
        this.endFileNumAtLastAdjustment = endFileNum;
        if (estimatedFileSummary.obsoleteLNCount != trueFileSummary.obsoleteLNCount) {
            return false;
        }
        if (this.initialAdjustments < this.configInitialAdjustments) {
            ++this.initialAdjustments;
        }
        int estObsLNCount = Math.min(estimatedFileSummary.obsoleteLNCount, estimatedFileSummary.totalLNCount);
        int estObsLNSize = Math.min(estimatedFileSummary.obsoleteLNSize, estimatedFileSummary.totalLNSize);
        int estObsLNSizeCounted = Math.min(estimatedFileSummary.obsoleteLNSizeCounted, estObsLNCount);
        int trueObsLNSize = Math.min(trueFileSummary.obsoleteLNSize, trueFileSummary.totalLNSize);
        float estimatedAvgSize = estimatedFileSummary.getAvgObsoleteLNSizeNotCounted();
        int uncountedSize = trueObsLNSize - estObsLNSize;
        int uncountedCount = estObsLNCount - estObsLNSizeCounted;
        if (uncountedSize > 0 && uncountedCount > 0) {
            int estUncountedSize = estimatedFileSummary.totalLNSize - estObsLNSize;
            int estUncountedCount = estimatedFileSummary.totalLNCount - estObsLNSizeCounted;
            assert (estimatedAvgSize == (float)estUncountedSize / (float)estUncountedCount) : "expected=" + estimatedAvgSize + "got=" + (float)estUncountedSize / (float)estUncountedCount;
            trueAvgSize = (float)uncountedSize / (float)uncountedCount;
            correctionFactor = trueAvgSize / estimatedAvgSize;
            if (correctionFactor < 0.01f || correctionFactor > 100.0f) {
                return false;
            }
            this.recentAvgLNSizes.addLast(new AverageSize(uncountedSize, uncountedCount, estUncountedSize, estUncountedCount));
            while (this.recentAvgLNSizes.size() > this.configRecentLNSizes) {
                this.recentAvgLNSizes.removeFirst();
            }
            this.updateObsoleteLNSizeCorrectionFactor();
        } else {
            trueAvgSize = Float.NaN;
            correctionFactor = Float.NaN;
        }
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertionsEnabled && this.adjustmentHook != null) {
            TestAdjustment testAdjustment = new TestAdjustment(fileNum, endFileNum, estimatedFileSummary, trueFileSummary, estimatedAvgSize, trueAvgSize, correctionFactor);
            TestHookExecute.doHookIfSet(this.adjustmentHook, testAdjustment);
        }
        return true;
    }

    private void updateObsoleteLNSizeCorrectionFactor() {
        long totalSize = 0L;
        long totalCount = 0L;
        long estTotalSize = 0L;
        long estTotalCount = 0L;
        for (AverageSize avg : this.recentAvgLNSizes) {
            totalSize += (long)avg.size;
            totalCount += (long)avg.count;
            estTotalSize += (long)avg.estSize;
            estTotalCount += (long)avg.estCount;
        }
        if (totalCount < (long)this.configMinUncountedLNs) {
            return;
        }
        float correctedAvgLNSize = (float)((double)totalSize / (double)totalCount);
        float estimatedAvgLNSize = (float)((double)estTotalSize / (double)estTotalCount);
        this.lnSizeCorrectionFactor = correctedAvgLNSize / estimatedAvgLNSize;
    }

    synchronized boolean isCorrectionEstablished() {
        if (!this.configAdjustUtilization) {
            return true;
        }
        return this.initialAdjustments >= this.configInitialAdjustments;
    }

    synchronized boolean shouldPerformProbe(long endFileNum) {
        int filesBeforeProbe;
        if (!this.configAdjustUtilization) {
            return false;
        }
        int n = filesBeforeProbe = this.isCorrectionEstablished() ? this.configMaxProbeSkipFiles : this.configMinProbeSkipFiles;
        if (endFileNum - this.endFileNumAtLastAdjustment < (long)filesBeforeProbe) {
            return false;
        }
        this.endFileNumAtLastAdjustment = endFileNum;
        return true;
    }

    static class TestAdjustment {
        final long fileNum;
        final long endFileNum;
        final FileSummary estimatedFileSummary;
        final FileSummary trueFileSummary;
        final float estimatedAvgSize;
        final float trueAvgSize;
        final float correctionFactor;

        TestAdjustment(long fileNum, long endFileNum, FileSummary estimatedFileSummary, FileSummary trueFileSummary, float estimatedAvgSize, float trueAvgSize, float correctionFactor) {
            this.fileNum = fileNum;
            this.endFileNum = endFileNum;
            this.estimatedFileSummary = estimatedFileSummary;
            this.trueFileSummary = trueFileSummary;
            this.estimatedAvgSize = estimatedAvgSize;
            this.trueAvgSize = trueAvgSize;
            this.correctionFactor = correctionFactor;
        }
    }

    static class AverageSize {
        final int size;
        final int count;
        final int estSize;
        final int estCount;

        AverageSize(int size, int count, int estSize, int estCount) {
            this.size = size;
            this.count = count;
            this.estSize = estSize;
            this.estCount = estCount;
        }

        public boolean equals(Object other) {
            if (!(other instanceof AverageSize)) {
                return false;
            }
            AverageSize o = (AverageSize)other;
            return this.size == o.size && this.count == o.count && this.estSize == o.estSize && this.estCount == o.estCount;
        }

        public int hashCode() {
            return this.size + this.count + this.estSize + this.estCount;
        }

        public String toString() {
            return "size=" + this.size + " count=" + this.count + " estSize=" + this.estSize + " estCount=" + this.estCount;
        }
    }
}

