/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.Paths;
import org.forgerock.api.models.Resource;
import org.forgerock.api.models.VersionedPath;
import org.forgerock.guava.common.base.Optional;
import org.forgerock.http.ApiProducer;
import org.forgerock.json.resource.Request;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.util.Reject;

final class DescribableResourceHandler
implements Describable<ApiDescription, Request> {
    private final ApiDescription definitionDescriptions = ApiDescription.apiDescription().id("fake:id").version("0.0").build();
    private ApiDescription api;
    private Optional<Resource> resource;

    DescribableResourceHandler() {
    }

    ApiDescription getDefinitionDescriptions() {
        return this.definitionDescriptions;
    }

    void describes(Resource resource) {
        Reject.rejectStateIfTrue((this.resource != null ? 1 : 0) != 0, (String)"Already described API");
        this.resource = Optional.fromNullable((Object)resource);
    }

    public final ApiDescription api(ApiProducer<ApiDescription> producer) {
        Reject.rejectStateIfTrue((this.resource == null ? 1 : 0) != 0, (String)"Not yet described API");
        if (this.api == null && this.resource.isPresent()) {
            this.api = (ApiDescription)producer.addApiInfo((Object)ApiDescription.apiDescription().id("fake:id").version("0.0").definitions(this.definitionDescriptions.getDefinitions()).errors(this.definitionDescriptions.getErrors()).services(this.definitionDescriptions.getServices()).paths(Paths.paths().put("", VersionedPath.versionedPath().put(VersionedPath.UNVERSIONED, (Resource)this.resource.get()).build()).build()).build());
        }
        return this.api;
    }

    public ApiDescription handleApiRequest(Context context, Request request) {
        Reject.rejectStateIfTrue((this.api == null ? 1 : 0) != 0, (String)"Not ready for API Descriptor requests");
        return this.api;
    }

    public void addDescriptorListener(Describable.Listener listener) {
    }

    public void removeDescriptorListener(Describable.Listener listener) {
    }
}

