/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import java.io.IOException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.BuffersBuffer;
import org.glassfish.grizzly.memory.HeapMemoryManager;
import org.glassfish.grizzly.memory.MemoryManager;

final class SaslFilter
extends BaseFilter {
    private static final Attribute<SaslServer> SASL_SERVER_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(SaslFilter.class + ".sasl-server");
    static final String SASL_AUTH_CONFIDENTIALITY = "auth-conf";
    static final String SASL_AUTH_INTEGRITY = "auth-int";
    private static final int INT_SIZE = 4;
    private final boolean enableAfterNextMessage;

    static void setSaslServer(AttributeStorage storage, SaslServer server) {
        SASL_SERVER_ATTR.set(storage, (Object)server);
    }

    static SaslServer getSaslServer(AttributeStorage storage) {
        return (SaslServer)SASL_SERVER_ATTR.get(storage);
    }

    SaslFilter() {
        this(true);
    }

    private SaslFilter(boolean enableAfterNextMessage) {
        this.enableAfterNextMessage = enableAfterNextMessage;
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer message = (Buffer)ctx.getMessage();
        if (message.remaining() < 4) {
            return ctx.getStopAction((Object)message);
        }
        int length = message.mark().getInt();
        if (message.remaining() < length) {
            return ctx.getStopAction((Object)message.reset());
        }
        ctx.setMessage((Object)this.unwrap(ctx, message, length));
        if (message.position(message.position() + length).hasRemaining()) {
            return ctx.getInvokeAction((Object)message);
        }
        message.dispose();
        return ctx.getInvokeAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Buffer unwrap(FilterChainContext ctx, Buffer buffer, int length) throws SaslException {
        SaslServer saslServer = SaslFilter.getSaslServer((AttributeStorage)ctx.getConnection());
        if (buffer.hasArray()) {
            return Buffers.wrap((MemoryManager)ctx.getMemoryManager(), (byte[])saslServer.unwrap(buffer.array(), buffer.arrayOffset() + buffer.position(), length));
        }
        Buffer heapBuffer = this.toHeapBuffer(buffer, length);
        try {
            Buffer buffer2 = Buffers.wrap((MemoryManager)ctx.getMemoryManager(), (byte[])saslServer.unwrap(heapBuffer.array(), heapBuffer.arrayOffset() + heapBuffer.position(), length));
            return buffer2;
        }
        finally {
            heapBuffer.dispose();
        }
    }

    private final Buffer toHeapBuffer(Buffer buffer, int length) {
        return HeapMemoryManager.DEFAULT_MEMORY_MANAGER.allocate(length).put(buffer, buffer.position(), length).position(buffer.position() + length).flip();
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        if (this.enableAfterNextMessage) {
            ctx.getFilterChain().set(ctx.getFilterIdx(), (Object)new SaslFilter(false));
            return ctx.getInvokeAction();
        }
        Buffer message = (Buffer)ctx.getMessage();
        ctx.setMessage((Object)this.wrap(ctx, message));
        message.dispose();
        return ctx.getInvokeAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Buffer wrap(FilterChainContext ctx, Buffer buffer) throws SaslException {
        Buffer contentBuffer;
        SaslServer saslServer = SaslFilter.getSaslServer((AttributeStorage)ctx.getConnection());
        if (buffer.hasArray()) {
            contentBuffer = Buffers.wrap((MemoryManager)ctx.getMemoryManager(), (byte[])saslServer.wrap(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining()));
        } else {
            Buffer heapBuffer = this.toHeapBuffer(buffer, buffer.remaining());
            try {
                contentBuffer = Buffers.wrap((MemoryManager)ctx.getMemoryManager(), (byte[])saslServer.wrap(heapBuffer.array(), heapBuffer.arrayOffset() + heapBuffer.position(), heapBuffer.remaining()));
            }
            finally {
                heapBuffer.dispose();
            }
        }
        Buffer headerBuffer = ctx.getMemoryManager().allocate(4);
        headerBuffer.putInt(contentBuffer.limit());
        headerBuffer.flip();
        return BuffersBuffer.create((MemoryManager)ctx.getMemoryManager(), (Buffer[])new Buffer[]{headerBuffer, contentBuffer});
    }
}

