/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.grizzly.ASN1BufferReader;
import org.forgerock.opendj.grizzly.ASN1BufferWriter;
import org.forgerock.opendj.grizzly.GrizzlyUtils;
import org.forgerock.opendj.grizzly.LDAPBaseFilter;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.LDAPWriter;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.IntermediateResponse;
import org.forgerock.opendj.ldap.responses.Response;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldap.spi.LdapMessages;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

abstract class LdapCodec
extends LDAPBaseFilter {
    private boolean isLdapV2Pending;
    private boolean isLdapV2;

    LdapCodec(int maxElementSize, DecodeOptions decodeOptions) {
        super(decodeOptions, maxElementSize);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        try {
            Buffer buffer = (Buffer)ctx.getMessage();
            try (ASN1BufferReader reader = new ASN1BufferReader(this.maxASN1ElementSize, buffer);){
                int mark = buffer.position();
                if (!reader.elementAvailable()) {
                    buffer.position(mark);
                    NextAction nextAction = ctx.getStopAction((Object)buffer.duplicate());
                    return nextAction;
                }
                int length = reader.peekLength();
                if (length > this.maxASN1ElementSize) {
                    buffer.position(mark);
                    throw DecodeException.fatalError((LocalizableMessage)CoreMessages.ERR_LDAP_CLIENT_DECODE_MAX_REQUEST_SIZE_EXCEEDED.get((Object)length, (Object)this.maxASN1ElementSize));
                }
                Buffer remainder = buffer.remaining() > length ? buffer.split(buffer.position() + length) : null;
                buffer.position(mark);
                ctx.setMessage((Object)this.decodePacket(new ASN1BufferReader(this.maxASN1ElementSize, buffer.asReadOnlyBuffer())));
                buffer.tryDispose();
                NextAction nextAction = ctx.getInvokeAction((Object)remainder);
                return nextAction;
            }
        }
        catch (Exception e) {
            this.onLdapCodecError(ctx, e);
            ctx.getConnection().closeSilently();
            NextAction suspendAction = ctx.getSuspendAction();
            ctx.completeAndRecycle();
            return suspendAction;
        }
    }

    protected abstract void onLdapCodecError(FilterChainContext var1, Throwable var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessages.LdapRequestEnvelope decodePacket(ASN1BufferReader reader) throws IOException {
        reader.mark();
        try {
            ByteString rawDn;
            int ldapVersion;
            reader.readStartSequence();
            int messageId = (int)reader.readInteger();
            byte messageType = reader.peekType();
            switch (messageType) {
                case 96: {
                    reader.readStartSequence(messageType);
                    ldapVersion = (int)reader.readInteger();
                    rawDn = reader.readOctetString();
                    this.isLdapV2Pending = ldapVersion == 2;
                    break;
                }
                case 74: {
                    rawDn = reader.readOctetString(messageType);
                    ldapVersion = -1;
                    break;
                }
                case 99: 
                case 102: 
                case 104: 
                case 108: 
                case 110: {
                    reader.readStartSequence(messageType);
                    rawDn = reader.readOctetString();
                    ldapVersion = -1;
                    break;
                }
                default: {
                    rawDn = null;
                    ldapVersion = -1;
                }
            }
            LdapMessages.LdapRequestEnvelope ldapRequestEnvelope = LdapMessages.newRequestEnvelope((byte)messageType, (int)messageId, (int)ldapVersion, (ByteString)rawDn, (ASN1Reader)reader);
            return ldapRequestEnvelope;
        }
        finally {
            reader.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        LdapMessages.LdapResponseMessage response = (LdapMessages.LdapResponseMessage)ctx.getMessage();
        if (response.getMessageType() == 97 && ((BindResult)response.getContent()).isSuccess()) {
            this.isLdapV2 = this.isLdapV2Pending;
        }
        int protocolVersion = this.isLdapV2 ? 2 : 3;
        LDAPWriter<ASN1BufferWriter> writer = GrizzlyUtils.getWriter(ctx.getMemoryManager(), protocolVersion);
        try {
            Buffer buffer = this.toBuffer(writer, (LdapMessages.LdapResponseMessage)ctx.getMessage());
            ctx.setMessage((Object)buffer);
            NextAction nextAction = ctx.getInvokeAction();
            return nextAction;
        }
        catch (Exception e) {
            this.onLdapCodecError(ctx, e);
            ctx.getConnection().closeSilently();
            NextAction suspendAction = ctx.getSuspendAction();
            ctx.completeAndRecycle();
            NextAction nextAction = suspendAction;
            return nextAction;
        }
        finally {
            GrizzlyUtils.recycleWriter(writer);
        }
    }

    private Buffer toBuffer(LDAPWriter<ASN1BufferWriter> writer, LdapMessages.LdapResponseMessage message) throws IOException {
        int msgId = message.getMessageId();
        Response msgContent = (Response)message.getContent();
        switch (message.getMessageType()) {
            case 105: {
                writer.writeAddResult(msgId, (Result)msgContent);
                break;
            }
            case 97: {
                writer.writeBindResult(msgId, (BindResult)msgContent);
                break;
            }
            case 111: {
                writer.writeCompareResult(msgId, (CompareResult)msgContent);
                break;
            }
            case 107: {
                writer.writeDeleteResult(msgId, (Result)msgContent);
                break;
            }
            case 120: {
                writer.writeExtendedResult(msgId, (ExtendedResult)msgContent);
                break;
            }
            case 121: {
                writer.writeIntermediateResponse(msgId, (IntermediateResponse)msgContent);
                break;
            }
            case 109: {
                writer.writeModifyDNResult(msgId, (Result)msgContent);
                break;
            }
            case 103: {
                writer.writeModifyResult(msgId, (Result)msgContent);
                break;
            }
            case 101: {
                writer.writeSearchResult(msgId, (Result)msgContent);
                break;
            }
            case 100: {
                writer.writeSearchResultEntry(msgId, (SearchResultEntry)msgContent);
                break;
            }
            case 115: {
                writer.writeSearchResultReference(msgId, (SearchResultReference)msgContent);
                break;
            }
            default: {
                throw new IOException("Unsupported message type '" + message.getMessageType() + "'");
            }
        }
        return ((ASN1BufferWriter)writer.getASN1Writer()).getBuffer();
    }
}

