/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.opendj.util.ReferenceCountedObject;
import com.forgerock.reactive.ReactiveHandler;
import com.forgerock.reactive.Stream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.grizzly.GrizzlyUtils;
import org.forgerock.opendj.grizzly.LDAPServerFilter;
import org.forgerock.opendj.grizzly.ServerTCPNIOTransport;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.LDAPClientContext;
import org.forgerock.opendj.ldap.LDAPListener;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.responses.Response;
import org.forgerock.opendj.ldap.spi.LDAPListenerImpl;
import org.forgerock.opendj.ldap.spi.LdapMessages;
import org.forgerock.util.Function;
import org.forgerock.util.Options;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.nio.transport.TCPNIOBindingHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public final class GrizzlyLDAPListener
implements LDAPListenerImpl {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final ReferenceCountedObject.Reference transport;
    private final Collection<TCPNIOServerConnection> serverConnections;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final Set<InetSocketAddress> socketAddresses;
    private final Options options;

    public GrizzlyLDAPListener(Set<InetSocketAddress> addresses, Options options, Function<LDAPClientContext, ReactiveHandler<LDAPClientContext, LdapMessages.LdapRequestEnvelope, Stream<Response>>, LdapException> requestHandlerFactory) throws IOException {
        this(addresses, requestHandlerFactory, options, null);
    }

    public GrizzlyLDAPListener(Set<InetSocketAddress> addresses, Function<LDAPClientContext, ReactiveHandler<LDAPClientContext, LdapMessages.LdapRequestEnvelope, Stream<Response>>, LdapException> requestHandlerFactory, Options options, TCPNIOTransport transport) throws IOException {
        this.transport = ServerTCPNIOTransport.SERVER_TRANSPORT.acquireIfNull(transport);
        this.options = Options.copyOf((Options)options);
        LDAPServerFilter serverFilter = new LDAPServerFilter(requestHandlerFactory, options, (DecodeOptions)options.get(LDAPListener.LDAP_DECODE_OPTIONS), (Integer)options.get(LDAPListener.MAX_CONCURRENT_REQUESTS));
        FilterChain ldapChain = GrizzlyUtils.buildFilterChain(((TCPNIOTransport)this.transport.get()).getProcessor(), new Filter[]{serverFilter});
        TCPNIOBindingHandler bindingHandler = ((TCPNIOBindingHandler.Builder)TCPNIOBindingHandler.builder((TCPNIOTransport)((TCPNIOTransport)this.transport.get())).processor((Processor)ldapChain)).build();
        this.serverConnections = new ArrayList<TCPNIOServerConnection>(addresses.size());
        this.socketAddresses = new HashSet<InetSocketAddress>(addresses.size());
        for (InetSocketAddress address : addresses) {
            TCPNIOServerConnection bound = bindingHandler.bind((SocketAddress)address, ((Integer)options.get(LDAPListener.CONNECT_MAX_BACKLOG)).intValue());
            this.serverConnections.add(bound);
            this.socketAddresses.add((InetSocketAddress)bound.getLocalAddress());
        }
    }

    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                for (TCPNIOConnection tCPNIOConnection : this.serverConnections) {
                    tCPNIOConnection.closeSilently();
                }
            }
            catch (Exception e) {
                logger.warn(LocalizableMessage.raw((CharSequence)"Exception occurred while closing listener", (Object[])new Object[]{e}));
            }
            finally {
                this.transport.release();
            }
        }
    }

    public Set<InetSocketAddress> getSocketAddresses() {
        return this.socketAddresses;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LDAPListener(");
        builder.append(this.socketAddresses);
        builder.append(')');
        return builder.toString();
    }

    Options getLDAPListenerOptions() {
        return this.options;
    }
}

