/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.oauth2;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.protocol.Form;
import org.forgerock.http.protocol.Status;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;

public final class OAuth2Error {
    public static final String E_ACCESS_DENIED = "access_denied";
    public static final String E_INSUFFICIENT_SCOPE = "insufficient_scope";
    public static final String E_INVALID_CLIENT = "invalid_client";
    public static final String E_INVALID_GRANT = "invalid_grant";
    public static final String E_INVALID_REQUEST = "invalid_request";
    public static final String E_INVALID_SCOPE = "invalid_scope";
    public static final String E_INVALID_TOKEN = "invalid_token";
    public static final String E_SERVER_ERROR = "server_error";
    public static final String E_TEMPORARILY_UNAVAILABLE = "temporarily_unavailable";
    public static final String E_UNAUTHORIZED_CLIENT = "unauthorized_client";
    public static final String E_UNSUPPORTED_GRANT_TYPE = "unsupported_grant_type";
    public static final String E_UNSUPPORTED_RESPONSE_TYPE = "unsupported_response_type";
    public static final String F_ERROR = "error";
    public static final String F_ERROR_DESCRIPTION = "error_description";
    public static final String F_ERROR_URI = "error_uri";
    public static final String F_REALM = "realm";
    public static final String F_SCOPE = "scope";
    public static final String H_BEARER = "Bearer";
    private static final OAuth2Error EMPTY = new OAuth2Error(null, null, null, null, null);
    private static final String H_BEARER_WITH_SPACE = "Bearer ";
    private final String error;
    private final String errorDescription;
    private final String errorUri;
    private final String realm;
    private final List<String> scope;
    private transient String stringValue;

    public static OAuth2Error bestEffortResourceServerError(Status status, OAuth2Error incomplete) {
        if (incomplete != null && incomplete.error != null) {
            return incomplete;
        }
        String error = OAuth2Error.mapStatusToError(status);
        if (incomplete == null) {
            return new OAuth2Error(null, null, error, null, null);
        }
        return new OAuth2Error(incomplete.getRealm(), incomplete.getScope(), error, incomplete.getErrorDescription(), incomplete.getErrorUri());
    }

    private static String mapStatusToError(Status status) {
        if (Status.BAD_REQUEST.equals(status)) {
            return E_INVALID_REQUEST;
        }
        if (Status.UNAUTHORIZED.equals(status)) {
            return E_INVALID_TOKEN;
        }
        if (Status.FORBIDDEN.equals(status)) {
            return E_INVALID_SCOPE;
        }
        if (Status.METHOD_NOT_ALLOWED.equals(status)) {
            return E_INVALID_REQUEST;
        }
        if (Status.INTERNAL_SERVER_ERROR.equals(status)) {
            return E_SERVER_ERROR;
        }
        if (Status.SERVICE_UNAVAILABLE.equals(status)) {
            return E_TEMPORARILY_UNAVAILABLE;
        }
        return E_SERVER_ERROR;
    }

    public static OAuth2Error newAuthorizationServerError(String error, String errorDescription) {
        Reject.ifNull((Object)error);
        return new OAuth2Error(null, null, error, errorDescription, null);
    }

    public static OAuth2Error newAuthorizationServerError(String error, String errorDescription, String errorUri) {
        Reject.ifNull((Object)error);
        return new OAuth2Error(null, null, error, errorDescription, errorUri);
    }

    public static OAuth2Error newResourceServerError(String realm, List<String> scope, String error, String errorDescription, String errorUri) {
        return new OAuth2Error(realm, scope, error, errorDescription, errorUri);
    }

    public static OAuth2Error valueOf(String s) {
        List attributes = HeaderUtil.split((String)s, (char)',');
        Map map = HeaderUtil.parseParameters((Collection)attributes);
        String realm = (String)map.get(F_REALM);
        String scopeString = (String)map.get(F_SCOPE);
        List<String> scopes = scopeString != null ? Arrays.asList(scopeString.trim().split("\\s+")) : null;
        String error = (String)map.get(F_ERROR);
        String errorDescription = (String)map.get(F_ERROR_DESCRIPTION);
        String errorUri = (String)map.get(F_ERROR_URI);
        return new OAuth2Error(realm, scopes, error, errorDescription, errorUri);
    }

    public static OAuth2Error valueOfForm(Form form) {
        return new OAuth2Error(null, null, (String)form.getFirst((Object)F_ERROR), (String)form.getFirst((Object)F_ERROR_DESCRIPTION), (String)form.getFirst((Object)F_ERROR_URI));
    }

    public static OAuth2Error valueOfJsonContent(Map<String, Object> json) {
        JsonValue jv = new JsonValue(json);
        try {
            return new OAuth2Error(null, null, jv.get(F_ERROR).asString(), jv.get(F_ERROR_DESCRIPTION).asString(), jv.get(F_ERROR_URI).asString());
        }
        catch (JsonValueException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static OAuth2Error valueOfWWWAuthenticateHeader(String s) {
        if (H_BEARER.equals(s)) {
            return EMPTY;
        }
        if (s.startsWith(H_BEARER_WITH_SPACE)) {
            return OAuth2Error.valueOf(s.substring(H_BEARER_WITH_SPACE.length()));
        }
        throw new IllegalArgumentException("Malformed WWW-Authenticate header '" + s + "'");
    }

    private OAuth2Error(String realm, List<String> scope, String error, String errorDescription, String errorUri) {
        this.realm = realm;
        this.scope = scope != null ? Collections.unmodifiableList(scope) : Collections.emptyList();
        this.error = error;
        this.errorDescription = errorDescription;
        this.errorUri = errorUri;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OAuth2Error) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public String getError() {
        return this.error;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public String getErrorUri() {
        return this.errorUri;
    }

    public String getRealm() {
        return this.realm;
    }

    public List<String> getScope() {
        return this.scope;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean is(String error) {
        return error.equalsIgnoreCase(this.error);
    }

    public Form toForm() {
        Form form = new Form();
        if (this.error != null) {
            form.add((Object)F_ERROR, (Object)this.error);
        }
        if (this.errorDescription != null) {
            form.add((Object)F_ERROR_DESCRIPTION, (Object)this.errorDescription);
        }
        if (this.errorUri != null) {
            form.add((Object)F_ERROR_URI, (Object)this.errorUri);
        }
        return form;
    }

    public Map<String, Object> toJsonContent() {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>(3);
        if (this.error != null) {
            json.put(F_ERROR, this.error);
        }
        if (this.errorDescription != null) {
            json.put(F_ERROR_DESCRIPTION, this.errorDescription);
        }
        if (this.errorUri != null) {
            json.put(F_ERROR_URI, this.errorUri);
        }
        return json;
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder builder = new StringBuilder();
            this.appendAttribute(builder, F_REALM, this.realm);
            this.appendAttribute(builder, F_SCOPE, this.scope.isEmpty() ? null : Utils.joinAsString((String)" ", this.scope));
            this.appendAttribute(builder, F_ERROR, this.error);
            this.appendAttribute(builder, F_ERROR_DESCRIPTION, this.errorDescription);
            this.appendAttribute(builder, F_ERROR_URI, this.errorUri);
            this.stringValue = builder.toString();
        }
        return this.stringValue;
    }

    public String toWWWAuthenticateHeader() {
        String stringValue = this.toString();
        return stringValue.isEmpty() ? H_BEARER : H_BEARER_WITH_SPACE + stringValue;
    }

    private void addSeparator(StringBuilder builder) {
        if (builder.length() > 0) {
            builder.append(", ");
        }
    }

    private void appendAttribute(StringBuilder builder, String key, String value) {
        if (value != null) {
            this.addSeparator(builder);
            builder.append(key).append('=').append(HeaderUtil.quote((String)value));
        }
    }
}

