/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.SizePropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.SizeLimitLogRotationPolicyCfgClient;
import org.forgerock.opendj.server.config.meta.LogRotationPolicyCfgDefn;
import org.forgerock.opendj.server.config.server.LogRotationPolicyCfg;
import org.forgerock.opendj.server.config.server.SizeLimitLogRotationPolicyCfg;

public final class SizeLimitLogRotationPolicyCfgDefn
extends ManagedObjectDefinition<SizeLimitLogRotationPolicyCfgClient, SizeLimitLogRotationPolicyCfg> {
    private static final SizeLimitLogRotationPolicyCfgDefn INSTANCE = new SizeLimitLogRotationPolicyCfgDefn();
    private static final SizePropertyDefinition PD_FILE_SIZE_LIMIT;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static SizeLimitLogRotationPolicyCfgDefn getInstance() {
        return INSTANCE;
    }

    private SizeLimitLogRotationPolicyCfgDefn() {
        super("size-limit-log-rotation-policy", LogRotationPolicyCfgDefn.getInstance());
    }

    @Override
    public SizeLimitLogRotationPolicyCfgClient createClientConfiguration(ManagedObject<? extends SizeLimitLogRotationPolicyCfgClient> impl) {
        return new SizeLimitLogRotationPolicyCfgClientImpl(impl);
    }

    @Override
    public SizeLimitLogRotationPolicyCfg createServerConfiguration(ServerManagedObject<? extends SizeLimitLogRotationPolicyCfg> impl) {
        return new SizeLimitLogRotationPolicyCfgServerImpl(impl);
    }

    @Override
    public Class<SizeLimitLogRotationPolicyCfg> getServerConfigurationClass() {
        return SizeLimitLogRotationPolicyCfg.class;
    }

    public SizePropertyDefinition getFileSizeLimitPropertyDefinition() {
        return PD_FILE_SIZE_LIMIT;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = SizePropertyDefinition.createBuilder(INSTANCE, "file-size-limit");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "file-size-limit"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((SizePropertyDefinition.Builder)builder).setLowerLimit("1");
        PD_FILE_SIZE_LIMIT = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_FILE_SIZE_LIMIT);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.loggers.SizeBasedRotationPolicy");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.loggers.RotationPolicy");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerTag(Tag.valueOf("logging"));
    }

    private static class SizeLimitLogRotationPolicyCfgServerImpl
    implements SizeLimitLogRotationPolicyCfg {
        private ServerManagedObject<? extends SizeLimitLogRotationPolicyCfg> impl;
        private final long pFileSizeLimit;
        private final String pJavaClass;

        private SizeLimitLogRotationPolicyCfgServerImpl(ServerManagedObject<? extends SizeLimitLogRotationPolicyCfg> impl) {
            this.impl = impl;
            this.pFileSizeLimit = impl.getPropertyValue(INSTANCE.getFileSizeLimitPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void addSizeLimitChangeListener(ConfigurationChangeListener<SizeLimitLogRotationPolicyCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeSizeLimitChangeListener(ConfigurationChangeListener<SizeLimitLogRotationPolicyCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<LogRotationPolicyCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<LogRotationPolicyCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public long getFileSizeLimit() {
            return this.pFileSizeLimit;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Class<? extends SizeLimitLogRotationPolicyCfg> configurationClass() {
            return SizeLimitLogRotationPolicyCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class SizeLimitLogRotationPolicyCfgClientImpl
    implements SizeLimitLogRotationPolicyCfgClient {
        private ManagedObject<? extends SizeLimitLogRotationPolicyCfgClient> impl;

        private SizeLimitLogRotationPolicyCfgClientImpl(ManagedObject<? extends SizeLimitLogRotationPolicyCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Long getFileSizeLimit() {
            return this.impl.getPropertyValue(INSTANCE.getFileSizeLimitPropertyDefinition());
        }

        @Override
        public void setFileSizeLimit(long value) {
            this.impl.setPropertyValue(INSTANCE.getFileSizeLimitPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends SizeLimitLogRotationPolicyCfgClient, ? extends SizeLimitLogRotationPolicyCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

