/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.conditions.Conditions;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.PasswordPolicyImportPluginCfgClient;
import org.forgerock.opendj.server.config.client.PasswordStorageSchemeCfgClient;
import org.forgerock.opendj.server.config.meta.PluginCfgDefn;
import org.forgerock.opendj.server.config.server.PasswordPolicyImportPluginCfg;
import org.forgerock.opendj.server.config.server.PasswordStorageSchemeCfg;
import org.forgerock.opendj.server.config.server.PluginCfg;

public final class PasswordPolicyImportPluginCfgDefn
extends ManagedObjectDefinition<PasswordPolicyImportPluginCfgClient, PasswordPolicyImportPluginCfg> {
    private static final PasswordPolicyImportPluginCfgDefn INSTANCE = new PasswordPolicyImportPluginCfgDefn();
    private static final AggregationPropertyDefinition<PasswordStorageSchemeCfgClient, PasswordStorageSchemeCfg> PD_DEFAULT_AUTH_PASSWORD_STORAGE_SCHEME;
    private static final AggregationPropertyDefinition<PasswordStorageSchemeCfgClient, PasswordStorageSchemeCfg> PD_DEFAULT_USER_PASSWORD_STORAGE_SCHEME;
    private static final BooleanPropertyDefinition PD_INVOKE_FOR_INTERNAL_OPERATIONS;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final EnumPropertyDefinition<PluginCfgDefn.PluginType> PD_PLUGIN_TYPE;

    public static PasswordPolicyImportPluginCfgDefn getInstance() {
        return INSTANCE;
    }

    private PasswordPolicyImportPluginCfgDefn() {
        super("password-policy-import-plugin", PluginCfgDefn.getInstance());
    }

    @Override
    public PasswordPolicyImportPluginCfgClient createClientConfiguration(ManagedObject<? extends PasswordPolicyImportPluginCfgClient> impl) {
        return new PasswordPolicyImportPluginCfgClientImpl(impl);
    }

    @Override
    public PasswordPolicyImportPluginCfg createServerConfiguration(ServerManagedObject<? extends PasswordPolicyImportPluginCfg> impl) {
        return new PasswordPolicyImportPluginCfgServerImpl(impl);
    }

    @Override
    public Class<PasswordPolicyImportPluginCfg> getServerConfigurationClass() {
        return PasswordPolicyImportPluginCfg.class;
    }

    public AggregationPropertyDefinition<PasswordStorageSchemeCfgClient, PasswordStorageSchemeCfg> getDefaultAuthPasswordStorageSchemePropertyDefinition() {
        return PD_DEFAULT_AUTH_PASSWORD_STORAGE_SCHEME;
    }

    public AggregationPropertyDefinition<PasswordStorageSchemeCfgClient, PasswordStorageSchemeCfg> getDefaultUserPasswordStorageSchemePropertyDefinition() {
        return PD_DEFAULT_USER_PASSWORD_STORAGE_SCHEME;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PluginCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public BooleanPropertyDefinition getInvokeForInternalOperationsPropertyDefinition() {
        return PD_INVOKE_FOR_INTERNAL_OPERATIONS;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public EnumPropertyDefinition<PluginCfgDefn.PluginType> getPluginTypePropertyDefinition() {
        return PD_PLUGIN_TYPE;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "default-auth-password-storage-scheme");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "default-auth-password-storage-scheme"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "default-auth-password-storage-scheme"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("password-storage-scheme");
        ((AggregationPropertyDefinition.Builder)builder).setTargetNeedsEnablingCondition(Conditions.contains("enabled", "true"));
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_DEFAULT_AUTH_PASSWORD_STORAGE_SCHEME = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DEFAULT_AUTH_PASSWORD_STORAGE_SCHEME);
        INSTANCE.registerConstraint(PD_DEFAULT_AUTH_PASSWORD_STORAGE_SCHEME.getSourceConstraint());
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "default-user-password-storage-scheme");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "default-user-password-storage-scheme"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "default-user-password-storage-scheme"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("password-storage-scheme");
        ((AggregationPropertyDefinition.Builder)builder).setTargetNeedsEnablingCondition(Conditions.contains("enabled", "true"));
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_DEFAULT_USER_PASSWORD_STORAGE_SCHEME = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DEFAULT_USER_PASSWORD_STORAGE_SCHEME);
        INSTANCE.registerConstraint(PD_DEFAULT_USER_PASSWORD_STORAGE_SCHEME.getSourceConstraint());
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "invoke-for-internal-operations");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "invoke-for-internal-operations"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_INVOKE_FOR_INTERNAL_OPERATIONS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INVOKE_FOR_INTERNAL_OPERATIONS);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.plugins.PasswordPolicyImportPlugin");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.plugin.DirectoryServerPlugin");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "plugin-type");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "plugin-type"));
        provider = new DefinedDefaultBehaviorProvider("ldifimport");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(PluginCfgDefn.PluginType.class);
        PD_PLUGIN_TYPE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PLUGIN_TYPE);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class PasswordPolicyImportPluginCfgServerImpl
    implements PasswordPolicyImportPluginCfg {
        private ServerManagedObject<? extends PasswordPolicyImportPluginCfg> impl;
        private final SortedSet<String> pDefaultAuthPasswordStorageScheme;
        private final SortedSet<String> pDefaultUserPasswordStorageScheme;
        private final boolean pEnabled;
        private final boolean pInvokeForInternalOperations;
        private final String pJavaClass;
        private final SortedSet<PluginCfgDefn.PluginType> pPluginType;

        private PasswordPolicyImportPluginCfgServerImpl(ServerManagedObject<? extends PasswordPolicyImportPluginCfg> impl) {
            this.impl = impl;
            this.pDefaultAuthPasswordStorageScheme = impl.getPropertyValues(INSTANCE.getDefaultAuthPasswordStorageSchemePropertyDefinition());
            this.pDefaultUserPasswordStorageScheme = impl.getPropertyValues(INSTANCE.getDefaultUserPasswordStorageSchemePropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pInvokeForInternalOperations = impl.getPropertyValue(INSTANCE.getInvokeForInternalOperationsPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pPluginType = impl.getPropertyValues(INSTANCE.getPluginTypePropertyDefinition());
        }

        @Override
        public void addPasswordPolicyImportChangeListener(ConfigurationChangeListener<PasswordPolicyImportPluginCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removePasswordPolicyImportChangeListener(ConfigurationChangeListener<PasswordPolicyImportPluginCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<PluginCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<PluginCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<String> getDefaultAuthPasswordStorageScheme() {
            return this.pDefaultAuthPasswordStorageScheme;
        }

        @Override
        public SortedSet<DN> getDefaultAuthPasswordStorageSchemeDNs() {
            SortedSet<String> values = this.getDefaultAuthPasswordStorageScheme();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getDefaultAuthPasswordStorageSchemePropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public SortedSet<String> getDefaultUserPasswordStorageScheme() {
            return this.pDefaultUserPasswordStorageScheme;
        }

        @Override
        public SortedSet<DN> getDefaultUserPasswordStorageSchemeDNs() {
            SortedSet<String> values = this.getDefaultUserPasswordStorageScheme();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getDefaultUserPasswordStorageSchemePropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public boolean isInvokeForInternalOperations() {
            return this.pInvokeForInternalOperations;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public SortedSet<PluginCfgDefn.PluginType> getPluginType() {
            return this.pPluginType;
        }

        @Override
        public Class<? extends PasswordPolicyImportPluginCfg> configurationClass() {
            return PasswordPolicyImportPluginCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class PasswordPolicyImportPluginCfgClientImpl
    implements PasswordPolicyImportPluginCfgClient {
        private ManagedObject<? extends PasswordPolicyImportPluginCfgClient> impl;

        private PasswordPolicyImportPluginCfgClientImpl(ManagedObject<? extends PasswordPolicyImportPluginCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<String> getDefaultAuthPasswordStorageScheme() {
            return this.impl.getPropertyValues(INSTANCE.getDefaultAuthPasswordStorageSchemePropertyDefinition());
        }

        @Override
        public void setDefaultAuthPasswordStorageScheme(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getDefaultAuthPasswordStorageSchemePropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getDefaultUserPasswordStorageScheme() {
            return this.impl.getPropertyValues(INSTANCE.getDefaultUserPasswordStorageSchemePropertyDefinition());
        }

        @Override
        public void setDefaultUserPasswordStorageScheme(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getDefaultUserPasswordStorageSchemePropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public boolean isInvokeForInternalOperations() {
            return this.impl.getPropertyValue(INSTANCE.getInvokeForInternalOperationsPropertyDefinition());
        }

        @Override
        public void setInvokeForInternalOperations(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getInvokeForInternalOperationsPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public SortedSet<PluginCfgDefn.PluginType> getPluginType() {
            return this.impl.getPropertyValues(INSTANCE.getPluginTypePropertyDefinition());
        }

        @Override
        public void setPluginType(Collection<PluginCfgDefn.PluginType> values) {
            this.impl.setPropertyValues(INSTANCE.getPluginTypePropertyDefinition(), values);
        }

        @Override
        public ManagedObjectDefinition<? extends PasswordPolicyImportPluginCfgClient, ? extends PasswordPolicyImportPluginCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

