/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.conditions.Conditions;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgClient;
import org.forgerock.opendj.server.config.client.IdentityMapperCfgClient;
import org.forgerock.opendj.server.config.client.KeyManagerProviderCfgClient;
import org.forgerock.opendj.server.config.client.TrustManagerProviderCfgClient;
import org.forgerock.opendj.server.config.meta.HTTPOauth2AuthorizationMechanismCfgDefn;
import org.forgerock.opendj.server.config.server.HTTPAuthorizationMechanismCfg;
import org.forgerock.opendj.server.config.server.HTTPOauth2AuthorizationMechanismCfg;
import org.forgerock.opendj.server.config.server.HTTPOauth2TokenIntrospectionAuthorizationMechanismCfg;
import org.forgerock.opendj.server.config.server.IdentityMapperCfg;
import org.forgerock.opendj.server.config.server.KeyManagerProviderCfg;
import org.forgerock.opendj.server.config.server.TrustManagerProviderCfg;

public final class HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgDefn
extends ManagedObjectDefinition<HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgClient, HTTPOauth2TokenIntrospectionAuthorizationMechanismCfg> {
    private static final HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgDefn INSTANCE = new HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgDefn();
    private static final StringPropertyDefinition PD_AUTHZID_JSON_POINTER;
    private static final StringPropertyDefinition PD_CLIENT_ID;
    private static final StringPropertyDefinition PD_CLIENT_SECRET;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final AggregationPropertyDefinition<KeyManagerProviderCfgClient, KeyManagerProviderCfg> PD_KEY_MANAGER_PROVIDER;
    private static final StringPropertyDefinition PD_TOKEN_INTROSPECTION_URL;
    private static final AggregationPropertyDefinition<TrustManagerProviderCfgClient, TrustManagerProviderCfg> PD_TRUST_MANAGER_PROVIDER;

    public static HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgDefn getInstance() {
        return INSTANCE;
    }

    private HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgDefn() {
        super("http-oauth2-token-introspection-authorization-mechanism", HTTPOauth2AuthorizationMechanismCfgDefn.getInstance());
    }

    @Override
    public HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgClient createClientConfiguration(ManagedObject<? extends HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgClient> impl) {
        return new HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgClientImpl(impl);
    }

    @Override
    public HTTPOauth2TokenIntrospectionAuthorizationMechanismCfg createServerConfiguration(ServerManagedObject<? extends HTTPOauth2TokenIntrospectionAuthorizationMechanismCfg> impl) {
        return new HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgServerImpl(impl);
    }

    @Override
    public Class<HTTPOauth2TokenIntrospectionAuthorizationMechanismCfg> getServerConfigurationClass() {
        return HTTPOauth2TokenIntrospectionAuthorizationMechanismCfg.class;
    }

    public BooleanPropertyDefinition getAccessTokenCacheEnabledPropertyDefinition() {
        return HTTPOauth2AuthorizationMechanismCfgDefn.getInstance().getAccessTokenCacheEnabledPropertyDefinition();
    }

    public DurationPropertyDefinition getAccessTokenCacheExpirationPropertyDefinition() {
        return HTTPOauth2AuthorizationMechanismCfgDefn.getInstance().getAccessTokenCacheExpirationPropertyDefinition();
    }

    public StringPropertyDefinition getAuthzidJsonPointerPropertyDefinition() {
        return PD_AUTHZID_JSON_POINTER;
    }

    public StringPropertyDefinition getClientIdPropertyDefinition() {
        return PD_CLIENT_ID;
    }

    public StringPropertyDefinition getClientSecretPropertyDefinition() {
        return PD_CLIENT_SECRET;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return HTTPOauth2AuthorizationMechanismCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public AggregationPropertyDefinition<IdentityMapperCfgClient, IdentityMapperCfg> getIdentityMapperPropertyDefinition() {
        return HTTPOauth2AuthorizationMechanismCfgDefn.getInstance().getIdentityMapperPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public AggregationPropertyDefinition<KeyManagerProviderCfgClient, KeyManagerProviderCfg> getKeyManagerProviderPropertyDefinition() {
        return PD_KEY_MANAGER_PROVIDER;
    }

    public StringPropertyDefinition getRequiredScopePropertyDefinition() {
        return HTTPOauth2AuthorizationMechanismCfgDefn.getInstance().getRequiredScopePropertyDefinition();
    }

    public StringPropertyDefinition getTokenIntrospectionUrlPropertyDefinition() {
        return PD_TOKEN_INTROSPECTION_URL;
    }

    public AggregationPropertyDefinition<TrustManagerProviderCfgClient, TrustManagerProviderCfg> getTrustManagerProviderPropertyDefinition() {
        return PD_TRUST_MANAGER_PROVIDER;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = StringPropertyDefinition.createBuilder(INSTANCE, "authzid-json-pointer");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "authzid-json-pointer"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_AUTHZID_JSON_POINTER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_AUTHZID_JSON_POINTER);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "client-id");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "client-id"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_CLIENT_ID = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CLIENT_ID);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "client-secret");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "client-secret"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_CLIENT_SECRET = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CLIENT_SECRET);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.protocols.http.authz.HttpOAuth2TokenIntrospectionAuthorizationMechanism");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.protocols.http.authz.HttpAuthorizationMechanism");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "key-manager-provider");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-manager-provider"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("key-manager-provider");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_KEY_MANAGER_PROVIDER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_MANAGER_PROVIDER);
        INSTANCE.registerConstraint(PD_KEY_MANAGER_PROVIDER.getSourceConstraint());
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "token-introspection-url");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "token-introspection-url"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_TOKEN_INTROSPECTION_URL = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TOKEN_INTROSPECTION_URL);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "trust-manager-provider");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "trust-manager-provider"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "trust-manager-provider"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("trust-manager-provider");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_TRUST_MANAGER_PROVIDER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TRUST_MANAGER_PROVIDER);
        INSTANCE.registerConstraint(PD_TRUST_MANAGER_PROVIDER.getSourceConstraint());
        INSTANCE.registerTag(Tag.valueOf("security"));
    }

    private static class HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgServerImpl
    implements HTTPOauth2TokenIntrospectionAuthorizationMechanismCfg {
        private ServerManagedObject<? extends HTTPOauth2TokenIntrospectionAuthorizationMechanismCfg> impl;
        private final boolean pAccessTokenCacheEnabled;
        private final Long pAccessTokenCacheExpiration;
        private final String pAuthzidJsonPointer;
        private final String pClientId;
        private final String pClientSecret;
        private final boolean pEnabled;
        private final String pIdentityMapper;
        private final String pJavaClass;
        private final String pKeyManagerProvider;
        private final SortedSet<String> pRequiredScope;
        private final String pTokenIntrospectionUrl;
        private final String pTrustManagerProvider;

        private HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgServerImpl(ServerManagedObject<? extends HTTPOauth2TokenIntrospectionAuthorizationMechanismCfg> impl) {
            this.impl = impl;
            this.pAccessTokenCacheEnabled = impl.getPropertyValue(INSTANCE.getAccessTokenCacheEnabledPropertyDefinition());
            this.pAccessTokenCacheExpiration = impl.getPropertyValue(INSTANCE.getAccessTokenCacheExpirationPropertyDefinition());
            this.pAuthzidJsonPointer = impl.getPropertyValue(INSTANCE.getAuthzidJsonPointerPropertyDefinition());
            this.pClientId = impl.getPropertyValue(INSTANCE.getClientIdPropertyDefinition());
            this.pClientSecret = impl.getPropertyValue(INSTANCE.getClientSecretPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pIdentityMapper = impl.getPropertyValue(INSTANCE.getIdentityMapperPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pKeyManagerProvider = impl.getPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition());
            this.pRequiredScope = impl.getPropertyValues((PropertyDefinition)INSTANCE.getRequiredScopePropertyDefinition());
            this.pTokenIntrospectionUrl = impl.getPropertyValue(INSTANCE.getTokenIntrospectionUrlPropertyDefinition());
            this.pTrustManagerProvider = impl.getPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition());
        }

        @Override
        public void addHTTPOauth2TokenIntrospectionAuthorizationMechanismChangeListener(ConfigurationChangeListener<HTTPOauth2TokenIntrospectionAuthorizationMechanismCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeHTTPOauth2TokenIntrospectionAuthorizationMechanismChangeListener(ConfigurationChangeListener<HTTPOauth2TokenIntrospectionAuthorizationMechanismCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addHTTPOauth2AuthorizationMechanismChangeListener(ConfigurationChangeListener<HTTPOauth2AuthorizationMechanismCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeHTTPOauth2AuthorizationMechanismChangeListener(ConfigurationChangeListener<HTTPOauth2AuthorizationMechanismCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<HTTPAuthorizationMechanismCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<HTTPAuthorizationMechanismCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isAccessTokenCacheEnabled() {
            return this.pAccessTokenCacheEnabled;
        }

        @Override
        public Long getAccessTokenCacheExpiration() {
            return this.pAccessTokenCacheExpiration;
        }

        @Override
        public String getAuthzidJsonPointer() {
            return this.pAuthzidJsonPointer;
        }

        @Override
        public String getClientId() {
            return this.pClientId;
        }

        @Override
        public String getClientSecret() {
            return this.pClientSecret;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getIdentityMapper() {
            return this.pIdentityMapper;
        }

        @Override
        public DN getIdentityMapperDN() {
            String value = this.getIdentityMapper();
            if (value == null) {
                return null;
            }
            return INSTANCE.getIdentityMapperPropertyDefinition().getChildDN(value);
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getKeyManagerProvider() {
            return this.pKeyManagerProvider;
        }

        @Override
        public DN getKeyManagerProviderDN() {
            String value = this.getKeyManagerProvider();
            if (value == null) {
                return null;
            }
            return INSTANCE.getKeyManagerProviderPropertyDefinition().getChildDN(value);
        }

        @Override
        public SortedSet<String> getRequiredScope() {
            return this.pRequiredScope;
        }

        @Override
        public String getTokenIntrospectionUrl() {
            return this.pTokenIntrospectionUrl;
        }

        @Override
        public String getTrustManagerProvider() {
            return this.pTrustManagerProvider;
        }

        @Override
        public DN getTrustManagerProviderDN() {
            String value = this.getTrustManagerProvider();
            if (value == null) {
                return null;
            }
            return INSTANCE.getTrustManagerProviderPropertyDefinition().getChildDN(value);
        }

        @Override
        public Class<? extends HTTPOauth2TokenIntrospectionAuthorizationMechanismCfg> configurationClass() {
            return HTTPOauth2TokenIntrospectionAuthorizationMechanismCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgClientImpl
    implements HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgClient {
        private ManagedObject<? extends HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgClient> impl;

        private HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgClientImpl(ManagedObject<? extends HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public boolean isAccessTokenCacheEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getAccessTokenCacheEnabledPropertyDefinition());
        }

        @Override
        public void setAccessTokenCacheEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAccessTokenCacheEnabledPropertyDefinition(), value);
        }

        @Override
        public Long getAccessTokenCacheExpiration() {
            return this.impl.getPropertyValue(INSTANCE.getAccessTokenCacheExpirationPropertyDefinition());
        }

        @Override
        public void setAccessTokenCacheExpiration(Long value) {
            this.impl.setPropertyValue(INSTANCE.getAccessTokenCacheExpirationPropertyDefinition(), value);
        }

        @Override
        public String getAuthzidJsonPointer() {
            return this.impl.getPropertyValue(INSTANCE.getAuthzidJsonPointerPropertyDefinition());
        }

        @Override
        public void setAuthzidJsonPointer(String value) {
            this.impl.setPropertyValue(INSTANCE.getAuthzidJsonPointerPropertyDefinition(), value);
        }

        @Override
        public String getClientId() {
            return this.impl.getPropertyValue(INSTANCE.getClientIdPropertyDefinition());
        }

        @Override
        public void setClientId(String value) {
            this.impl.setPropertyValue(INSTANCE.getClientIdPropertyDefinition(), value);
        }

        @Override
        public String getClientSecret() {
            return this.impl.getPropertyValue(INSTANCE.getClientSecretPropertyDefinition());
        }

        @Override
        public void setClientSecret(String value) {
            this.impl.setPropertyValue(INSTANCE.getClientSecretPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getIdentityMapper() {
            return this.impl.getPropertyValue(INSTANCE.getIdentityMapperPropertyDefinition());
        }

        @Override
        public void setIdentityMapper(String value) {
            this.impl.setPropertyValue(INSTANCE.getIdentityMapperPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getKeyManagerProvider() {
            return this.impl.getPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition());
        }

        @Override
        public void setKeyManagerProvider(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getRequiredScope() {
            return this.impl.getPropertyValues(INSTANCE.getRequiredScopePropertyDefinition());
        }

        @Override
        public void setRequiredScope(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getRequiredScopePropertyDefinition(), values);
        }

        @Override
        public String getTokenIntrospectionUrl() {
            return this.impl.getPropertyValue(INSTANCE.getTokenIntrospectionUrlPropertyDefinition());
        }

        @Override
        public void setTokenIntrospectionUrl(String value) {
            this.impl.setPropertyValue(INSTANCE.getTokenIntrospectionUrlPropertyDefinition(), value);
        }

        @Override
        public String getTrustManagerProvider() {
            return this.impl.getPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition());
        }

        @Override
        public void setTrustManagerProvider(String value) {
            this.impl.setPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends HTTPOauth2TokenIntrospectionAuthorizationMechanismCfgClient, ? extends HTTPOauth2TokenIntrospectionAuthorizationMechanismCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

