/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.TopCfgDefn;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.conditions.Conditions;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.HTTPAuthorizationMechanismCfgClient;
import org.forgerock.opendj.server.config.client.HTTPEndpointCfgClient;
import org.forgerock.opendj.server.config.server.HTTPAuthorizationMechanismCfg;
import org.forgerock.opendj.server.config.server.HTTPEndpointCfg;

public final class HTTPEndpointCfgDefn
extends ManagedObjectDefinition<HTTPEndpointCfgClient, HTTPEndpointCfg> {
    private static final HTTPEndpointCfgDefn INSTANCE = new HTTPEndpointCfgDefn();
    private static final AggregationPropertyDefinition<HTTPAuthorizationMechanismCfgClient, HTTPAuthorizationMechanismCfg> PD_AUTHORIZATION_MECHANISM;
    private static final StringPropertyDefinition PD_BASE_PATH;
    private static final BooleanPropertyDefinition PD_ENABLED;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static HTTPEndpointCfgDefn getInstance() {
        return INSTANCE;
    }

    private HTTPEndpointCfgDefn() {
        super("http-endpoint", TopCfgDefn.getInstance());
    }

    @Override
    public HTTPEndpointCfgClient createClientConfiguration(ManagedObject<? extends HTTPEndpointCfgClient> impl) {
        return new HTTPEndpointCfgClientImpl(impl);
    }

    @Override
    public HTTPEndpointCfg createServerConfiguration(ServerManagedObject<? extends HTTPEndpointCfg> impl) {
        return new HTTPEndpointCfgServerImpl(impl);
    }

    @Override
    public Class<HTTPEndpointCfg> getServerConfigurationClass() {
        return HTTPEndpointCfg.class;
    }

    public AggregationPropertyDefinition<HTTPAuthorizationMechanismCfgClient, HTTPAuthorizationMechanismCfg> getAuthorizationMechanismPropertyDefinition() {
        return PD_AUTHORIZATION_MECHANISM;
    }

    public StringPropertyDefinition getBasePathPropertyDefinition() {
        return PD_BASE_PATH;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PD_ENABLED;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "authorization-mechanism");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "authorization-mechanism"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("http-authorization-mechanism");
        ((AggregationPropertyDefinition.Builder)builder).setTargetNeedsEnablingCondition(Conditions.contains("enabled", "true"));
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_AUTHORIZATION_MECHANISM = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_AUTHORIZATION_MECHANISM);
        INSTANCE.registerConstraint(PD_AUTHORIZATION_MECHANISM.getSourceConstraint());
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "base-path");
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "base-path"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_BASE_PATH = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BASE_PATH);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "enabled");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "enabled"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_ENABLED = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ENABLED);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.HttpEndpoint");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class HTTPEndpointCfgServerImpl
    implements HTTPEndpointCfg {
        private ServerManagedObject<? extends HTTPEndpointCfg> impl;
        private final SortedSet<String> pAuthorizationMechanism;
        private final String pBasePath;
        private final boolean pEnabled;
        private final String pJavaClass;

        private HTTPEndpointCfgServerImpl(ServerManagedObject<? extends HTTPEndpointCfg> impl) {
            this.impl = impl;
            this.pAuthorizationMechanism = impl.getPropertyValues(INSTANCE.getAuthorizationMechanismPropertyDefinition());
            this.pBasePath = impl.getPropertyValue(INSTANCE.getBasePathPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<HTTPEndpointCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<HTTPEndpointCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<String> getAuthorizationMechanism() {
            return this.pAuthorizationMechanism;
        }

        @Override
        public SortedSet<DN> getAuthorizationMechanismDNs() {
            SortedSet<String> values = this.getAuthorizationMechanism();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getAuthorizationMechanismPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public String getBasePath() {
            return this.pBasePath;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Class<? extends HTTPEndpointCfg> configurationClass() {
            return HTTPEndpointCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class HTTPEndpointCfgClientImpl
    implements HTTPEndpointCfgClient {
        private ManagedObject<? extends HTTPEndpointCfgClient> impl;

        private HTTPEndpointCfgClientImpl(ManagedObject<? extends HTTPEndpointCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<String> getAuthorizationMechanism() {
            return this.impl.getPropertyValues(INSTANCE.getAuthorizationMechanismPropertyDefinition());
        }

        @Override
        public void setAuthorizationMechanism(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getAuthorizationMechanismPropertyDefinition(), values);
        }

        @Override
        public String getBasePath() {
            return this.impl.getPropertyValue(INSTANCE.getBasePathPropertyDefinition());
        }

        @Override
        public void setBasePath(String value) throws PropertyException {
            this.impl.setPropertyValue(INSTANCE.getBasePathPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends HTTPEndpointCfgClient, ? extends HTTPEndpointCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

