/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AttributeTypePropertyDefinition;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.conditions.Conditions;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.server.config.client.CertificateMapperCfgClient;
import org.forgerock.opendj.server.config.client.ExternalSASLMechanismHandlerCfgClient;
import org.forgerock.opendj.server.config.meta.SASLMechanismHandlerCfgDefn;
import org.forgerock.opendj.server.config.server.CertificateMapperCfg;
import org.forgerock.opendj.server.config.server.ExternalSASLMechanismHandlerCfg;
import org.forgerock.opendj.server.config.server.SASLMechanismHandlerCfg;

public final class ExternalSASLMechanismHandlerCfgDefn
extends ManagedObjectDefinition<ExternalSASLMechanismHandlerCfgClient, ExternalSASLMechanismHandlerCfg> {
    private static final ExternalSASLMechanismHandlerCfgDefn INSTANCE = new ExternalSASLMechanismHandlerCfgDefn();
    private static final AttributeTypePropertyDefinition PD_CERTIFICATE_ATTRIBUTE;
    private static final AggregationPropertyDefinition<CertificateMapperCfgClient, CertificateMapperCfg> PD_CERTIFICATE_MAPPER;
    private static final EnumPropertyDefinition<CertificateValidationPolicy> PD_CERTIFICATE_VALIDATION_POLICY;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static ExternalSASLMechanismHandlerCfgDefn getInstance() {
        return INSTANCE;
    }

    private ExternalSASLMechanismHandlerCfgDefn() {
        super("external-sasl-mechanism-handler", SASLMechanismHandlerCfgDefn.getInstance());
    }

    @Override
    public ExternalSASLMechanismHandlerCfgClient createClientConfiguration(ManagedObject<? extends ExternalSASLMechanismHandlerCfgClient> impl) {
        return new ExternalSASLMechanismHandlerCfgClientImpl(impl);
    }

    @Override
    public ExternalSASLMechanismHandlerCfg createServerConfiguration(ServerManagedObject<? extends ExternalSASLMechanismHandlerCfg> impl) {
        return new ExternalSASLMechanismHandlerCfgServerImpl(impl);
    }

    @Override
    public Class<ExternalSASLMechanismHandlerCfg> getServerConfigurationClass() {
        return ExternalSASLMechanismHandlerCfg.class;
    }

    public AttributeTypePropertyDefinition getCertificateAttributePropertyDefinition() {
        return PD_CERTIFICATE_ATTRIBUTE;
    }

    public AggregationPropertyDefinition<CertificateMapperCfgClient, CertificateMapperCfg> getCertificateMapperPropertyDefinition() {
        return PD_CERTIFICATE_MAPPER;
    }

    public EnumPropertyDefinition<CertificateValidationPolicy> getCertificateValidationPolicyPropertyDefinition() {
        return PD_CERTIFICATE_VALIDATION_POLICY;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return SASLMechanismHandlerCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = AttributeTypePropertyDefinition.createBuilder(INSTANCE, "certificate-attribute");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "certificate-attribute"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("userCertificate");
        builder.setDefaultBehaviorProvider(provider);
        PD_CERTIFICATE_ATTRIBUTE = (AttributeTypePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CERTIFICATE_ATTRIBUTE);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "certificate-mapper");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "certificate-mapper"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("certificate-mapper");
        ((AggregationPropertyDefinition.Builder)builder).setTargetNeedsEnablingCondition(Conditions.contains("enabled", "true"));
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_CERTIFICATE_MAPPER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CERTIFICATE_MAPPER);
        INSTANCE.registerConstraint(PD_CERTIFICATE_MAPPER.getSourceConstraint());
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "certificate-validation-policy");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "certificate-validation-policy"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(CertificateValidationPolicy.class);
        PD_CERTIFICATE_VALIDATION_POLICY = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CERTIFICATE_VALIDATION_POLICY);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.ExternalSASLMechanismHandler");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.SASLMechanismHandler");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerTag(Tag.valueOf("security"));
    }

    private static class ExternalSASLMechanismHandlerCfgServerImpl
    implements ExternalSASLMechanismHandlerCfg {
        private ServerManagedObject<? extends ExternalSASLMechanismHandlerCfg> impl;
        private final AttributeType pCertificateAttribute;
        private final String pCertificateMapper;
        private final CertificateValidationPolicy pCertificateValidationPolicy;
        private final boolean pEnabled;
        private final String pJavaClass;

        private ExternalSASLMechanismHandlerCfgServerImpl(ServerManagedObject<? extends ExternalSASLMechanismHandlerCfg> impl) {
            this.impl = impl;
            this.pCertificateAttribute = impl.getPropertyValue(INSTANCE.getCertificateAttributePropertyDefinition());
            this.pCertificateMapper = impl.getPropertyValue(INSTANCE.getCertificateMapperPropertyDefinition());
            this.pCertificateValidationPolicy = impl.getPropertyValue(INSTANCE.getCertificateValidationPolicyPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void addExternalChangeListener(ConfigurationChangeListener<ExternalSASLMechanismHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeExternalChangeListener(ConfigurationChangeListener<ExternalSASLMechanismHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<SASLMechanismHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<SASLMechanismHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public AttributeType getCertificateAttribute() {
            return this.pCertificateAttribute;
        }

        @Override
        public String getCertificateMapper() {
            return this.pCertificateMapper;
        }

        @Override
        public DN getCertificateMapperDN() {
            String value = this.getCertificateMapper();
            if (value == null) {
                return null;
            }
            return INSTANCE.getCertificateMapperPropertyDefinition().getChildDN(value);
        }

        @Override
        public CertificateValidationPolicy getCertificateValidationPolicy() {
            return this.pCertificateValidationPolicy;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Class<? extends ExternalSASLMechanismHandlerCfg> configurationClass() {
            return ExternalSASLMechanismHandlerCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class ExternalSASLMechanismHandlerCfgClientImpl
    implements ExternalSASLMechanismHandlerCfgClient {
        private ManagedObject<? extends ExternalSASLMechanismHandlerCfgClient> impl;

        private ExternalSASLMechanismHandlerCfgClientImpl(ManagedObject<? extends ExternalSASLMechanismHandlerCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public AttributeType getCertificateAttribute() {
            return this.impl.getPropertyValue(INSTANCE.getCertificateAttributePropertyDefinition());
        }

        @Override
        public void setCertificateAttribute(AttributeType value) {
            this.impl.setPropertyValue(INSTANCE.getCertificateAttributePropertyDefinition(), value);
        }

        @Override
        public String getCertificateMapper() {
            return this.impl.getPropertyValue(INSTANCE.getCertificateMapperPropertyDefinition());
        }

        @Override
        public void setCertificateMapper(String value) {
            this.impl.setPropertyValue(INSTANCE.getCertificateMapperPropertyDefinition(), value);
        }

        @Override
        public CertificateValidationPolicy getCertificateValidationPolicy() {
            return this.impl.getPropertyValue(INSTANCE.getCertificateValidationPolicyPropertyDefinition());
        }

        @Override
        public void setCertificateValidationPolicy(CertificateValidationPolicy value) {
            this.impl.setPropertyValue(INSTANCE.getCertificateValidationPolicyPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends ExternalSASLMechanismHandlerCfgClient, ? extends ExternalSASLMechanismHandlerCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    public static enum CertificateValidationPolicy {
        ALWAYS("always"),
        IFPRESENT("ifpresent"),
        NEVER("never");

        private final String name;

        private CertificateValidationPolicy(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

