/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.DictionaryPasswordValidatorCfgClient;
import org.forgerock.opendj.server.config.meta.PasswordValidatorCfgDefn;
import org.forgerock.opendj.server.config.server.DictionaryPasswordValidatorCfg;
import org.forgerock.opendj.server.config.server.PasswordValidatorCfg;

public final class DictionaryPasswordValidatorCfgDefn
extends ManagedObjectDefinition<DictionaryPasswordValidatorCfgClient, DictionaryPasswordValidatorCfg> {
    private static final DictionaryPasswordValidatorCfgDefn INSTANCE = new DictionaryPasswordValidatorCfgDefn();
    private static final BooleanPropertyDefinition PD_CASE_SENSITIVE_VALIDATION;
    private static final BooleanPropertyDefinition PD_CHECK_SUBSTRINGS;
    private static final StringPropertyDefinition PD_DICTIONARY_FILE;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final IntegerPropertyDefinition PD_MIN_SUBSTRING_LENGTH;
    private static final BooleanPropertyDefinition PD_TEST_REVERSED_PASSWORD;

    public static DictionaryPasswordValidatorCfgDefn getInstance() {
        return INSTANCE;
    }

    private DictionaryPasswordValidatorCfgDefn() {
        super("dictionary-password-validator", PasswordValidatorCfgDefn.getInstance());
    }

    @Override
    public DictionaryPasswordValidatorCfgClient createClientConfiguration(ManagedObject<? extends DictionaryPasswordValidatorCfgClient> impl) {
        return new DictionaryPasswordValidatorCfgClientImpl(impl);
    }

    @Override
    public DictionaryPasswordValidatorCfg createServerConfiguration(ServerManagedObject<? extends DictionaryPasswordValidatorCfg> impl) {
        return new DictionaryPasswordValidatorCfgServerImpl(impl);
    }

    @Override
    public Class<DictionaryPasswordValidatorCfg> getServerConfigurationClass() {
        return DictionaryPasswordValidatorCfg.class;
    }

    public BooleanPropertyDefinition getCaseSensitiveValidationPropertyDefinition() {
        return PD_CASE_SENSITIVE_VALIDATION;
    }

    public BooleanPropertyDefinition getCheckSubstringsPropertyDefinition() {
        return PD_CHECK_SUBSTRINGS;
    }

    public StringPropertyDefinition getDictionaryFilePropertyDefinition() {
        return PD_DICTIONARY_FILE;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PasswordValidatorCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public IntegerPropertyDefinition getMinSubstringLengthPropertyDefinition() {
        return PD_MIN_SUBSTRING_LENGTH;
    }

    public BooleanPropertyDefinition getTestReversedPasswordPropertyDefinition() {
        return PD_TEST_REVERSED_PASSWORD;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "case-sensitive-validation");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "case-sensitive-validation"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_CASE_SENSITIVE_VALIDATION = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CASE_SENSITIVE_VALIDATION);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "check-substrings");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "check-substrings"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_CHECK_SUBSTRINGS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CHECK_SUBSTRINGS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "dictionary-file");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "dictionary-file"));
        provider = new DefinedDefaultBehaviorProvider("For Unix and Linux systems: config/wordlist.txt. For Windows systems: config\\wordlist.txt");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "FILE");
        PD_DICTIONARY_FILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DICTIONARY_FILE);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.DictionaryPasswordValidator");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.PasswordValidator");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "min-substring-length");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "min-substring-length"));
        provider = new DefinedDefaultBehaviorProvider("5");
        builder.setDefaultBehaviorProvider(provider);
        PD_MIN_SUBSTRING_LENGTH = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MIN_SUBSTRING_LENGTH);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "test-reversed-password");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "test-reversed-password"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_TEST_REVERSED_PASSWORD = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TEST_REVERSED_PASSWORD);
        INSTANCE.registerTag(Tag.valueOf("user-management"));
    }

    private static class DictionaryPasswordValidatorCfgServerImpl
    implements DictionaryPasswordValidatorCfg {
        private ServerManagedObject<? extends DictionaryPasswordValidatorCfg> impl;
        private final boolean pCaseSensitiveValidation;
        private final boolean pCheckSubstrings;
        private final String pDictionaryFile;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final int pMinSubstringLength;
        private final boolean pTestReversedPassword;

        private DictionaryPasswordValidatorCfgServerImpl(ServerManagedObject<? extends DictionaryPasswordValidatorCfg> impl) {
            this.impl = impl;
            this.pCaseSensitiveValidation = impl.getPropertyValue(INSTANCE.getCaseSensitiveValidationPropertyDefinition());
            this.pCheckSubstrings = impl.getPropertyValue(INSTANCE.getCheckSubstringsPropertyDefinition());
            this.pDictionaryFile = impl.getPropertyValue(INSTANCE.getDictionaryFilePropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pMinSubstringLength = impl.getPropertyValue(INSTANCE.getMinSubstringLengthPropertyDefinition());
            this.pTestReversedPassword = impl.getPropertyValue(INSTANCE.getTestReversedPasswordPropertyDefinition());
        }

        @Override
        public void addDictionaryChangeListener(ConfigurationChangeListener<DictionaryPasswordValidatorCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeDictionaryChangeListener(ConfigurationChangeListener<DictionaryPasswordValidatorCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<PasswordValidatorCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<PasswordValidatorCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isCaseSensitiveValidation() {
            return this.pCaseSensitiveValidation;
        }

        @Override
        public boolean isCheckSubstrings() {
            return this.pCheckSubstrings;
        }

        @Override
        public String getDictionaryFile() {
            return this.pDictionaryFile;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public int getMinSubstringLength() {
            return this.pMinSubstringLength;
        }

        @Override
        public boolean isTestReversedPassword() {
            return this.pTestReversedPassword;
        }

        @Override
        public Class<? extends DictionaryPasswordValidatorCfg> configurationClass() {
            return DictionaryPasswordValidatorCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class DictionaryPasswordValidatorCfgClientImpl
    implements DictionaryPasswordValidatorCfgClient {
        private ManagedObject<? extends DictionaryPasswordValidatorCfgClient> impl;

        private DictionaryPasswordValidatorCfgClientImpl(ManagedObject<? extends DictionaryPasswordValidatorCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public boolean isCaseSensitiveValidation() {
            return this.impl.getPropertyValue(INSTANCE.getCaseSensitiveValidationPropertyDefinition());
        }

        @Override
        public void setCaseSensitiveValidation(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getCaseSensitiveValidationPropertyDefinition(), value);
        }

        @Override
        public boolean isCheckSubstrings() {
            return this.impl.getPropertyValue(INSTANCE.getCheckSubstringsPropertyDefinition());
        }

        @Override
        public void setCheckSubstrings(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getCheckSubstringsPropertyDefinition(), value);
        }

        @Override
        public String getDictionaryFile() {
            return this.impl.getPropertyValue(INSTANCE.getDictionaryFilePropertyDefinition());
        }

        @Override
        public void setDictionaryFile(String value) {
            this.impl.setPropertyValue(INSTANCE.getDictionaryFilePropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public int getMinSubstringLength() {
            return this.impl.getPropertyValue(INSTANCE.getMinSubstringLengthPropertyDefinition());
        }

        @Override
        public void setMinSubstringLength(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getMinSubstringLengthPropertyDefinition(), value);
        }

        @Override
        public boolean isTestReversedPassword() {
            return this.impl.getPropertyValue(INSTANCE.getTestReversedPasswordPropertyDefinition());
        }

        @Override
        public void setTestReversedPassword(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getTestReversedPasswordPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends DictionaryPasswordValidatorCfgClient, ? extends DictionaryPasswordValidatorCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

