/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.CoreSchemaCfgClient;
import org.forgerock.opendj.server.config.meta.SchemaProviderCfgDefn;
import org.forgerock.opendj.server.config.server.CoreSchemaCfg;
import org.forgerock.opendj.server.config.server.SchemaProviderCfg;

public final class CoreSchemaCfgDefn
extends ManagedObjectDefinition<CoreSchemaCfgClient, CoreSchemaCfg> {
    private static final CoreSchemaCfgDefn INSTANCE = new CoreSchemaCfgDefn();
    private static final BooleanPropertyDefinition PD_ALLOW_ATTRIBUTE_TYPES_WITH_NO_SUP_OR_SYNTAX;
    private static final BooleanPropertyDefinition PD_ALLOW_ZERO_LENGTH_VALUES_DIRECTORY_STRING;
    private static final StringPropertyDefinition PD_DISABLED_MATCHING_RULE;
    private static final StringPropertyDefinition PD_DISABLED_SYNTAX;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final EnumPropertyDefinition<JsonValidationPolicy> PD_JSON_VALIDATION_POLICY;
    private static final BooleanPropertyDefinition PD_STRICT_FORMAT_CERTIFICATES;
    private static final BooleanPropertyDefinition PD_STRICT_FORMAT_COUNTRY_STRING;
    private static final BooleanPropertyDefinition PD_STRICT_FORMAT_JPEG_PHOTOS;
    private static final BooleanPropertyDefinition PD_STRICT_FORMAT_TELEPHONE_NUMBERS;
    private static final BooleanPropertyDefinition PD_STRIP_SYNTAX_MIN_UPPER_BOUND_ATTRIBUTE_TYPE_DESCRIPTION;

    public static CoreSchemaCfgDefn getInstance() {
        return INSTANCE;
    }

    private CoreSchemaCfgDefn() {
        super("core-schema", SchemaProviderCfgDefn.getInstance());
    }

    @Override
    public CoreSchemaCfgClient createClientConfiguration(ManagedObject<? extends CoreSchemaCfgClient> impl) {
        return new CoreSchemaCfgClientImpl(impl);
    }

    @Override
    public CoreSchemaCfg createServerConfiguration(ServerManagedObject<? extends CoreSchemaCfg> impl) {
        return new CoreSchemaCfgServerImpl(impl);
    }

    @Override
    public Class<CoreSchemaCfg> getServerConfigurationClass() {
        return CoreSchemaCfg.class;
    }

    public BooleanPropertyDefinition getAllowAttributeTypesWithNoSupOrSyntaxPropertyDefinition() {
        return PD_ALLOW_ATTRIBUTE_TYPES_WITH_NO_SUP_OR_SYNTAX;
    }

    public BooleanPropertyDefinition getAllowZeroLengthValuesDirectoryStringPropertyDefinition() {
        return PD_ALLOW_ZERO_LENGTH_VALUES_DIRECTORY_STRING;
    }

    public StringPropertyDefinition getDisabledMatchingRulePropertyDefinition() {
        return PD_DISABLED_MATCHING_RULE;
    }

    public StringPropertyDefinition getDisabledSyntaxPropertyDefinition() {
        return PD_DISABLED_SYNTAX;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return SchemaProviderCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public EnumPropertyDefinition<JsonValidationPolicy> getJsonValidationPolicyPropertyDefinition() {
        return PD_JSON_VALIDATION_POLICY;
    }

    public BooleanPropertyDefinition getStrictFormatCertificatesPropertyDefinition() {
        return PD_STRICT_FORMAT_CERTIFICATES;
    }

    public BooleanPropertyDefinition getStrictFormatCountryStringPropertyDefinition() {
        return PD_STRICT_FORMAT_COUNTRY_STRING;
    }

    public BooleanPropertyDefinition getStrictFormatJPEGPhotosPropertyDefinition() {
        return PD_STRICT_FORMAT_JPEG_PHOTOS;
    }

    public BooleanPropertyDefinition getStrictFormatTelephoneNumbersPropertyDefinition() {
        return PD_STRICT_FORMAT_TELEPHONE_NUMBERS;
    }

    public BooleanPropertyDefinition getStripSyntaxMinUpperBoundAttributeTypeDescriptionPropertyDefinition() {
        return PD_STRIP_SYNTAX_MIN_UPPER_BOUND_ATTRIBUTE_TYPE_DESCRIPTION;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "allow-attribute-types-with-no-sup-or-syntax");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allow-attribute-types-with-no-sup-or-syntax"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_ALLOW_ATTRIBUTE_TYPES_WITH_NO_SUP_OR_SYNTAX = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOW_ATTRIBUTE_TYPES_WITH_NO_SUP_OR_SYNTAX);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "allow-zero-length-values-directory-string");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allow-zero-length-values-directory-string"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_ALLOW_ZERO_LENGTH_VALUES_DIRECTORY_STRING = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOW_ZERO_LENGTH_VALUES_DIRECTORY_STRING);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "disabled-matching-rule");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "disabled-matching-rule"));
        provider = new DefinedDefaultBehaviorProvider("NONE");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern("^([0-9.]+\\d|NONE)$", "OID");
        PD_DISABLED_MATCHING_RULE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DISABLED_MATCHING_RULE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "disabled-syntax");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "disabled-syntax"));
        provider = new DefinedDefaultBehaviorProvider("NONE");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern("^([0-9.]+\\d|NONE)$", "OID");
        PD_DISABLED_SYNTAX = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DISABLED_SYNTAX);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.schema.CoreSchemaProvider");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.schema.SchemaProvider");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "json-validation-policy");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "json-validation-policy"));
        provider = new DefinedDefaultBehaviorProvider("strict");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(JsonValidationPolicy.class);
        PD_JSON_VALIDATION_POLICY = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JSON_VALIDATION_POLICY);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "strict-format-certificates");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "strict-format-certificates"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_STRICT_FORMAT_CERTIFICATES = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_STRICT_FORMAT_CERTIFICATES);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "strict-format-country-string");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "strict-format-country-string"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_STRICT_FORMAT_COUNTRY_STRING = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_STRICT_FORMAT_COUNTRY_STRING);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "strict-format-jpeg-photos");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "strict-format-jpeg-photos"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_STRICT_FORMAT_JPEG_PHOTOS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_STRICT_FORMAT_JPEG_PHOTOS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "strict-format-telephone-numbers");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "strict-format-telephone-numbers"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_STRICT_FORMAT_TELEPHONE_NUMBERS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_STRICT_FORMAT_TELEPHONE_NUMBERS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "strip-syntax-min-upper-bound-attribute-type-description");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "strip-syntax-min-upper-bound-attribute-type-description"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_STRIP_SYNTAX_MIN_UPPER_BOUND_ATTRIBUTE_TYPE_DESCRIPTION = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_STRIP_SYNTAX_MIN_UPPER_BOUND_ATTRIBUTE_TYPE_DESCRIPTION);
    }

    private static class CoreSchemaCfgServerImpl
    implements CoreSchemaCfg {
        private ServerManagedObject<? extends CoreSchemaCfg> impl;
        private final boolean pAllowAttributeTypesWithNoSupOrSyntax;
        private final boolean pAllowZeroLengthValuesDirectoryString;
        private final SortedSet<String> pDisabledMatchingRule;
        private final SortedSet<String> pDisabledSyntax;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final JsonValidationPolicy pJsonValidationPolicy;
        private final boolean pStrictFormatCertificates;
        private final boolean pStrictFormatCountryString;
        private final boolean pStrictFormatJPEGPhotos;
        private final boolean pStrictFormatTelephoneNumbers;
        private final boolean pStripSyntaxMinUpperBoundAttributeTypeDescription;

        private CoreSchemaCfgServerImpl(ServerManagedObject<? extends CoreSchemaCfg> impl) {
            this.impl = impl;
            this.pAllowAttributeTypesWithNoSupOrSyntax = impl.getPropertyValue(INSTANCE.getAllowAttributeTypesWithNoSupOrSyntaxPropertyDefinition());
            this.pAllowZeroLengthValuesDirectoryString = impl.getPropertyValue(INSTANCE.getAllowZeroLengthValuesDirectoryStringPropertyDefinition());
            this.pDisabledMatchingRule = impl.getPropertyValues((PropertyDefinition)INSTANCE.getDisabledMatchingRulePropertyDefinition());
            this.pDisabledSyntax = impl.getPropertyValues((PropertyDefinition)INSTANCE.getDisabledSyntaxPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pJsonValidationPolicy = impl.getPropertyValue(INSTANCE.getJsonValidationPolicyPropertyDefinition());
            this.pStrictFormatCertificates = impl.getPropertyValue(INSTANCE.getStrictFormatCertificatesPropertyDefinition());
            this.pStrictFormatCountryString = impl.getPropertyValue(INSTANCE.getStrictFormatCountryStringPropertyDefinition());
            this.pStrictFormatJPEGPhotos = impl.getPropertyValue(INSTANCE.getStrictFormatJPEGPhotosPropertyDefinition());
            this.pStrictFormatTelephoneNumbers = impl.getPropertyValue(INSTANCE.getStrictFormatTelephoneNumbersPropertyDefinition());
            this.pStripSyntaxMinUpperBoundAttributeTypeDescription = impl.getPropertyValue(INSTANCE.getStripSyntaxMinUpperBoundAttributeTypeDescriptionPropertyDefinition());
        }

        @Override
        public void addCoreSchemaChangeListener(ConfigurationChangeListener<CoreSchemaCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeCoreSchemaChangeListener(ConfigurationChangeListener<CoreSchemaCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<SchemaProviderCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<SchemaProviderCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isAllowAttributeTypesWithNoSupOrSyntax() {
            return this.pAllowAttributeTypesWithNoSupOrSyntax;
        }

        @Override
        public boolean isAllowZeroLengthValuesDirectoryString() {
            return this.pAllowZeroLengthValuesDirectoryString;
        }

        @Override
        public SortedSet<String> getDisabledMatchingRule() {
            return this.pDisabledMatchingRule;
        }

        @Override
        public SortedSet<String> getDisabledSyntax() {
            return this.pDisabledSyntax;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public JsonValidationPolicy getJsonValidationPolicy() {
            return this.pJsonValidationPolicy;
        }

        @Override
        public boolean isStrictFormatCertificates() {
            return this.pStrictFormatCertificates;
        }

        @Override
        public boolean isStrictFormatCountryString() {
            return this.pStrictFormatCountryString;
        }

        @Override
        public boolean isStrictFormatJPEGPhotos() {
            return this.pStrictFormatJPEGPhotos;
        }

        @Override
        public boolean isStrictFormatTelephoneNumbers() {
            return this.pStrictFormatTelephoneNumbers;
        }

        @Override
        public boolean isStripSyntaxMinUpperBoundAttributeTypeDescription() {
            return this.pStripSyntaxMinUpperBoundAttributeTypeDescription;
        }

        @Override
        public Class<? extends CoreSchemaCfg> configurationClass() {
            return CoreSchemaCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class CoreSchemaCfgClientImpl
    implements CoreSchemaCfgClient {
        private ManagedObject<? extends CoreSchemaCfgClient> impl;

        private CoreSchemaCfgClientImpl(ManagedObject<? extends CoreSchemaCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public boolean isAllowAttributeTypesWithNoSupOrSyntax() {
            return this.impl.getPropertyValue(INSTANCE.getAllowAttributeTypesWithNoSupOrSyntaxPropertyDefinition());
        }

        @Override
        public void setAllowAttributeTypesWithNoSupOrSyntax(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAllowAttributeTypesWithNoSupOrSyntaxPropertyDefinition(), value);
        }

        @Override
        public boolean isAllowZeroLengthValuesDirectoryString() {
            return this.impl.getPropertyValue(INSTANCE.getAllowZeroLengthValuesDirectoryStringPropertyDefinition());
        }

        @Override
        public void setAllowZeroLengthValuesDirectoryString(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAllowZeroLengthValuesDirectoryStringPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getDisabledMatchingRule() {
            return this.impl.getPropertyValues(INSTANCE.getDisabledMatchingRulePropertyDefinition());
        }

        @Override
        public void setDisabledMatchingRule(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getDisabledMatchingRulePropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getDisabledSyntax() {
            return this.impl.getPropertyValues(INSTANCE.getDisabledSyntaxPropertyDefinition());
        }

        @Override
        public void setDisabledSyntax(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getDisabledSyntaxPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public JsonValidationPolicy getJsonValidationPolicy() {
            return this.impl.getPropertyValue(INSTANCE.getJsonValidationPolicyPropertyDefinition());
        }

        @Override
        public void setJsonValidationPolicy(JsonValidationPolicy value) {
            this.impl.setPropertyValue(INSTANCE.getJsonValidationPolicyPropertyDefinition(), value);
        }

        @Override
        public boolean isStrictFormatCertificates() {
            return this.impl.getPropertyValue(INSTANCE.getStrictFormatCertificatesPropertyDefinition());
        }

        @Override
        public void setStrictFormatCertificates(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getStrictFormatCertificatesPropertyDefinition(), value);
        }

        @Override
        public boolean isStrictFormatCountryString() {
            return this.impl.getPropertyValue(INSTANCE.getStrictFormatCountryStringPropertyDefinition());
        }

        @Override
        public void setStrictFormatCountryString(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getStrictFormatCountryStringPropertyDefinition(), value);
        }

        @Override
        public boolean isStrictFormatJPEGPhotos() {
            return this.impl.getPropertyValue(INSTANCE.getStrictFormatJPEGPhotosPropertyDefinition());
        }

        @Override
        public void setStrictFormatJPEGPhotos(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getStrictFormatJPEGPhotosPropertyDefinition(), value);
        }

        @Override
        public boolean isStrictFormatTelephoneNumbers() {
            return this.impl.getPropertyValue(INSTANCE.getStrictFormatTelephoneNumbersPropertyDefinition());
        }

        @Override
        public void setStrictFormatTelephoneNumbers(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getStrictFormatTelephoneNumbersPropertyDefinition(), value);
        }

        @Override
        public boolean isStripSyntaxMinUpperBoundAttributeTypeDescription() {
            return this.impl.getPropertyValue(INSTANCE.getStripSyntaxMinUpperBoundAttributeTypeDescriptionPropertyDefinition());
        }

        @Override
        public void setStripSyntaxMinUpperBoundAttributeTypeDescription(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getStripSyntaxMinUpperBoundAttributeTypeDescriptionPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends CoreSchemaCfgClient, ? extends CoreSchemaCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    public static enum JsonValidationPolicy {
        DISABLED("disabled"),
        LENIENT("lenient"),
        STRICT("strict");

        private final String name;

        private JsonValidationPolicy(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

