/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.client.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.Constraint;
import org.forgerock.opendj.config.DefaultManagedObject;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.OptionalRelationDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.RelationDefinitionVisitor;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.SingletonRelationDefinition;
import org.forgerock.opendj.config.client.ClientConstraintHandler;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.IllegalManagedObjectNameException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.client.spi.Driver;
import org.forgerock.opendj.config.client.spi.Property;
import org.forgerock.opendj.config.client.spi.PropertySet;
import org.forgerock.opendj.ldap.LdapException;

public abstract class AbstractManagedObject<T extends ConfigurationClient>
implements ManagedObject<T> {
    private final ManagedObjectDefinition<T, ? extends Configuration> definition;
    private boolean existsOnServer;
    private final PropertyDefinition<?> namingPropertyDefinition;
    private ManagedObjectPath<T, ? extends Configuration> path;
    private final PropertySet properties;

    protected AbstractManagedObject(ManagedObjectDefinition<T, ? extends Configuration> d, ManagedObjectPath<T, ? extends Configuration> path, PropertySet properties, boolean existsOnServer, PropertyDefinition<?> namingPropertyDefinition) {
        this.definition = d;
        this.path = path;
        this.properties = properties;
        this.existsOnServer = existsOnServer;
        this.namingPropertyDefinition = namingPropertyDefinition;
    }

    @Override
    public final void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
        LinkedList<PropertyException> exceptions = new LinkedList<PropertyException>();
        for (PropertyDefinition<?> pd : this.definition.getAllPropertyDefinitions()) {
            Property<?> p = this.getProperty(pd);
            if (!pd.hasOption(PropertyOption.MANDATORY) || !p.getEffectiveValues().isEmpty()) continue;
            exceptions.add(PropertyException.propertyIsMandatoryException(pd));
        }
        if (!exceptions.isEmpty()) {
            throw new MissingMandatoryPropertiesException(this.definition.getUserFriendlyName(), exceptions, !this.existsOnServer);
        }
        LinkedList<LocalizableMessage> messages = new LinkedList<LocalizableMessage>();
        boolean isAcceptable = true;
        ManagementContext context = this.getDriver().getManagementContext();
        for (Constraint constraint : this.definition.getAllConstraints()) {
            for (ClientConstraintHandler handler : constraint.getClientConstraintHandlers()) {
                if (this.existsOnServer) {
                    if (handler.isModifyAcceptable(context, this, messages)) continue;
                    isAcceptable = false;
                    continue;
                }
                if (handler.isAddAcceptable(context, this, messages)) continue;
                isAcceptable = false;
            }
            if (isAcceptable) continue;
            break;
        }
        if (!isAcceptable) {
            if (this.existsOnServer) {
                throw new OperationRejectedException(OperationRejectedException.OperationType.MODIFY, this.definition.getUserFriendlyName(), messages);
            }
            throw new OperationRejectedException(OperationRejectedException.OperationType.CREATE, this.definition.getUserFriendlyName(), messages);
        }
        if (this.existsOnServer) {
            this.modifyExistingManagedObject();
        } else {
            this.addNewManagedObject();
        }
        this.properties.commit();
        if (!this.existsOnServer) {
            DefaultManagedObjectFactory factory = new DefaultManagedObjectFactory();
            for (RelationDefinition<?, ?> rd : this.definition.getAllRelationDefinitions()) {
                factory.createDefaultManagedObjects(rd);
            }
            this.existsOnServer = true;
        }
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration, C1 extends C> ManagedObject<C1> createChild(InstantiableRelationDefinition<C, S> r, ManagedObjectDefinition<C1, ? extends S> d, String name, Collection<PropertyException> exceptions) throws IllegalManagedObjectNameException {
        this.validateRelationDefinition(r);
        if (name.trim().length() == 0) {
            throw new IllegalManagedObjectNameException(name);
        }
        PropertyDefinition<?> pd = r.getNamingPropertyDefinition();
        if (pd != null) {
            try {
                pd.decodeValue(name);
            }
            catch (PropertyException e) {
                throw new IllegalManagedObjectNameException(name, pd);
            }
        }
        ManagedObjectPath<C, ? extends S> childPath = this.path.child(r, d, name);
        return this.createNewManagedObject(d, childPath, pd, name, exceptions);
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration, C1 extends C> ManagedObject<C1> createChild(OptionalRelationDefinition<C, S> r, ManagedObjectDefinition<C1, ? extends S> d, Collection<PropertyException> exceptions) {
        this.validateRelationDefinition(r);
        ManagedObjectPath<C, ? extends S> childPath = this.path.child(r, d);
        return this.createNewManagedObject(d, childPath, null, null, exceptions);
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration, C1 extends C> ManagedObject<C1> createChild(SetRelationDefinition<C, S> r, ManagedObjectDefinition<C1, ? extends S> d, Collection<PropertyException> exceptions) {
        this.validateRelationDefinition(r);
        ManagedObjectPath<C, ? extends S> childPath = this.path.child(r, d);
        return this.createNewManagedObject(d, childPath, null, null, exceptions);
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getChild(InstantiableRelationDefinition<C, S> r, String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, LdapException {
        this.validateRelationDefinition(r);
        this.ensureThisManagedObjectExists();
        Driver ctx = this.getDriver();
        return ctx.getManagedObject(this.path.child(r, name));
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getChild(OptionalRelationDefinition<C, S> r) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, LdapException {
        this.validateRelationDefinition(r);
        this.ensureThisManagedObjectExists();
        Driver ctx = this.getDriver();
        return ctx.getManagedObject(this.path.child(r));
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getChild(SingletonRelationDefinition<C, S> r) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, LdapException {
        this.validateRelationDefinition(r);
        this.ensureThisManagedObjectExists();
        Driver ctx = this.getDriver();
        return ctx.getManagedObject(this.path.child(r));
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getChild(SetRelationDefinition<C, S> r, String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, LdapException {
        AbstractManagedObjectDefinition cd;
        this.validateRelationDefinition(r);
        this.ensureThisManagedObjectExists();
        Driver ctx = this.getDriver();
        AbstractManagedObjectDefinition d = r.getChildDefinition();
        try {
            cd = d.getChild(name);
        }
        catch (IllegalArgumentException e) {
            throw new DefinitionDecodingException(d, DefinitionDecodingException.Reason.WRONG_TYPE_INFORMATION);
        }
        return ctx.getManagedObject(this.path.child(r, cd));
    }

    @Override
    public final T getConfiguration() {
        return this.definition.createClientConfiguration(this);
    }

    @Override
    public final ManagedObjectDefinition<T, ? extends Configuration> getManagedObjectDefinition() {
        return this.definition;
    }

    @Override
    public final ManagedObjectPath<T, ? extends Configuration> getManagedObjectPath() {
        return this.path;
    }

    @Override
    public final <P> SortedSet<P> getPropertyDefaultValues(PropertyDefinition<P> pd) {
        return new TreeSet<P>(this.getProperty(pd).getDefaultValues());
    }

    @Override
    public final <P> P getPropertyValue(PropertyDefinition<P> pd) {
        SortedSet<P> values = this.getProperty(pd).getEffectiveValues();
        if (!values.isEmpty()) {
            return (P)values.iterator().next();
        }
        return null;
    }

    @Override
    public final <P> SortedSet<P> getPropertyValues(PropertyDefinition<P> pd) {
        return new TreeSet<P>(this.getProperty(pd).getEffectiveValues());
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> boolean hasChild(OptionalRelationDefinition<C, S> r) throws ConcurrentModificationException, LdapException {
        this.validateRelationDefinition(r);
        Driver ctx = this.getDriver();
        try {
            return ctx.managedObjectExists(this.path.child(r));
        }
        catch (ManagedObjectNotFoundException e) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public final boolean isPropertyPresent(PropertyDefinition<?> pd) {
        return !this.getProperty(pd).isEmpty();
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> String[] listChildren(InstantiableRelationDefinition<C, S> r) throws ConcurrentModificationException, LdapException {
        return this.listChildren(r, r.getChildDefinition());
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> String[] listChildren(InstantiableRelationDefinition<C, S> r, AbstractManagedObjectDefinition<? extends C, ? extends S> d) throws ConcurrentModificationException, LdapException {
        this.validateRelationDefinition(r);
        Driver ctx = this.getDriver();
        try {
            return ctx.listManagedObjects(this.path, r, d);
        }
        catch (ManagedObjectNotFoundException e) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> String[] listChildren(SetRelationDefinition<C, S> r) throws ConcurrentModificationException, LdapException {
        return this.listChildren(r, r.getChildDefinition());
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> String[] listChildren(SetRelationDefinition<C, S> r, AbstractManagedObjectDefinition<? extends C, ? extends S> d) throws ConcurrentModificationException, LdapException {
        this.validateRelationDefinition(r);
        Driver ctx = this.getDriver();
        try {
            return ctx.listManagedObjects(this.path, r, d);
        }
        catch (ManagedObjectNotFoundException e) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> void removeChild(InstantiableRelationDefinition<C, S> r, String name) throws ManagedObjectNotFoundException, OperationRejectedException, ConcurrentModificationException, LdapException {
        boolean found;
        this.validateRelationDefinition(r);
        Driver ctx = this.getDriver();
        try {
            found = ctx.deleteManagedObject(this.path, r, name);
        }
        catch (ManagedObjectNotFoundException e) {
            throw new ConcurrentModificationException();
        }
        if (!found) {
            throw new ManagedObjectNotFoundException();
        }
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> void removeChild(OptionalRelationDefinition<C, S> r) throws ManagedObjectNotFoundException, OperationRejectedException, ConcurrentModificationException, LdapException {
        boolean found;
        this.validateRelationDefinition(r);
        Driver ctx = this.getDriver();
        try {
            found = ctx.deleteManagedObject(this.path, r);
        }
        catch (ManagedObjectNotFoundException e) {
            throw new ConcurrentModificationException();
        }
        if (!found) {
            throw new ManagedObjectNotFoundException();
        }
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> void removeChild(SetRelationDefinition<C, S> r, String name) throws ManagedObjectNotFoundException, OperationRejectedException, ConcurrentModificationException, LdapException {
        boolean found;
        this.validateRelationDefinition(r);
        Driver ctx = this.getDriver();
        try {
            found = ctx.deleteManagedObject(this.path, r, name);
        }
        catch (ManagedObjectNotFoundException e) {
            throw new ConcurrentModificationException();
        }
        if (!found) {
            throw new ManagedObjectNotFoundException();
        }
    }

    @Override
    public final <P> void setPropertyValue(PropertyDefinition<P> pd, P value) {
        if (value != null) {
            this.setPropertyValues(pd, Collections.singleton(value));
        } else {
            this.setPropertyValues(pd, Collections.emptySet());
        }
    }

    @Override
    public final <P> void setPropertyValues(PropertyDefinition<P> pd, Collection<P> values) {
        if (pd.hasOption(PropertyOption.MONITORING)) {
            throw PropertyException.propertyIsReadOnlyException(pd);
        }
        if (this.existsOnServer && pd.hasOption(PropertyOption.READ_ONLY)) {
            throw PropertyException.propertyIsReadOnlyException(pd);
        }
        this.properties.setPropertyValues(pd, values);
        if (pd.equals(this.namingPropertyDefinition)) {
            String newName = pd.encodeValue(values.iterator().next());
            this.path = this.path.rename(newName);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ TYPE=");
        builder.append(this.definition.getName());
        builder.append(", PATH=\"");
        builder.append(this.path);
        builder.append('\"');
        for (PropertyDefinition<?> pd : this.definition.getAllPropertyDefinitions()) {
            builder.append(", ");
            builder.append(pd.getName());
            builder.append('=');
            builder.append(this.getPropertyValues((PropertyDefinition)pd));
        }
        builder.append(" }");
        return builder.toString();
    }

    protected abstract void addNewManagedObject() throws LdapException, OperationRejectedException, ConcurrentModificationException, ManagedObjectAlreadyExistsException;

    protected abstract Driver getDriver();

    protected final PropertyDefinition<?> getNamingPropertyDefinition() {
        return this.namingPropertyDefinition;
    }

    protected final <P> Property<P> getProperty(PropertyDefinition<P> pd) {
        return this.properties.getProperty(pd);
    }

    protected abstract void modifyExistingManagedObject() throws ConcurrentModificationException, OperationRejectedException, LdapException;

    protected abstract <M extends ConfigurationClient> ManagedObject<M> newInstance(ManagedObjectDefinition<M, ?> var1, ManagedObjectPath<M, ?> var2, PropertySet var3, boolean var4, PropertyDefinition<?> var5);

    private <M extends ConfigurationClient, P> ManagedObject<M> createNewManagedObject(ManagedObjectDefinition<M, ?> d, ManagedObjectPath<M, ?> p, PropertyDefinition<P> namingPropertyDefinition, String name, Collection<PropertyException> exceptions) {
        PropertySet childProperties = new PropertySet();
        for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
            try {
                this.createProperty(childProperties, p, pd);
            }
            catch (PropertyException e) {
                if (exceptions == null) continue;
                exceptions.add(e);
            }
        }
        if (namingPropertyDefinition != null) {
            P value = namingPropertyDefinition.decodeValue(name);
            childProperties.setPropertyValues(namingPropertyDefinition, Collections.singleton(value));
        }
        return this.newInstance(d, p, childProperties, false, namingPropertyDefinition);
    }

    private <P> void createProperty(PropertySet properties, ManagedObjectPath<?, ?> p, PropertyDefinition<P> pd) {
        try {
            Driver context = this.getDriver();
            Collection<P> defaultValues = context.findDefaultValues(p, pd, true);
            properties.addProperty(pd, defaultValues, Collections.emptySet());
        }
        catch (PropertyException e) {
            properties.addProperty(pd, Collections.emptySet(), Collections.emptySet());
            throw e;
        }
    }

    private void ensureThisManagedObjectExists() throws ConcurrentModificationException, LdapException {
        if (!this.path.isEmpty()) {
            Driver ctx = this.getDriver();
            try {
                if (!ctx.managedObjectExists(this.path)) {
                    throw new ConcurrentModificationException();
                }
            }
            catch (ManagedObjectNotFoundException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private void validateRelationDefinition(RelationDefinition<?, ?> rd) {
        ManagedObjectDefinition<T, Configuration> d = this.getManagedObjectDefinition();
        RelationDefinition<?, ?> tmp = d.getRelationDefinition(rd.getName());
        if (tmp != rd) {
            throw new IllegalArgumentException("The relation " + rd.getName() + " is not associated with a " + d.getName());
        }
    }

    private final class DefaultManagedObjectFactory
    implements RelationDefinitionVisitor<Void, Void> {
        private ManagedObjectAlreadyExistsException moaee;
        private MissingMandatoryPropertiesException mmpe;
        private ConcurrentModificationException cme;
        private OperationRejectedException ore;
        private LdapException ere;

        private DefaultManagedObjectFactory() {
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Void visitInstantiable(InstantiableRelationDefinition<C, S> rd, Void p) {
            for (String name : rd.getDefaultManagedObjectNames()) {
                ManagedObject<C> child;
                DefaultManagedObject<C, S> dmo = rd.getDefaultManagedObject(name);
                ManagedObjectDefinition<C, S> d = dmo.getManagedObjectDefinition();
                try {
                    child = AbstractManagedObject.this.createChild(rd, d, name, null);
                }
                catch (IllegalManagedObjectNameException e) {
                    throw new RuntimeException(e);
                }
                this.createDefaultManagedObject(d, child, dmo);
            }
            return null;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Void visitOptional(OptionalRelationDefinition<C, S> rd, Void p) {
            if (rd.getDefaultManagedObject() != null) {
                DefaultManagedObject<C, S> dmo = rd.getDefaultManagedObject();
                ManagedObjectDefinition<C, S> d = dmo.getManagedObjectDefinition();
                ManagedObject<C> child = AbstractManagedObject.this.createChild(rd, d, null);
                this.createDefaultManagedObject(d, child, dmo);
            }
            return null;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Void visitSingleton(SingletonRelationDefinition<C, S> rd, Void p) {
            return null;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Void visitSet(SetRelationDefinition<C, S> rd, Void p) {
            for (String name : rd.getDefaultManagedObjectNames()) {
                DefaultManagedObject<C, S> dmo = rd.getDefaultManagedObject(name);
                ManagedObjectDefinition<C, S> d = dmo.getManagedObjectDefinition();
                ManagedObject<C> child = AbstractManagedObject.this.createChild(rd, d, null);
                this.createDefaultManagedObject(d, child, dmo);
            }
            return null;
        }

        private void createDefaultManagedObject(ManagedObjectDefinition<?, ?> d, ManagedObject<?> child, DefaultManagedObject<?, ?> dmo) {
            for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
                this.setPropertyValues(child, pd, dmo);
            }
            try {
                child.commit();
            }
            catch (ManagedObjectAlreadyExistsException e) {
                this.moaee = e;
            }
            catch (MissingMandatoryPropertiesException e) {
                this.mmpe = e;
            }
            catch (ConcurrentModificationException e) {
                this.cme = e;
            }
            catch (OperationRejectedException e) {
                this.ore = e;
            }
            catch (LdapException e) {
                this.ere = e;
            }
        }

        private void createDefaultManagedObjects(RelationDefinition<?, ?> rd) throws LdapException, ConcurrentModificationException, MissingMandatoryPropertiesException, ManagedObjectAlreadyExistsException, OperationRejectedException {
            rd.accept(this, null);
            if (this.ere != null) {
                throw this.ere;
            }
            if (this.cme != null) {
                throw this.cme;
            }
            if (this.mmpe != null) {
                throw this.mmpe;
            }
            if (this.moaee != null) {
                throw this.moaee;
            }
            if (this.ore != null) {
                throw this.ore;
            }
        }

        private <P> void setPropertyValues(ManagedObject<?> mo, PropertyDefinition<P> pd, DefaultManagedObject<?, ?> dmo) {
            mo.setPropertyValues(pd, dmo.getPropertyValues((PropertyDefinition)pd));
        }
    }
}

