/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.client.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.DefinitionResolver;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.LDAPProfile;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.Reference;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.client.ldap.DNBuilder;
import org.forgerock.opendj.config.client.ldap.LDAPManagedObject;
import org.forgerock.opendj.config.client.ldap.LDAPManagementContext;
import org.forgerock.opendj.config.client.spi.Driver;
import org.forgerock.opendj.config.client.spi.PropertySet;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultReferenceIOException;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldif.ConnectionEntryReader;
import org.forgerock.opendj.server.config.client.RootCfgClient;
import org.forgerock.opendj.server.config.meta.RootCfgDefn;

final class LDAPDriver
extends Driver {
    private LDAPManagementContext context;
    private final Connection connection;
    private final LDAPProfile profile;

    LDAPDriver(Connection connection, LDAPProfile profile) {
        this.connection = connection;
        this.profile = profile;
    }

    void setManagementContext(LDAPManagementContext context) {
        this.context = context;
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getManagedObject(ManagedObjectPath<C, S> path) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, LdapException {
        if (!this.managedObjectExists(path)) {
            throw new ManagedObjectNotFoundException();
        }
        try {
            DN dn = DNBuilder.create(path, this.profile);
            AbstractManagedObjectDefinition<C, S> d = path.getManagedObjectDefinition();
            ManagedObjectDefinition<C, S> mod = this.getEntryDefinition(d, dn);
            ArrayList<String> attrIds = new ArrayList<String>();
            for (PropertyDefinition<?> pd : mod.getAllPropertyDefinitions()) {
                attrIds.add(this.profile.getAttributeName(mod, pd));
            }
            SearchResultEntry searchResultEntry = this.connection.readEntry(dn, attrIds.toArray(new String[0]));
            LinkedList<PropertyException> exceptions = new LinkedList<PropertyException>();
            PropertySet newProperties = new PropertySet();
            for (PropertyDefinition<?> pd : mod.getAllPropertyDefinitions()) {
                String attrID = this.profile.getAttributeName(mod, pd);
                Attribute attribute = searchResultEntry.getAttribute(attrID);
                try {
                    this.decodeProperty(newProperties, path, pd, attribute);
                }
                catch (PropertyException e) {
                    exceptions.add(e);
                }
            }
            ManagedObject<C> mo = this.createExistingManagedObject(mod, path, newProperties);
            if (exceptions.isEmpty()) {
                return mo;
            }
            throw new ManagedObjectDecodingException(mo, exceptions);
        }
        catch (LdapException e) {
            if (e.getResult().getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                throw new ManagedObjectNotFoundException();
            }
            throw e;
        }
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration, P> SortedSet<P> getPropertyValues(ManagedObjectPath<C, S> path, PropertyDefinition<P> propertyDef) throws DefinitionDecodingException, ManagedObjectNotFoundException, LdapException {
        AbstractManagedObjectDefinition<C, S> d = path.getManagedObjectDefinition();
        PropertyDefinition<?> tmp = d.getPropertyDefinition(propertyDef.getName());
        if (tmp != propertyDef) {
            throw new IllegalArgumentException("The property " + propertyDef.getName() + " is not associated with a " + d.getName());
        }
        if (!this.managedObjectExists(path)) {
            throw new ManagedObjectNotFoundException();
        }
        try {
            DN dn = DNBuilder.create(path, this.profile);
            ManagedObjectDefinition<C, S> objectDef = this.getEntryDefinition(d, dn);
            propertyDef = objectDef.getPropertyDefinition(propertyDef.getName());
            String attrID = this.profile.getAttributeName(objectDef, propertyDef);
            SearchResultEntry resultEntry = this.connection.readEntry(dn, new String[]{attrID});
            Attribute attribute = resultEntry.getAttribute(attrID);
            TreeSet<P> values = new TreeSet<P>(propertyDef);
            if (attribute != null) {
                for (ByteString byteValue : attribute) {
                    Object value = ValueDecoder.decode(propertyDef, byteValue);
                    values.add(value);
                }
            }
            if (values.size() > 1 && !propertyDef.hasOption(PropertyOption.MULTI_VALUED)) {
                throw PropertyException.propertyIsSingleValuedException(propertyDef);
            }
            if (values.isEmpty() && propertyDef.hasOption(PropertyOption.MANDATORY)) {
                throw PropertyException.propertyIsMandatoryException(propertyDef);
            }
            if (values.isEmpty()) {
                values.addAll(this.findDefaultValues(path.asSubType(objectDef), propertyDef, false));
            }
            return values;
        }
        catch (LdapException e) {
            if (e.getResult().getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                throw new ManagedObjectNotFoundException();
            }
            throw e;
        }
    }

    @Override
    public ManagedObject<RootCfgClient> getRootConfigurationManagedObject() {
        return new LDAPManagedObject<RootCfgClient>(this, RootCfgDefn.getInstance(), ManagedObjectPath.emptyPath(), new PropertySet(), true, null);
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> String[] listManagedObjects(ManagedObjectPath<?, ?> parent, InstantiableRelationDefinition<C, S> rd, AbstractManagedObjectDefinition<? extends C, ? extends S> d) throws ManagedObjectNotFoundException, LdapException {
        ArrayList<String> children;
        block4: {
            this.validateRelationDefinition(parent, rd);
            if (!this.managedObjectExists(parent)) {
                throw new ManagedObjectNotFoundException();
            }
            DN dn = DNBuilder.create(parent, rd, this.profile);
            Filter filter = Filter.equality((String)"objectClass", (Object)this.profile.getObjectClass(d));
            children = new ArrayList<String>();
            try {
                for (DN child : this.listEntries(dn, filter)) {
                    children.add(child.rdn().getFirstAVA().getAttributeValue().toString());
                }
            }
            catch (LdapException e) {
                if (e.getResult().getResultCode() == ResultCode.NO_SUCH_OBJECT) break block4;
                throw e;
            }
        }
        return children.toArray(new String[children.size()]);
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> String[] listManagedObjects(ManagedObjectPath<?, ?> parent, SetRelationDefinition<C, S> rd, AbstractManagedObjectDefinition<? extends C, ? extends S> d) throws ManagedObjectNotFoundException, LdapException {
        ArrayList<String> children;
        block4: {
            this.validateRelationDefinition(parent, rd);
            if (!this.managedObjectExists(parent)) {
                throw new ManagedObjectNotFoundException();
            }
            DN dn = DNBuilder.create(parent, rd, this.profile);
            Filter filter = Filter.equality((String)"objectClass", (Object)this.profile.getObjectClass(d));
            children = new ArrayList<String>();
            try {
                for (DN child : this.listEntries(dn, filter)) {
                    children.add(child.rdn().getFirstAVA().getAttributeValue().toString());
                }
            }
            catch (LdapException e) {
                if (e.getResult().getResultCode() == ResultCode.NO_SUCH_OBJECT) break block4;
                throw e;
            }
        }
        return children.toArray(new String[children.size()]);
    }

    @Override
    public boolean managedObjectExists(ManagedObjectPath<?, ?> path) throws ManagedObjectNotFoundException, LdapException {
        if (path.isEmpty()) {
            return true;
        }
        ManagedObjectPath<?, ?> parent = path.parent();
        DN dn = DNBuilder.create(parent, this.profile);
        if (!this.entryExists(dn)) {
            throw new ManagedObjectNotFoundException();
        }
        dn = DNBuilder.create(path, this.profile);
        return this.entryExists(dn);
    }

    @Override
    protected <C extends ConfigurationClient, S extends Configuration> void deleteManagedObject(ManagedObjectPath<C, S> path) throws OperationRejectedException, LdapException {
        DN dn = DNBuilder.create(path, this.profile);
        try {
            this.deleteSubtree(dn);
        }
        catch (LdapException e) {
            if (e.getResult().getResultCode() == ResultCode.UNWILLING_TO_PERFORM) {
                AbstractManagedObjectDefinition<C, S> d = path.getManagedObjectDefinition();
                LocalizableMessage m = LocalizableMessage.raw((CharSequence)"%s", (Object[])new Object[]{e.getMessage()});
                throw new OperationRejectedException(OperationRejectedException.OperationType.DELETE, d.getUserFriendlyName(), m);
            }
            throw e;
        }
    }

    @Override
    protected LDAPManagementContext getManagementContext() {
        return this.context;
    }

    boolean entryExists(DN dn) throws LdapException {
        try {
            this.connection.readEntry(dn, new String[]{"1.1"});
            return true;
        }
        catch (EntryNotFoundException e) {
            return false;
        }
    }

    Connection getLDAPConnection() {
        return this.connection;
    }

    LDAPProfile getLDAPProfile() {
        return this.profile;
    }

    private <M extends ConfigurationClient, N extends Configuration> ManagedObject<M> createExistingManagedObject(ManagedObjectDefinition<M, N> d, ManagedObjectPath<? super M, ? super N> p, PropertySet properties) {
        RelationDefinition<? super M, ? super N> rd = p.getRelationDefinition();
        PropertyDefinition<?> pd = null;
        if (rd instanceof InstantiableRelationDefinition) {
            InstantiableRelationDefinition ird = (InstantiableRelationDefinition)rd;
            pd = ird.getNamingPropertyDefinition();
        }
        return new LDAPManagedObject<M>(this, d, p.asSubType(d), properties, true, pd);
    }

    private <P> void decodeProperty(PropertySet newProperties, ManagedObjectPath<?, ?> path, PropertyDefinition<P> propertyDef, Attribute attribute) {
        Collection<Object> defaultValues;
        PropertyException exception = null;
        TreeSet<P> activeValues = new TreeSet<P>(propertyDef);
        if (attribute != null) {
            for (ByteString byteValue : attribute) {
                P value = ValueDecoder.decode(propertyDef, byteValue);
                activeValues.add(value);
            }
        }
        if (activeValues.size() > 1 && !propertyDef.hasOption(PropertyOption.MULTI_VALUED)) {
            exception = PropertyException.propertyIsSingleValuedException(propertyDef);
            Object value = activeValues.first();
            activeValues.clear();
            activeValues.add(value);
        }
        try {
            defaultValues = this.findDefaultValues(path, propertyDef, false);
        }
        catch (PropertyException e) {
            defaultValues = Collections.emptySet();
            exception = e;
        }
        newProperties.addProperty(propertyDef, defaultValues, activeValues);
        if (activeValues.isEmpty() && defaultValues.isEmpty() && propertyDef.hasOption(PropertyOption.MANDATORY) && exception == null) {
            exception = PropertyException.propertyIsMandatoryException(propertyDef);
        }
        if (exception != null) {
            throw exception;
        }
    }

    private <C extends ConfigurationClient, S extends Configuration> ManagedObjectDefinition<? extends C, ? extends S> getEntryDefinition(AbstractManagedObjectDefinition<C, S> d, DN dn) throws LdapException, DefinitionDecodingException {
        SearchResultEntry searchResultEntry = this.connection.readEntry(dn, new String[]{"objectclass"});
        Attribute objectClassAttr = searchResultEntry.getAttribute("objectclass");
        if (objectClassAttr == null) {
            throw new DefinitionDecodingException(d, DefinitionDecodingException.Reason.NO_TYPE_INFORMATION);
        }
        final HashSet<String> objectClasses = new HashSet<String>();
        for (ByteString byteValue : objectClassAttr) {
            objectClasses.add(byteValue.toString().toLowerCase().trim());
        }
        if (objectClasses.isEmpty()) {
            throw new DefinitionDecodingException(d, DefinitionDecodingException.Reason.NO_TYPE_INFORMATION);
        }
        DefinitionResolver resolver = new DefinitionResolver(){

            @Override
            public boolean matches(AbstractManagedObjectDefinition<?, ?> d) {
                String objectClass = LDAPDriver.this.profile.getObjectClass(d);
                return objectClasses.contains(objectClass);
            }
        };
        return d.resolveManagedObjectDefinition(resolver);
    }

    private void deleteSubtree(DN dn) throws LdapException {
        for (DN child : this.listEntries(dn, Filter.objectClassPresent())) {
            this.deleteSubtree(child);
        }
        this.connection.delete(dn.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<DN> listEntries(DN dn, Filter filter) throws LdapException {
        SearchRequest searchRequest = Requests.newSearchRequest((DN)dn, (SearchScope)SearchScope.SINGLE_LEVEL, (Filter)filter, (String[])new String[0]);
        try (ConnectionEntryReader reader = this.connection.search(searchRequest);){
            LinkedList<DN> names = new LinkedList<DN>();
            while (reader.hasNext()) {
                names.add(reader.readEntry().getName());
            }
            LinkedList<DN> linkedList = names;
            return linkedList;
        }
        catch (SearchResultReferenceIOException ignore) {
            return Collections.emptyList();
        }
    }

    private static final class ValueDecoder
    extends PropertyDefinitionVisitor<Object, String> {
        public static <P> P decode(PropertyDefinition<P> pd, Object value) {
            String s = String.valueOf(value);
            return pd.castValue(pd.accept(new ValueDecoder(), s));
        }

        private ValueDecoder() {
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Object visitAggregation(AggregationPropertyDefinition<C, S> d, String p) {
            try {
                Reference<C, S> reference = Reference.parseDN(d.getParentPath(), d.getRelationDefinition(), p);
                return reference.getName();
            }
            catch (IllegalArgumentException e) {
                throw PropertyException.illegalPropertyValueException(d, p);
            }
        }

        @Override
        public <T> Object visitUnknown(PropertyDefinition<T> d, String p) {
            return d.decodeValue(p);
        }
    }
}

