/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.ManagedObjectDefinitionI18NResource;
import org.forgerock.opendj.server.config.meta.RootCfgDefn;
import org.forgerock.util.Reject;

public final class Tag
implements Comparable<Tag> {
    private static final Map<String, Tag> TAGS = new HashMap<String, Tag>();
    private final String name;

    public static void define(String name) {
        Tag tag = new Tag(name);
        TAGS.put(name, tag);
    }

    public static Tag valueOf(String name) {
        Reject.ifNull((Object)name);
        RootCfgDefn.getInstance();
        Tag tag = TAGS.get(name.toLowerCase());
        if (tag == null) {
            throw new IllegalArgumentException("Unknown tag \"" + name + "\"");
        }
        return tag;
    }

    public static Collection<Tag> values() {
        RootCfgDefn.getInstance();
        return Collections.unmodifiableCollection(TAGS.values());
    }

    private Tag(String name) {
        this.name = name;
    }

    @Override
    public final int compareTo(Tag o) {
        return this.name.compareTo(o.name);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tag) {
            Tag other = (Tag)obj;
            return other.name.equals(this.name);
        }
        return false;
    }

    public final String getName() {
        return this.name;
    }

    public final LocalizableMessage getSynopsis() {
        return this.getSynopsis(Locale.getDefault());
    }

    public final LocalizableMessage getSynopsis(Locale locale) {
        ManagedObjectDefinitionI18NResource resource = ManagedObjectDefinitionI18NResource.getInstance();
        String property = "tag." + this.name + ".synopsis";
        try {
            return resource.getMessage(RootCfgDefn.getInstance(), property, locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final String toString() {
        return this.name;
    }
}

