/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import com.forgerock.opendj.ldap.config.ConfigMessages;
import org.forgerock.i18n.LocalizableException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionUsageBuilder;

public final class PropertyException
extends RuntimeException
implements LocalizableException {
    private static final long serialVersionUID = -8465109598081914482L;
    private final LocalizableMessage message;
    private final PropertyDefinition<?> pd;

    public static PropertyException defaultBehaviorException(PropertyDefinition<?> pd, Throwable cause) {
        return new PropertyException(pd, ConfigMessages.ERR_DEFAULT_BEHAVIOR_PROPERTY_EXCEPTION.get((Object)pd.getName()), cause);
    }

    public static PropertyException illegalPropertyValueException(PropertyDefinition<?> pd, Object value) {
        return new PropertyException(pd, PropertyException.createMessage(pd, value));
    }

    public static PropertyException illegalPropertyValueException(PropertyDefinition<?> pd, Object value, Throwable cause) {
        return new PropertyException(pd, PropertyException.createMessage(pd, value), cause);
    }

    public static PropertyException propertyIsMandatoryException(PropertyDefinition<?> pd) {
        return new PropertyException(pd, ConfigMessages.ERR_PROPERTY_IS_MANDATORY_EXCEPTION.get((Object)pd.getName()));
    }

    public static PropertyException propertyIsReadOnlyException(PropertyDefinition<?> pd) {
        return new PropertyException(pd, ConfigMessages.ERR_PROPERTY_IS_READ_ONLY_EXCEPTION.get((Object)pd.getName()));
    }

    public static PropertyException propertyIsSingleValuedException(PropertyDefinition<?> pd) {
        return new PropertyException(pd, ConfigMessages.ERR_PROPERTY_IS_SINGLE_VALUED_EXCEPTION.get((Object)pd.getName()));
    }

    public static PropertyException unknownPropertyDefinitionException(PropertyDefinition<?> pd) {
        return new PropertyException(pd, ConfigMessages.ERR_UNKNOWN_PROPERTY_DEFINITION_EXCEPTION.get((Object)pd.getName(), (Object)pd.getClass().getName()));
    }

    private static LocalizableMessage createMessage(PropertyDefinition<?> pd, Object value) {
        PropertyDefinitionUsageBuilder builder = new PropertyDefinitionUsageBuilder(true);
        return ConfigMessages.ERR_ILLEGAL_PROPERTY_VALUE_EXCEPTION.get(value, (Object)pd.getName(), (Object)builder.getUsage(pd));
    }

    private PropertyException(PropertyDefinition<?> pd, LocalizableMessage message) {
        super(message.toString());
        this.message = message;
        this.pd = pd;
    }

    private PropertyException(PropertyDefinition<?> pd, LocalizableMessage message, Throwable cause) {
        super(message.toString(), cause);
        this.message = message;
        this.pd = pd;
    }

    public LocalizableMessage getMessageObject() {
        return this.message;
    }

    public final PropertyDefinition<?> getPropertyDefinition() {
        return this.pd;
    }
}

