/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import org.forgerock.opendj.config.ACIPropertyDefinition;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AttributeTypePropertyDefinition;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.IPAddressMaskPropertyDefinition;
import org.forgerock.opendj.config.IPAddressPropertyDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.SizePropertyDefinition;
import org.forgerock.opendj.config.StringPropertyDefinition;

public abstract class PropertyDefinitionVisitor<R, P> {
    protected PropertyDefinitionVisitor() {
    }

    public R visitACI(ACIPropertyDefinition pd, P p) {
        return this.visitUnknown(pd, p);
    }

    public <C extends ConfigurationClient, S extends Configuration> R visitAggregation(AggregationPropertyDefinition<C, S> pd, P p) {
        return this.visitUnknown(pd, p);
    }

    public R visitAttributeType(AttributeTypePropertyDefinition pd, P p) {
        return this.visitUnknown(pd, p);
    }

    public R visitBoolean(BooleanPropertyDefinition pd, P p) {
        return this.visitUnknown(pd, p);
    }

    public R visitClass(ClassPropertyDefinition pd, P p) {
        return this.visitUnknown(pd, p);
    }

    public R visitDN(DNPropertyDefinition pd, P p) {
        return this.visitUnknown(pd, p);
    }

    public R visitDuration(DurationPropertyDefinition pd, P p) {
        return this.visitUnknown(pd, p);
    }

    public <E extends Enum<E>> R visitEnum(EnumPropertyDefinition<E> pd, P p) {
        return this.visitUnknown(pd, p);
    }

    public R visitInteger(IntegerPropertyDefinition pd, P p) {
        return this.visitUnknown(pd, p);
    }

    public R visitIPAddress(IPAddressPropertyDefinition pd, P p) {
        return this.visitUnknown(pd, p);
    }

    public R visitIPAddressMask(IPAddressMaskPropertyDefinition pd, P p) {
        return this.visitUnknown(pd, p);
    }

    public R visitSize(SizePropertyDefinition pd, P p) {
        return this.visitUnknown(pd, p);
    }

    public R visitString(StringPropertyDefinition pd, P p) {
        return this.visitUnknown(pd, p);
    }

    public <T> R visitUnknown(PropertyDefinition<T> pd, P p) {
        throw PropertyException.unknownPropertyDefinitionException(pd);
    }
}

