/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.audit.events.EventTopicsMetaData;
import org.forgerock.audit.events.handlers.AuditEventHandlerBase;
import org.forgerock.audit.handlers.json.JsonAuditEventHandlerConfiguration;
import org.forgerock.audit.handlers.json.JsonFileWriter;
import org.forgerock.audit.util.ElasticsearchUtil;
import org.forgerock.audit.util.JsonValueUtils;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CountPolicy;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Responses;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.query.QueryFilter;

public class JsonAuditEventHandler
extends AuditEventHandlerBase {
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    static final String EVENT_ID_FIELD = "_eventId";
    public static final String ROTATE_FILE_ACTION_NAME = "rotate";
    public static final String FLUSH_FILE_ACTION_NAME = "flush";
    private static final String ID_FIELD_PATTERN_PREFIX = "\"_id\"\\s*:\\s*\"";
    private static final String EVENT_ID_FIELD_PATTERN_PREFIX = "\"_eventId\"\\s*:\\s*\"";
    private static final String FIELD_PATTERN_SUFFIX = "\"";
    private final JsonFileWriter jsonFileWriter;
    private final boolean elasticsearchCompatible;

    public JsonAuditEventHandler(JsonAuditEventHandlerConfiguration configuration, EventTopicsMetaData eventTopicsMetaData) {
        super(configuration.getName(), eventTopicsMetaData, configuration.getTopics(), configuration.isEnabled());
        this.jsonFileWriter = new JsonFileWriter(configuration.getTopics(), configuration, true);
        this.elasticsearchCompatible = configuration.isElasticsearchCompatible();
    }

    public void startup() throws ResourceException {
        this.jsonFileWriter.startup();
    }

    public void shutdown() throws ResourceException {
        this.jsonFileWriter.shutdown();
    }

    public Promise<ResourceResponse, ResourceException> publishEvent(Context context, String topic, JsonValue event) {
        try {
            this.jsonFileWriter.put(topic, event);
        }
        catch (Exception e) {
            return ResourceException.newResourceException((int)500, (String)"Failed to add event to queue", (Throwable)e).asPromise();
        }
        return Responses.newResourceResponse((String)event.get("_id").asString(), null, (JsonValue)event).asPromise();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Promise<ResourceResponse, ResourceException> readEvent(Context context, String topic, String resourceId) {
        Path jsonFilePath = this.jsonFileWriter.getTopicFilePath(topic);
        if (jsonFilePath == null) {
            return ResourceException.newResourceException((int)404, (String)("Topic not found: " + topic)).asPromise();
        }
        String fieldPatternPrefix = this.elasticsearchCompatible ? EVENT_ID_FIELD_PATTERN_PREFIX : ID_FIELD_PATTERN_PREFIX;
        Matcher idMatcher = Pattern.compile(fieldPatternPrefix + resourceId + FIELD_PATTERN_SUFFIX).matcher("");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(jsonFilePath, new OpenOption[0]), StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                if (idMatcher.reset(line).find()) {
                    JsonValue event = this.denormalizeJsonEvent(new JsonValue(OBJECT_MAPPER.readValue(line, Map.class)));
                    Promise promise = Responses.newResourceResponse((String)resourceId, null, (JsonValue)event).asPromise();
                    return promise;
                }
                line = reader.readLine();
            }
            Promise promise = ResourceException.newResourceException((int)404, (String)("Resource not found with ID: " + resourceId)).asPromise();
            return promise;
        }
        catch (Exception e) {
            return ResourceException.newResourceException((int)500, (String)("Failed to read json file: " + jsonFilePath), (Throwable)e).asPromise();
        }
    }

    public Promise<QueryResponse, ResourceException> queryEvents(Context context, String topic, QueryRequest query, QueryResourceHandler handler) {
        Path jsonFilePath = this.jsonFileWriter.getTopicFilePath(topic);
        if (jsonFilePath == null) {
            return ResourceException.newResourceException((int)404, (String)("Topic not found: " + topic)).asPromise();
        }
        QueryFilter queryFilter = query.getQueryFilter();
        int results = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(jsonFilePath, new OpenOption[0]), StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                JsonValue event = this.denormalizeJsonEvent(new JsonValue(OBJECT_MAPPER.readValue(line, Map.class)));
                if (((Boolean)queryFilter.accept(JsonValueUtils.JSONVALUE_FILTER_VISITOR, (Object)event)).booleanValue()) {
                    ++results;
                    ResourceResponse resourceResponse = Responses.newResourceResponse((String)event.get("_id").asString(), null, (JsonValue)event);
                    if (!handler.handleResource(resourceResponse)) {
                        break;
                    }
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            return ResourceException.newResourceException((int)500, (String)("Failed to read json file: " + jsonFilePath), (Throwable)e).asPromise();
        }
        return Responses.newQueryResponse(null, (CountPolicy)CountPolicy.EXACT, (int)results).asPromise();
    }

    public Promise<ActionResponse, ResourceException> handleAction(Context context, String topic, ActionRequest request) {
        Path jsonFilePath = this.jsonFileWriter.getTopicFilePath(topic);
        if (jsonFilePath == null) {
            return ResourceException.newResourceException((int)404, (String)("Topic not found: " + topic)).asPromise();
        }
        try {
            switch (request.getAction()) {
                case "rotate": {
                    if (this.jsonFileWriter.rotateFile(topic)) break;
                    return ResourceException.newResourceException((int)400, (String)"Rotation not enabled").asPromise();
                }
                case "flush": {
                    this.jsonFileWriter.flushFileBuffer(topic);
                    break;
                }
                default: {
                    return ResourceException.newResourceException((int)400, (String)("Unsupported action: " + request.getAction())).asPromise();
                }
            }
            return Responses.newActionResponse((JsonValue)JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"status", (Object)"OK")}))).asPromise();
        }
        catch (Exception e) {
            return ResourceException.newResourceException((int)500, (String)"Failed to invoke action", (Throwable)e).asPromise();
        }
    }

    private JsonValue denormalizeJsonEvent(JsonValue event) throws IOException {
        if (this.elasticsearchCompatible) {
            event = ElasticsearchUtil.denormalizeJson((JsonValue)event);
            ElasticsearchUtil.renameField((JsonValue)event, (String)EVENT_ID_FIELD, (String)"_id");
        }
        return event;
    }
}

