/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.json;

import java.io.OutputStream;
import java.nio.ByteBuffer;

class ByteBufferOutputStream
extends OutputStream {
    private static final double GROWTH_RATE = 1.33;
    private ByteBuffer buffer;

    public ByteBufferOutputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer byteBuffer() {
        return this.buffer;
    }

    public void clear() {
        this.buffer.clear();
    }

    private void growTo(int newCapacity) {
        ByteBuffer oldBuffer = this.buffer;
        this.buffer = this.buffer.isDirect() ? ByteBuffer.allocateDirect(newCapacity) : ByteBuffer.allocate(newCapacity);
        oldBuffer.flip();
        this.buffer.put(oldBuffer);
    }

    @Override
    public void write(int b) {
        if (this.buffer.remaining() == 0) {
            this.growTo((int)((double)this.buffer.capacity() * 1.33));
        }
        this.buffer.put((byte)b);
    }

    @Override
    public void write(byte[] bytes) {
        if (this.buffer.remaining() < bytes.length) {
            int newSize = Math.max((int)((double)this.buffer.capacity() * 1.33), this.buffer.position() + bytes.length);
            this.growTo(newSize);
        }
        this.buffer.put(bytes);
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("len must be positive");
        }
        if (this.buffer.remaining() < len) {
            int newSize = Math.max((int)((double)this.buffer.capacity() * 1.33), this.buffer.position() + len);
            this.growTo(newSize);
        }
        this.buffer.put(bytes, off, len);
    }
}

