/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.security;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldif.LDIFEntryReader;

public final class OpenDJProviderSchema {
    private static final URL SCHEMA_LDIF_URL = OpenDJProviderSchema.class.getResource("03-keystore.ldif");
    static final Schema SCHEMA;
    private static final Set<ObjectClass> OBJECT_CLASSES;
    private static final Set<AttributeType> ATTRIBUTE_TYPES;
    static final String OC_KEY_STORE_OBJECT = "ds-keystore-object";
    static final String OC_TRUSTED_CERTIFICATE = "ds-keystore-trusted-certificate";
    static final String OC_PRIVATE_KEY = "ds-keystore-private-key";
    static final String OC_SECRET_KEY = "ds-keystore-secret-key";
    static final String ATTR_ALIAS = "ds-keystore-alias";
    static final String ATTR_KEY_ALGORITHM = "ds-keystore-key-algorithm";
    static final String ATTR_KEY = "ds-keystore-key";
    static final String ATTR_CERTIFICATE_CHAIN = "ds-keystore-certificate-chain";
    private static final String ATTR_CERTIFICATE = "ds-keystore-certificate";
    static final String ATTR_CERTIFICATE_BINARY = "ds-keystore-certificate;binary";
    static final String ATTR_OBJECT_CLASS = "objectClass";
    static final String ATTR_MODIFY_TIME_STAMP = "modifyTimeStamp";
    static final String ATTR_CREATE_TIME_STAMP = "createTimeStamp";

    public static Set<ObjectClass> getObjectClasses() {
        return OBJECT_CLASSES;
    }

    public static Set<AttributeType> getAttributeTypes() {
        return ATTRIBUTE_TYPES;
    }

    public static URL getSchemaLDIFResource() {
        return SCHEMA_LDIF_URL;
    }

    public static SchemaBuilder addOpenDJProviderSchema(SchemaBuilder builder) {
        for (AttributeType attributeType : ATTRIBUTE_TYPES) {
            builder.buildAttributeType(attributeType).addToSchema();
        }
        for (ObjectClass objectClass : OBJECT_CLASSES) {
            builder.buildObjectClass(objectClass).addToSchema();
        }
        return builder;
    }

    private OpenDJProviderSchema() {
    }

    static {
        try (InputStream inputStream = SCHEMA_LDIF_URL.openStream();
             LDIFEntryReader reader = new LDIFEntryReader(inputStream);){
            SCHEMA = new SchemaBuilder(Schema.getCoreSchema()).addSchema(reader.readEntry(), false).toSchema().asNonStrictSchema();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        OBJECT_CLASSES = Collections.unmodifiableSet(new LinkedHashSet<ObjectClass>(Arrays.asList(SCHEMA.getObjectClass(OC_KEY_STORE_OBJECT), SCHEMA.getObjectClass(OC_TRUSTED_CERTIFICATE), SCHEMA.getObjectClass(OC_SECRET_KEY), SCHEMA.getObjectClass(OC_PRIVATE_KEY))));
        ATTRIBUTE_TYPES = Collections.unmodifiableSet(new LinkedHashSet<AttributeType>(Arrays.asList(SCHEMA.getAttributeType(ATTR_ALIAS), SCHEMA.getAttributeType(ATTR_KEY_ALGORITHM), SCHEMA.getAttributeType(ATTR_KEY), SCHEMA.getAttributeType(ATTR_CERTIFICATE_CHAIN), SCHEMA.getAttributeType(ATTR_CERTIFICATE))));
    }
}

