/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.security;

import com.forgerock.opendj.security.KeystoreMessages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConstraintViolationException;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldif.ConnectionEntryReader;
import org.forgerock.opendj.security.KeyProtector;
import org.forgerock.opendj.security.KeyStoreObject;
import org.forgerock.opendj.security.KeyStoreObjectCache;
import org.forgerock.opendj.security.KeyStoreParameters;
import org.forgerock.opendj.security.LocalizedKeyStoreException;
import org.forgerock.opendj.security.OpenDJProvider;
import org.forgerock.util.Options;

final class KeyStoreImpl
extends KeyStoreSpi {
    private static final LocalizedLogger logger = LocalizedLogger.getLocalizedLogger(KeyStoreImpl.class);
    private static final String[] SEARCH_ATTR_LIST = new String[]{"*", "createTimeStamp", "modifyTimeStamp"};
    private static final Filter FILTER_KEYSTORE_OBJECT = Filter.valueOf("(objectClass=ds-keystore-object)");
    private final OpenDJProvider provider;
    private KeyStoreParameters config;
    private KeyStoreObjectCache cache;
    private KeyProtector keyProtector;

    KeyStoreImpl(OpenDJProvider provider) {
        this.provider = provider;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStoreObject object = this.readKeyStoreObject(alias);
        return object != null ? object.getKey(this.keyProtector, password) : null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        KeyStoreObject object = this.readKeyStoreObject(alias);
        return object != null ? object.getCertificateChain() : null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        KeyStoreObject object = this.readKeyStoreObject(alias);
        return object != null ? object.getCertificate() : null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        KeyStoreObject object = this.readKeyStoreObject(alias);
        return object != null ? object.getCreationDate() : null;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        this.writeKeyStoreObject(KeyStoreObject.newKeyObject(alias, key, chain, this.keyProtector, password));
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        KeyStoreObject object = this.readKeyStoreObject(alias);
        if (object != null && !object.isTrustedCertificate()) {
            throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_KEY_ENTRY_ALREADY_EXISTS.get((Object)alias));
        }
        this.writeKeyStoreObject(KeyStoreObject.newTrustedCertificateObject(alias, cert));
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        try (Connection connection2 = this.config.getConnection();){
            connection2.delete(Requests.newDeleteRequest(KeyStoreObject.dnOf(this.config.getBaseDN(), alias)));
        }
        catch (EntryNotFoundException connection2) {
        }
        catch (LdapException e) {
            throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_DELETE_FAILURE.get((Object)alias), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Enumeration<String> engineAliases() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String aliasOf(Entry entry) {
        return entry.getName().rdn().getFirstAVA().getAttributeValue().toString();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.readKeyStoreObject(alias) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int engineSize() {
        try (Connection connection = this.config.getConnection();){
            SearchResultEntry baseEntry = connection.readEntry(this.config.getBaseDN(), "numSubordinates");
            int n = baseEntry.parseAttribute("numSubordinates").asInteger(0);
            return n;
        }
        catch (LdapException e) {
            logger.warn(KeystoreMessages.KEYSTORE_READ_FAILURE.get(), (Throwable)e);
            return 0;
        }
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        KeyStoreObject object = this.readKeyStoreObject(alias);
        return object != null && !object.isTrustedCertificate();
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        KeyStoreObject object = this.readKeyStoreObject(alias);
        return object != null && object.isTrustedCertificate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        Filter filter = Filter.and(FILTER_KEYSTORE_OBJECT, Filter.equality("ds-keystore-certificate;binary", this.getCertificateAssertion(cert)));
        SearchRequest searchRequest = Requests.newSearchRequest(this.config.getBaseDN(), SearchScope.SINGLE_LEVEL, filter, "1.1");
        try (Connection connection = this.config.getConnection();
             ConnectionEntryReader reader = connection.search(searchRequest);){
            do {
                if (!reader.hasNext()) return null;
            } while (!reader.isEntry());
            String string = this.aliasOf(reader.readEntry());
            return string;
        }
        catch (IOException e) {
            logger.warn(KeystoreMessages.KEYSTORE_READ_FAILURE.get(), (Throwable)e);
        }
        return null;
    }

    private String getCertificateAssertion(Certificate cert) {
        X509Certificate x509Certificate = (X509Certificate)cert;
        BigInteger serialNumber = x509Certificate.getSerialNumber();
        String issuerDn = x509Certificate.getIssuerX500Principal().getName().replaceAll("\"", "\"\"");
        return String.format("{serialNumber %s,issuer rdnSequence:\"%s\"}", serialNumber, issuerDn);
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) {
        if (stream != null) {
            throw new IllegalArgumentException("the LDAP key store is not file based");
        }
        this.engineStore(null);
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter param) {
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) {
        if (stream != null) {
            throw new IllegalArgumentException("the LDAP key store is not file based");
        }
        if (this.provider.getDefaultConfig() == null || password == null || password.length == 0) {
            this.engineLoad(null);
        } else {
            KeyStoreParameters defaultConfig = this.provider.getDefaultConfig();
            Options options = Options.copyOf((Options)defaultConfig.getOptions()).set(KeyStoreParameters.GLOBAL_PASSWORD, OpenDJProvider.newClearTextPasswordFactory(password));
            this.engineLoad(KeyStoreParameters.newKeyStoreParameters(defaultConfig.getConnectionFactory(), defaultConfig.getBaseDN(), options));
        }
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter param) {
        if (param != null) {
            try {
                this.config = (KeyStoreParameters)param;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("load must be called with KeyStoreParameters class");
            }
        } else if (this.provider.getDefaultConfig() != null) {
            this.config = this.provider.getDefaultConfig();
        } else {
            throw new IllegalArgumentException("the LDAP key store must be configured using KeyStoreParameters or using the security provider's configuration file");
        }
        this.keyProtector = new KeyProtector(this.config.getOptions());
        this.cache = (KeyStoreObjectCache)this.config.getOptions().get(KeyStoreParameters.CACHE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyStoreObject readKeyStoreObject(String alias) {
        KeyStoreObject cachedKeyStoreObject = this.readCache(alias);
        if (cachedKeyStoreObject != null) {
            return cachedKeyStoreObject;
        }
        try (Connection connection2222 = this.config.getConnection();){
            SearchResultEntry ldapEntry = connection2222.readEntry(KeyStoreObject.dnOf(this.config.getBaseDN(), alias), SEARCH_ATTR_LIST);
            KeyStoreObject keyStoreObject = this.writeCache(KeyStoreObject.valueOf(ldapEntry));
            return keyStoreObject;
        }
        catch (EntryNotFoundException connection2222) {
            return null;
        }
        catch (IOException | LocalizedKeyStoreException e) {
            logger.warn(KeystoreMessages.KEYSTORE_READ_ALIAS_FAILURE.get((Object)alias), (Throwable)e);
        }
        return null;
    }

    private void writeKeyStoreObject(KeyStoreObject keyStoreObject) throws LocalizedKeyStoreException {
        try (Connection connection = this.config.getConnection();){
            Entry newLdapEntry = keyStoreObject.toLDAPEntry(this.config.getBaseDN());
            try {
                connection.add(newLdapEntry);
            }
            catch (ConstraintViolationException e) {
                if (e.getResult().getResultCode() != ResultCode.ENTRY_ALREADY_EXISTS) {
                    throw e;
                }
                SearchResultEntry oldLdapEntry = connection.readEntry(newLdapEntry.getName(), new String[0]);
                connection.modify(Entries.diffEntries(oldLdapEntry, newLdapEntry));
            }
            this.writeCache(keyStoreObject);
        }
        catch (IOException e) {
            throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_UPDATE_ALIAS_FAILURE.get((Object)keyStoreObject.getAlias()), (Throwable)e);
        }
    }

    private KeyStoreObject writeCache(KeyStoreObject keyStoreObject) {
        this.cache.put(keyStoreObject);
        return keyStoreObject;
    }

    private KeyStoreObject readCache(String alias) {
        return this.cache.get(alias);
    }
}

