/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.schema.Schema;

public final class SchemaValidationPolicy {
    private Action checkNameForms = Action.REJECT;
    private Action checkDITStructureRules = Action.IGNORE;
    private Action checkDITContentRules = Action.REJECT;
    private Action requireSingleStructuralObjectClass = Action.REJECT;
    private Action checkAttributesAndObjectClasses = Action.REJECT;
    private Action checkAttributeValues = Action.REJECT;
    private EntryResolver checkDITStructureRulesEntryResolver;

    public static SchemaValidationPolicy copyOf(SchemaValidationPolicy policy) {
        return SchemaValidationPolicy.defaultPolicy().assign(policy);
    }

    public static SchemaValidationPolicy defaultPolicy() {
        return new SchemaValidationPolicy();
    }

    public static SchemaValidationPolicy ignoreAll() {
        return new SchemaValidationPolicy().checkAttributesAndObjectClasses(Action.IGNORE).checkAttributeValues(Action.IGNORE).checkDITContentRules(Action.IGNORE).checkNameForms(Action.IGNORE).requireSingleStructuralObjectClass(Action.IGNORE);
    }

    private SchemaValidationPolicy() {
    }

    public Action checkAttributesAndObjectClasses() {
        return this.checkAttributesAndObjectClasses;
    }

    public SchemaValidationPolicy checkAttributesAndObjectClasses(Action policy) {
        this.checkAttributesAndObjectClasses = policy;
        return this;
    }

    public Action checkAttributeValues() {
        return this.checkAttributeValues;
    }

    public SchemaValidationPolicy checkAttributeValues(Action policy) {
        this.checkAttributeValues = policy;
        return this;
    }

    public Action checkDITContentRules() {
        return this.checkDITContentRules;
    }

    public SchemaValidationPolicy checkDITContentRules(Action policy) {
        this.checkDITContentRules = policy;
        return this;
    }

    public Action checkDITStructureRules() {
        return this.checkDITStructureRules;
    }

    public SchemaValidationPolicy checkDITStructureRules(Action policy, EntryResolver resolver) {
        if (this.checkDITStructureRules.needsChecking() && resolver == null) {
            throw new IllegalArgumentException("Validation of structure rules enabled by resolver was null");
        }
        this.checkDITStructureRules = policy;
        this.checkDITStructureRulesEntryResolver = resolver;
        return this;
    }

    public EntryResolver checkDITStructureRulesEntryResolver() {
        return this.checkDITStructureRulesEntryResolver;
    }

    public Action checkNameForms() {
        return this.checkNameForms;
    }

    public SchemaValidationPolicy checkNameForms(Action policy) {
        this.checkNameForms = policy;
        return this;
    }

    public Action requireSingleStructuralObjectClass() {
        return this.requireSingleStructuralObjectClass;
    }

    public SchemaValidationPolicy requireSingleStructuralObjectClass(Action policy) {
        this.requireSingleStructuralObjectClass = policy;
        return this;
    }

    public Schema adaptSchemaForValidation(Schema schema) {
        return this.checkAttributesAndObjectClasses().needsChecking() ? schema.asStrictSchema() : schema.asNonStrictSchema();
    }

    SchemaValidationPolicy assign(SchemaValidationPolicy policy) {
        this.checkAttributeValues = policy.checkAttributeValues;
        this.checkNameForms = policy.checkNameForms;
        this.checkAttributesAndObjectClasses = policy.checkAttributesAndObjectClasses;
        this.checkDITContentRules = policy.checkDITContentRules;
        this.checkDITStructureRules = policy.checkDITStructureRules;
        this.checkDITStructureRulesEntryResolver = policy.checkDITStructureRulesEntryResolver;
        this.requireSingleStructuralObjectClass = policy.requireSingleStructuralObjectClass;
        return this;
    }

    public static enum Action {
        IGNORE,
        WARN,
        REJECT;


        public boolean isIgnore() {
            return this == IGNORE;
        }

        public boolean isReject() {
            return this == REJECT;
        }

        public boolean isWarn() {
            return this == WARN;
        }

        public boolean needsChecking() {
            return this != IGNORE;
        }
    }

    public static interface EntryResolver {
        public Entry getEntry(DN var1) throws LdapException;
    }
}

