/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StaticUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.NameForm;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.forgerock.opendj.ldap.spi.Indexer;
import org.forgerock.opendj.ldap.spi.IndexingOptions;

final class ObjectIdentifierEqualityMatchingRuleImpl
extends AbstractMatchingRuleImpl {
    ObjectIdentifierEqualityMatchingRuleImpl() {
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence assertionValue) throws DecodeException {
        return ObjectIdentifierEqualityMatchingRuleImpl.getAssertion(schema, "objectIdentifierMatch", assertionValue);
    }

    @Override
    public Collection<? extends Indexer> createIndexers(IndexingOptions options) {
        return Collections.singleton(new Indexer(){

            @Override
            public String getIndexID() {
                return "objectIdentifierMatch";
            }

            @Override
            public void createKeys(Schema schema, ByteSequence value, Collection<ByteString> keys) throws DecodeException {
                String oid = StaticUtils.toLowerCase(value.toString()).trim();
                keys.add(ByteString.valueOfUtf8(oid));
            }

            @Override
            public String keyToHumanReadableString(ByteSequence key) {
                return key.toByteString().toString();
            }
        });
    }

    static Assertion getAssertion(final Schema schema, final String indexId, final ByteSequence assertionValue) {
        return new Assertion(){
            final String oid;
            final List<ByteString> candidates;
            {
                this.oid = StaticUtils.toLowerCase(assertionValue.toString()).trim();
                this.candidates = ObjectIdentifierEqualityMatchingRuleImpl.getCandidates(schema, this.oid);
            }

            @Override
            public ConditionResult matches(ByteSequence normalizedAttributeValue) {
                return ConditionResult.valueOf(this.candidates.contains(normalizedAttributeValue.toByteString()));
            }

            @Override
            public <T> T createIndexQuery(IndexQueryFactory<T> factory) throws DecodeException {
                ArrayList<T> subQueries = new ArrayList<T>(this.candidates.size());
                for (ByteString candidate : this.candidates) {
                    subQueries.add(factory.createExactMatchQuery(indexId, candidate));
                }
                return factory.createUnionQuery(subQueries);
            }
        };
    }

    private static List<ByteString> getCandidates(Schema schema, String oid) {
        ArrayList<ByteString> candidates = new ArrayList<ByteString>(3);
        candidates.add(ByteString.valueOfUtf8(oid));
        if (schema.hasObjectClass(oid)) {
            ObjectClass oc = schema.getObjectClass(oid);
            ObjectIdentifierEqualityMatchingRuleImpl.addCandidates(candidates, oc.getOID(), oc.getNames());
        }
        if (schema.hasAttributeType(oid)) {
            AttributeType at = schema.getAttributeType(oid);
            ObjectIdentifierEqualityMatchingRuleImpl.addCandidates(candidates, at.getOID(), at.getNames());
        }
        if (schema.hasSyntax(oid)) {
            Syntax syntax = schema.getSyntax(oid);
            ObjectIdentifierEqualityMatchingRuleImpl.addCandidates(candidates, syntax.getOID(), Collections.emptyList());
        }
        if (schema.hasMatchingRule(oid)) {
            MatchingRule mr = schema.getMatchingRule(oid);
            ObjectIdentifierEqualityMatchingRuleImpl.addCandidates(candidates, mr.getOID(), mr.getNames());
        }
        if (schema.hasNameForm(oid)) {
            NameForm nf = schema.getNameForm(oid);
            ObjectIdentifierEqualityMatchingRuleImpl.addCandidates(candidates, nf.getOID(), nf.getNames());
        }
        return candidates;
    }

    private static void addCandidates(List<ByteString> candidates, String numericOid, List<String> names) {
        ObjectIdentifierEqualityMatchingRuleImpl.addIfNotPresent(candidates, ByteString.valueOfUtf8(numericOid));
        for (String name : names) {
            ObjectIdentifierEqualityMatchingRuleImpl.addIfNotPresent(candidates, ByteString.valueOfUtf8(StaticUtils.toLowerCase(name)));
        }
    }

    private static void addIfNotPresent(List<ByteString> candidates, ByteString candidate) {
        if (!candidates.contains(candidate)) {
            candidates.add(candidate);
        }
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        String oid = StaticUtils.toLowerCase(value.toString()).trim();
        if (schema.hasObjectClass(oid)) {
            return ByteString.valueOfUtf8(StaticUtils.toLowerCase(schema.getObjectClass(oid).getNameOrOID()));
        }
        if (schema.hasAttributeType(oid)) {
            return ByteString.valueOfUtf8(StaticUtils.toLowerCase(schema.getAttributeType(oid).getNameOrOID()));
        }
        if (schema.hasSyntax(oid)) {
            return ByteString.valueOfUtf8(StaticUtils.toLowerCase(schema.getSyntax(oid).getOID()));
        }
        if (schema.hasMatchingRule(oid)) {
            return ByteString.valueOfUtf8(StaticUtils.toLowerCase(schema.getMatchingRule(oid).getNameOrOID()));
        }
        if (schema.hasNameForm(oid)) {
            return ByteString.valueOfUtf8(StaticUtils.toLowerCase(schema.getNameForm(oid).getNameOrOID()));
        }
        return ByteString.valueOfUtf8(oid);
    }
}

