/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSchemaElement;
import org.forgerock.opendj.ldap.schema.MatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.SchemaUtils;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.opendj.ldap.spi.Indexer;
import org.forgerock.opendj.ldap.spi.IndexingOptions;

public final class MatchingRule
extends AbstractSchemaElement {
    private final String oid;
    private final List<String> names;
    private final boolean isObsolete;
    private final String syntaxOID;
    private MatchingRuleImpl impl;
    private Syntax syntax;
    private Schema schema;

    private MatchingRule(Builder builder) {
        super(builder);
        if (builder.oid == null || builder.oid.isEmpty()) {
            throw new IllegalArgumentException("An OID must be specified.");
        }
        if (builder.syntaxOID == null || builder.syntaxOID.isEmpty()) {
            throw new IllegalArgumentException("Required syntax OID must be specified.");
        }
        this.oid = builder.oid;
        this.names = SchemaUtils.unmodifiableCopyOfList(builder.names);
        this.isObsolete = builder.isObsolete;
        this.syntaxOID = builder.syntaxOID;
        this.impl = builder.impl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MatchingRule) {
            MatchingRule other = (MatchingRule)o;
            return this.oid.equals(other.oid);
        }
        return false;
    }

    public Assertion getAssertion(ByteSequence value) throws DecodeException {
        return this.impl.getAssertion(this.schema, value);
    }

    public Assertion getSubstringAssertion(ByteSequence subInitial, List<? extends ByteSequence> subAnyElements, ByteSequence subFinal) throws DecodeException {
        return this.impl.getSubstringAssertion(this.schema, subInitial, subAnyElements, subFinal);
    }

    public Assertion getGreaterOrEqualAssertion(ByteSequence value) throws DecodeException {
        return this.impl.getGreaterOrEqualAssertion(this.schema, value);
    }

    public Assertion getLessOrEqualAssertion(ByteSequence value) throws DecodeException {
        return this.impl.getLessOrEqualAssertion(this.schema, value);
    }

    public Collection<? extends Indexer> createIndexers(IndexingOptions options) {
        return this.impl.createIndexers(options);
    }

    public String getNameOrOID() {
        if (this.names.isEmpty()) {
            return this.oid;
        }
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getOID() {
        return this.oid;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    public boolean hasName(String name) {
        for (String n : this.names) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameOrOID(String value) {
        return this.hasName(value) || this.getOID().equals(value);
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public ByteString normalizeAttributeValue(ByteSequence value) throws DecodeException {
        return this.impl.normalizeAttributeValue(this.schema, value);
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        buffer.append(this.oid);
        if (!this.names.isEmpty()) {
            Iterator<String> iterator = this.names.iterator();
            String firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append(iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        this.appendDescription(buffer);
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        buffer.append(" SYNTAX ");
        buffer.append(this.syntaxOID);
    }

    void validate(Schema schema, List<LocalizableMessage> warnings) throws SchemaException {
        LocalizableMessage message;
        if (this.impl == null && Schema.getDefaultSchema().hasMatchingRule(this.oid)) {
            this.impl = Schema.getDefaultSchema().getMatchingRule((String)this.oid).impl;
        }
        if (this.impl == null && Schema.getCoreSchema().hasMatchingRule(this.oid)) {
            this.impl = Schema.getCoreSchema().getMatchingRule((String)this.oid).impl;
        }
        if (this.impl == null) {
            MatchingRule defaultMatchingRule = schema.getDefaultMatchingRule();
            if (defaultMatchingRule.impl == null) {
                defaultMatchingRule.validate(schema, warnings);
            }
            this.impl = defaultMatchingRule.impl;
            message = CoreMessages.WARN_MATCHING_RULE_NOT_IMPLEMENTED1.get((Object)this.getNameOrOID(), (Object)schema.getDefaultMatchingRule().getOID());
            warnings.add(message);
        }
        try {
            this.syntax = schema.getSyntax(this.syntaxOID);
        }
        catch (UnknownSchemaElementException e) {
            message = CoreMessages.ERR_ATTR_SYNTAX_MR_UNKNOWN_SYNTAX1.get((Object)this.getNameOrOID(), (Object)this.syntaxOID);
            throw new SchemaException(message, (Throwable)((Object)e));
        }
        this.schema = schema;
    }

    boolean isValidated() {
        return this.schema != null;
    }

    public static final class Builder
    extends AbstractSchemaElement.SchemaElementBuilder<Builder> {
        private String oid;
        private final List<String> names = new LinkedList<String>();
        private boolean isObsolete;
        private String syntaxOID;
        private MatchingRuleImpl impl;

        Builder(MatchingRule mr, SchemaBuilder builder) {
            super(builder, mr);
            this.oid = mr.oid;
            this.names.addAll(mr.names);
            this.isObsolete = mr.isObsolete;
            this.syntaxOID = mr.syntaxOID;
            this.impl = mr.impl;
        }

        Builder(String oid, SchemaBuilder builder) {
            super(builder);
            this.oid(oid);
        }

        public SchemaBuilder addToSchema() {
            return this.getSchemaBuilder().addMatchingRule(new MatchingRule(this), false);
        }

        public SchemaBuilder addToSchemaOverwrite() {
            return this.getSchemaBuilder().addMatchingRule(new MatchingRule(this), true);
        }

        SchemaBuilder addToSchema(boolean overwrite) {
            return overwrite ? this.addToSchemaOverwrite() : this.addToSchema();
        }

        @Override
        public Builder description(String description) {
            return (Builder)this.description0(description);
        }

        @Override
        public Builder extraProperties(Map<String, List<String>> extraProperties) {
            return (Builder)this.extraProperties0(extraProperties);
        }

        @Override
        public Builder extraProperties(String extensionName, String ... extensionValues) {
            return (Builder)this.extraProperties0(extensionName, extensionValues);
        }

        public Builder names(Collection<String> names) {
            this.names.addAll(names);
            return this;
        }

        public Builder names(String ... names) {
            return this.names(Arrays.asList(names));
        }

        public Builder obsolete(boolean isObsolete) {
            this.isObsolete = isObsolete;
            return this;
        }

        public Builder oid(String oid) {
            this.oid = oid;
            return this;
        }

        public Builder syntaxOID(String syntax) {
            this.syntaxOID = syntax;
            return this;
        }

        public Builder implementation(MatchingRuleImpl implementation) {
            this.impl = implementation;
            return this;
        }

        @Override
        public Builder removeAllExtraProperties() {
            return (Builder)this.removeAllExtraProperties0();
        }

        public Builder removeAllNames() {
            this.names.clear();
            return this;
        }

        @Override
        public Builder removeExtraProperty(String extensionName, String ... extensionValues) {
            return (Builder)this.removeExtraProperty0(extensionName, extensionValues);
        }

        public Builder removeName(String name) {
            this.names.remove(name);
            return this;
        }

        @Override
        Builder getThis() {
            return this;
        }
    }
}

