/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.Iterables;
import java.util.Collection;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.AttributeParser;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.requests.AbstractUnmodifiableRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldif.ChangeRecordVisitor;
import org.forgerock.util.Function;
import org.forgerock.util.promise.NeverThrowsException;

final class UnmodifiableAddRequestImpl
extends AbstractUnmodifiableRequest<AddRequest>
implements AddRequest {
    private static final Function<Attribute, Attribute, NeverThrowsException> UNMODIFIABLE_ATTRIBUTE_FUNCTION = new Function<Attribute, Attribute, NeverThrowsException>(){

        public Attribute apply(Attribute value) {
            return Attributes.unmodifiableAttribute(value);
        }
    };

    UnmodifiableAddRequestImpl(AddRequest impl) {
        super(impl);
    }

    @Override
    public <R, P> R accept(ChangeRecordVisitor<R, P> v, P p) {
        return v.visitChangeRecord(p, this);
    }

    @Override
    public boolean addAttribute(Attribute attribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAttribute(Attribute attribute, Collection<? super ByteString> duplicateValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AddRequest addAttribute(String attributeDescription, Object ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AddRequest clearAttributes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAttribute(Attribute attribute, Collection<? super ByteString> missingValues) {
        return ((AddRequest)this.impl).containsAttribute(attribute, missingValues);
    }

    @Override
    public boolean containsAttribute(String attributeDescription, Object ... values) {
        return ((AddRequest)this.impl).containsAttribute(attributeDescription, values);
    }

    @Override
    public Iterable<Attribute> getAllAttributes() {
        return Iterables.unmodifiableIterable(Iterables.transformedIterable(((AddRequest)this.impl).getAllAttributes(), UNMODIFIABLE_ATTRIBUTE_FUNCTION));
    }

    @Override
    public Iterable<Attribute> getAllAttributes(AttributeDescription attributeDescription) {
        return Iterables.unmodifiableIterable(Iterables.transformedIterable(((AddRequest)this.impl).getAllAttributes(attributeDescription), UNMODIFIABLE_ATTRIBUTE_FUNCTION));
    }

    @Override
    public Iterable<Attribute> getAllAttributes(String attributeDescription) {
        return Iterables.unmodifiableIterable(Iterables.transformedIterable(((AddRequest)this.impl).getAllAttributes(attributeDescription), UNMODIFIABLE_ATTRIBUTE_FUNCTION));
    }

    @Override
    public Attribute getAttribute(AttributeDescription attributeDescription) {
        Attribute attribute = ((AddRequest)this.impl).getAttribute(attributeDescription);
        if (attribute != null) {
            return Attributes.unmodifiableAttribute(attribute);
        }
        return null;
    }

    @Override
    public Attribute getAttribute(String attributeDescription) {
        Attribute attribute = ((AddRequest)this.impl).getAttribute(attributeDescription);
        if (attribute != null) {
            return Attributes.unmodifiableAttribute(attribute);
        }
        return null;
    }

    @Override
    public int getAttributeCount() {
        return ((AddRequest)this.impl).getAttributeCount();
    }

    @Override
    public DN getName() {
        return ((AddRequest)this.impl).getName();
    }

    @Override
    public AttributeParser parseAttribute(AttributeDescription attributeDescription) {
        return ((AddRequest)this.impl).parseAttribute(attributeDescription);
    }

    @Override
    public AttributeParser parseAttribute(String attributeDescription) {
        return ((AddRequest)this.impl).parseAttribute(attributeDescription);
    }

    @Override
    public boolean removeAttribute(Attribute attribute, Collection<? super ByteString> missingValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAttribute(AttributeDescription attributeDescription) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AddRequest removeAttribute(String attributeDescription, Object ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replaceAttribute(Attribute attribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AddRequest replaceAttribute(String attributeDescription, Object ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AddRequest setName(DN dn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AddRequest setName(String dn) {
        throw new UnsupportedOperationException();
    }
}

