/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.AbstractSASLBindRequest;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.ExternalSASLBindRequest;
import org.forgerock.opendj.ldap.requests.SASLBindClientImpl;
import org.forgerock.opendj.ldap.responses.BindResult;

final class ExternalSASLBindRequestImpl
extends AbstractSASLBindRequest<ExternalSASLBindRequest>
implements ExternalSASLBindRequest {
    private String authorizationID;

    ExternalSASLBindRequestImpl() {
    }

    ExternalSASLBindRequestImpl(ExternalSASLBindRequest externalSASLBindRequest) {
        super(externalSASLBindRequest);
        this.authorizationID = externalSASLBindRequest.getAuthorizationID();
    }

    @Override
    public BindClient createBindClient(String serverName) throws LdapException {
        return new Client(this, serverName);
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Override
    public String getSASLMechanism() {
        return "EXTERNAL";
    }

    @Override
    public ExternalSASLBindRequest setAuthorizationID(String authorizationID) {
        this.authorizationID = authorizationID;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExternalSASLBindRequest(bindDN=");
        builder.append(this.getName());
        builder.append(", authentication=SASL");
        builder.append(", saslMechanism=");
        builder.append(this.getSASLMechanism());
        builder.append(", authorizationID=");
        builder.append(this.authorizationID);
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class Client
    extends SASLBindClientImpl {
        private final SaslClient saslClient;

        private Client(ExternalSASLBindRequestImpl initialBindRequest, String serverName) throws LdapException {
            super(initialBindRequest);
            try {
                this.saslClient = Sasl.createSaslClient(new String[]{"EXTERNAL"}, initialBindRequest.getAuthorizationID(), "ldap", serverName, null, this);
                if (this.saslClient.hasInitialResponse()) {
                    this.setNextSASLCredentials(this.saslClient.evaluateChallenge(new byte[0]));
                } else {
                    this.setNextSASLCredentials((ByteString)null);
                }
            }
            catch (SaslException e) {
                throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_LOCAL_ERROR, e);
            }
        }

        @Override
        public void dispose() {
            try {
                this.saslClient.dispose();
            }
            catch (SaslException saslException) {
                // empty catch block
            }
        }

        @Override
        public boolean evaluateResult(BindResult result) throws LdapException {
            return this.evaluateSaslBindResult(this.saslClient, result);
        }
    }
}

